/**
 * Copyright mitata ( http://wonderfl.net/user/mitata )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vQy0
 */

// forked from fotografia's forked from: [QuickBox2D] + [Stardust]
// forked from paq's [QuickBox2D] + [Stardust]
package 
{
	import com.actionsnippet.qbox.QuickBox2D;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import idv.cjcat.stardust.common.clocks.SteadyClock;
	
	/**
	 * ...
	 * @author paq89
	 */
	[SWF(width = 465, height = 465, backgroundColor = 0xFFFFFF, frameRate = 60)]
	public class Main extends Sprite 
	{
		private var _emitter:QuickBox2DEmitter;
		private var _qbox:QuickBox2D;
		private var _container:MovieClip;
		
		/*
		 * コンストラクタ
		**/
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			// Box2Dを表示するムービークリップを作成
			_container = new MovieClip();
			addChild(_container);
			
			// Box2Dを初期化
			_qbox = new QuickBox2D(_container);
			_qbox.createStageWalls();
			_qbox.gravity.x = Math.random()*4-4;
			_qbox.gravity.y = Math.random()*4-4;
			_qbox.start();
			
			// エミッターを作成
			_emitter = new QuickBox2DEmitter(new SteadyClock(0.1), _qbox);
			var renderer:QuickBox2DRenderer = new QuickBox2DRenderer();
			renderer.addEmitter(_emitter);
			
			// イベントリスナー
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(e:Event):void 
		{
			// エミッター更新
			_emitter.step();
		}
		
	}
	
}
import com.actionsnippet.qbox.objects.BoxObject;
import com.actionsnippet.qbox.objects.CircleObject;
import com.actionsnippet.qbox.QuickBox2D;
import com.actionsnippet.qbox.QuickObject;
import flash.display.Sprite;
import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.actions.AlphaCurve;
import idv.cjcat.stardust.common.actions.DeathLife;
import idv.cjcat.stardust.common.actions.ScaleCurve;
import idv.cjcat.stardust.common.initializers.Initializer;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.common.initializers.Scale;
import idv.cjcat.stardust.common.initializers.SwitchInitializer;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.common.particles.Particle;
import idv.cjcat.stardust.common.utils.construct;
import idv.cjcat.stardust.common.xml.XMLBuilder;
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.twoD.emitters.Emitter2D;
import idv.cjcat.stardust.twoD.initializers.Initializer2D;
import idv.cjcat.stardust.twoD.initializers.Position;
import idv.cjcat.stardust.twoD.zones.Line;
import idv.cjcat.stardust.twoD.zones.RectZone;

class QuickBox2DEmitter extends Emitter2D
{
	public function QuickBox2DEmitter(clock:Clock, qbox:QuickBox2D):void 
	{
		super(clock);
		
		var obj1:QuickObjectClass = new QuickObjectClass(CircleObject, [qbox, {} ])
		var obj2:QuickObjectClass = new QuickObjectClass(BoxObject, [qbox, {} ])
		var switchInit:SwitchInitializer = new SwitchInitializer([obj1, obj2], [1, 1]);
		
		addInitializer(switchInit);
		addInitializer(new Life(new UniformRandom(100, 0)));
		addInitializer(new Position(new Line(0, 10, 15, 10)));
		addInitializer(new Scale(new UniformRandom(1, 1)));
		
		addAction(new Age());
		addAction(new DeathLife());
		addAction(new AlphaCurve(5, 20));
		addAction(new ScaleCurve(5, 20));
	}
}

class QuickObjectClass extends Initializer2D 
{
	public var quickObjectClass:Class;
	public var constructorParams:Array;
	
	public function QuickObjectClass(quickObjectClass:Class = null, constructorParams:Array = null)
	{
		this.quickObjectClass = quickObjectClass;
		this.constructorParams = constructorParams;
	}
	
	override public function initialize(p:Particle):void
	{
		if (!quickObjectClass) return;
		p.target = construct(quickObjectClass, constructorParams);
	}
}

import flash.display.DisplayObject;
import flash.display.DisplayObjectContainer;
import idv.cjcat.stardust.common.events.EmitterEvent;
import idv.cjcat.stardust.common.particles.Particle;
import idv.cjcat.stardust.common.particles.ParticleIterator;
import idv.cjcat.stardust.common.renderers.Renderer;
import idv.cjcat.stardust.common.xml.XMLBuilder;
import idv.cjcat.stardust.twoD.display.AddChildMode;
import idv.cjcat.stardust.twoD.particles.Particle2D;

class QuickBox2DRenderer extends Renderer
{
	public var qbox:QuickBox2D;
	
	public function QuickBox2DRenderer(qbox:QuickBox2D = null)
	{
		this.qbox = qbox;
	}
	
	override protected function particlesAdded(e:EmitterEvent):void
	{
		//if (!qbox) return;
		
		var particle:Particle2D;
		var iter:ParticleIterator = e.particles.getIterator();
		while (particle = iter.particle as Particle2D)
		{
			var quickObj:QuickObject = particle.target;
			quickObj.x = particle.x;
			quickObj.y = particle.y;
			quickObj.angle = particle.rotation;
			iter.next();
		}
	}
	
	override protected function particlesRemoved(e:EmitterEvent):void
	{
		var particle:Particle;
		var iter:ParticleIterator = e.particles.getIterator();
		while (particle = iter.particle)
		{
			var quickObj:QuickObject = particle.target;
			quickObj.destroy();
			iter.next();
		}
	}
	
	override protected function render(e:EmitterEvent):void
	{
		var particle:Particle2D;
		var iter:ParticleIterator = e.particles.getIterator();
		while (particle = iter.particle as Particle2D)
		{
			var quickObj:QuickObject = particle.target;
			
			//quickObj.x = particle.x;
			//quickObj.y = particle.y;
			quickObj.userData.alpha = particle.alpha;
			if (quickObj is CircleObject)
			{
				quickObj.shape.m_radius = particle.scale;
				quickObj.userData.scaleX = quickObj.userData.scaleY = particle.scale * 2;
			}
			if (quickObj is BoxObject)
			{
				/*quickObj.shape.m_vertices[0].x = -0.5 * particle.scale;
				quickObj.shape.m_vertices[1].x = 1 * particle.scale;
				quickObj.shape.m_vertices[2].x = 1 * particle.scale;
				quickObj.shape.m_vertices[3].x = -0.5 * particle.scale;*/
			}
			iter.next();
		}
	}
}