/**
 * Copyright Thy ( http://wonderfl.net/user/Thy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vQpM
 */

package 
{
   import flash.display.Bitmap;
   import flash.display.BitmapData;
   import flash.display.Sprite;
   import flash.display.StageQuality;
   import flash.events.Event;
   import flash.events.MouseEvent;
   
   /**
    * ...
    * @author Thi
    */
   public class Particulas extends Sprite 
   {
      
      public function Particulas():void 
      {
         if (stage) init();
         else addEventListener(Event.ADDED_TO_STAGE, init);
      }
      
      private function init(e:Event = null):void 
      {
         removeEventListener(Event.ADDED_TO_STAGE, init);
         // entry point
         stage.frameRate = 0
         stage.quality = StageQuality.LOW
         stage.addEventListener(MouseEvent.MOUSE_MOVE, ativar)
         //
         vars()
         
      }
      
      //_____________________________________________________________________________
      private function ativar(e:MouseEvent = null):void
      {
         stage.frameRate = 40
         stage.quality = StageQuality.HIGH
         stage.removeEventListener(MouseEvent.MOUSE_MOVE, ativar)
         stage.addEventListener(Event.MOUSE_LEAVE, desativar)
      }
      
      private function desativar(e:Event = null):void
      {
         stage.frameRate = 0
         stage.quality = StageQuality.LOW
         stage.addEventListener(MouseEvent.MOUSE_MOVE, ativar)
         stage.removeEventListener(Event.MOUSE_LEAVE, desativar)
      }
      //_____________________________________________________________________________
      
      private var Sw:Number = stage.stageWidth, Sh:Number = stage.stageHeight
      
      private var numPart:int = 50
      private var Px:Vector.<Number> = new Vector.<Number>(numPart) // posição x
      private var Py:Vector.<Number> = new Vector.<Number>(numPart) // posição y
      private var Pvx:Vector.<Number> = new Vector.<Number>(numPart) // velo x
      private var Pvy:Vector.<Number> = new Vector.<Number>(numPart) // velo y
      private var Pc:Vector.<Number> = new Vector.<Number>(numPart) // cor
      private function vars():void
      {
         iniVector()
         iniStuff()
         addListeners()
      }
      
      private function iniVector():void
      {
         var i:int = 0
         while (i < numPart)
         {
            Px[int(i)] = Math.random() * Sw1
            Py[int(i)] = Math.random() * Sh1
            Pvx[int(i)] =  Math.random() * 8 - 4
            Pvy[int(i)] =  Math.random() * 8 - 4
            Pc[int(i)] = 0 //uint(Math.random() * 16777215)
            ++i
         }
         Pc[0] = 0xFF0000
         Pc[Pc.length-1] = 0xFF00FF
      }
      
      private var D:BitmapData
      private var B:Bitmap 
      
      private var scale:int = 0
      private var scale_direto:int = 1 << scale
      private var Sw1:Number = stage.stageWidth >> scale, Sh1:Number = stage.stageHeight >> scale
      
      private var VM:Number = 3
      
      private function iniStuff():void
      {
         D = new BitmapData(Sw1, Sh1, false, 0xFFFFFF)
         B = new Bitmap(D, "auto", true)
         B.scaleX = B.scaleY = scale_direto
         stage.addChild(B)
      }
      
      private function addListeners():void
      {
         stage.addEventListener(Event.ENTER_FRAME, ef)
      }
      
      private function ef(e:Event = null):void
      {
         D.lock()
         partRefresh()
         particulasRefresh()
         D.unlock()
      }
      
      private function partRefresh():void
      {
         var X:Number = Px[0]
         var Y:Number = Py[0]
         var VX:Number = Pvx[0]
         var VY:Number = Pvy[0]
         var C:Number = Pc[0]
         
         var DX:Number = mouseX / scale_direto - X
         var DY:Number = mouseY / scale_direto - Y
         var Dist:Number = Math.sqrt(DX * DX + DY * DY)
         
         var MX:Number = VM * DX / Dist
         var MY:Number = VM * DY / Dist
         
         MX = MX < 0? -MX : MX
         MY = MY < 0? -MY : MY
         
         DX /= Dist
         DY /= Dist
         
         VX += DX / Dist
         VY += DY / Dist
         
         if (VX > 0 && VX > MX)
         {
            VX = MX
         }
         else if (VX < 0 && VX < -MX)
         {
            VX = -MX
         }
         if (VY > 0 && VY > MY)
         {
            VY = MY
         }
         else if (VY < 0 && VY < -MY)
         {
            VY = -MY
         }

         
         X += VX
         Y += VY
         
         X = X<0? X + Sw1 : X > Sw1? X - Sw1 : X
         Y = Y<0? Y + Sh1 : Y > Sh1? Y - Sh1 : Y
         
         D.setPixel(X, Y, C)
         
         Px[0] = X
         Py[0] = Y
         Pvx[0] = VX
         Pvy[0] = VY
         Pc[0] = C
         
      }
      
      private function particulasRefresh():void
      {
         
         var i:int = 1
         while (i < numPart)
         {
            var X:Number = Px[int(i)]
            var Y:Number = Py[int(i)]
            var VX:Number = Pvx[int(i)]
            var VY:Number = Pvy[int(i)]
            var C:Number = Pc[int(i)]
            
            var DX:Number = Px[int(i - 1)] - X
            var DY:Number = Py[int(i - 1)] - Y
            var Dist:Number = Math.sqrt(DX * DX + DY * DY)
            
            var MX:Number = VM * DX / Dist
            var MY:Number = VM * DY / Dist
            
            MX = MX < 0? -MX : MX
            MY = MY < 0? -MY : MY
            
            
            VX += DX / Dist
            VY += DY / Dist
            
            if (VX > 0 && VX > MX)
            {
               VX = MX
            }
            else if (VX < 0 && VX < -MX)
            {
               VX = -MX
            }
            if (VY > 0 && VY > MY)
            {
               VY = MY
            }
            else if (VY < 0 && VY < -MY)
            {
               VY = -MY
            }
            
            X += VX
            Y += VY
            
            X = X<0? X + Sw1 : X > Sw1? X - Sw1 : X
            Y = Y<0? Y + Sh1 : Y > Sh1? Y - Sh1 : Y
            
            D.setPixel(X, Y, C)
            
            Px[int(i)] = X
            Py[int(i)] = Y
            Pvx[int(i)] = VX
            Pvy[int(i)] = VY
            Pc[int(i)] = C
            
            ++i
         }   
      }
   }
}