/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vQg6
 */






package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    
    public class Main extends Sprite 
    {
        private var pos:Vector.<Point>;
        private var particles:Vector.<particle>;
        private var canvas:BitmapData;
        private var effectCanvas:BitmapData;
        private var colorTransform:ColorTransform;
        private var canvasRect:Rectangle;
        private var particle_num:Number=1000;
        private var effectMatrix:Matrix;
        private var stageW:Number = stage.stageWidth;
        private var stageH:Number = stage.stageHeight;

        public function Main()
        {
            Initialization();
            LookUpTextPoint();
            createParticles();
            createCanvas();
            addEventListener(Event.ENTER_FRAME, loopHandler);
        }
        
        private function Initialization():void
        {
            stage.quality = StageQuality.BEST;
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            pos = new Vector.<Point>;
            colorTransform = new ColorTransform(0.8, 0.85, 0.9);
            
        }
        private function createParticles():void
        {
            particles = new Vector.<particle>(particle_num);
            particles.fixed = true;
            for (var i:Number = 0; i < particle_num; i++)
            {
                particles[i] = new particle();
                particles[i].pos = new Point(Math.random() * stageW, Math.random() * stageH);
                particles[i].color = 0xffffff * Math.random();
                particles[i].toPos = pos[Math.random() * pos.length >> 0];
            }
            
        }
        
        private function LookUpTextPoint():void
        {
            var myText:TextField = new TextField();
            var myTextFormat:TextFormat = new TextFormat();
            myTextFormat.size = 70;
            myText.defaultTextFormat = myTextFormat;
            myText.autoSize = "left";
            myText.textColor = 0xffffff;
            myText.text = "BRADSEDITO.";
            
            var bmd:BitmapData = new BitmapData(myText.width, myText.height, false,0x000000);
            bmd.draw(myText);    
        
            var cnt:Number = 0;
            var w:Number = myText.width;
            var h:Number = myText.height;
            var step:Number = 3;
            for (var i:Number = 0; i < w; i+=step) 
            {
                for (var j:Number = 0; j < h; j+=step)
                {
                    var checkColor:uint = bmd.getPixel(i, j);
                    if (checkColor != 0x000000)
                    {
                        pos[cnt] = new Point(i, j);
                        pos[cnt].offset((stageW - myText.width)>>1, (stageH - myText.height)>>1);
                        cnt++;
                    }
                }
            }
            bmd.dispose();
        }

        private function createCanvas():void
        {
            canvas = new BitmapData(stageW, stageH, false, 0x000000);
            addChild(new Bitmap(canvas) as Bitmap);
            canvasRect = canvas.rect;
            effectCanvas = new BitmapData(stageW*0.5, stageH*0.5, false);
            var bmp:Bitmap = new Bitmap(effectCanvas, PixelSnapping.ALWAYS, false);
         // bmp.scaleX = bmp.scaleY = 1;
            bmp.smoothing = true;
            bmp.blendMode = BlendMode.ADD;
            addChild(bmp);
            effectMatrix = new Matrix(0.2,0,0,0.2);           
        }
        
        private function loopHandler(e:Event):void 
        {
            canvas.lock();
            canvas.colorTransform(canvasRect, colorTransform);
            
            for (var i:uint = 0; i < particle_num; i++)
            {
                var p:particle = particles[i];
                p.pos.x += (p.toPos.x - p.pos.x) / 20;
                p.pos.y += (p.toPos.y - p.pos.y) / 20;
                canvas.setPixel(p.pos.x, p.pos.y, 0xffffff);
            }
            effectCanvas.draw(canvas, effectMatrix);
            canvas.unlock();
        }
    }
}

import flash.geom.*;
class particle
{
    public var pos:Point;
    public var color:int;
    public var toPos:Point;    
}
    
