/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vQTj
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.net.*;
    import flash.system.*;
    
    import jp.progression.commands.*;
    import jp.progression.commands.net.*;
    import jp.progression.commands.display.*;
    import jp.progression.commands.lists.*;
    import jp.progression.commands.tweens.*;
    
    import org.libspark.betweenas3.*;
    import org.libspark.betweenas3.tweens.*;
    import org.libspark.betweenas3.easing.*;
    
    public class FlashTest extends Sprite {
        private var _container:Sprite = new Sprite();
        public function FlashTest() {
            // write as3 code here..
            stage ? init(null) : addEventListener(Event.ADDED_TO_STAGE,init);
        }
        private function init(e:Event):void{
           var loader:Loader = new Loader();
           loader.contentLoaderInfo.addEventListener(Event.COMPLETE,completeLoadHandler);
           loader.load( new URLRequest("http://assets.wonderfl.net/images/related_images/8/8f/8f9a/8f9af323197bb141cb94a8a52090348976c6f4b9"), new LoaderContext(true) );
           
           _container.x = 220;
           //_container.y = 232;
           addChild(_container);  
        }
        
        private var _spring:Spring;
        private function completeLoadHandler(e:Event):void{
            var content:DisplayObject = LoaderInfo( e.currentTarget ).content;
            content.x = -content.width>>1;
            content.y = -content.height>>1;
            _container.addChild( content );
            
            _spring = new Spring( _container, 232, 0, 232 );
            addEventListener( Event.ENTER_FRAME, update);
            
            _container.addEventListener(MouseEvent.MOUSE_DOWN, downHandler );
        }
        
        private var _isDragging:Boolean = false;
        private function downHandler(e:Event):void{
            _container.startDrag();
            _isDragging = true;
            _container.addEventListener(MouseEvent.MOUSE_UP, upHandler );
            _container.stage.addEventListener(MouseEvent.MOUSE_UP, upHandler );
        }
        private function upHandler(e:Event):void {
            _container.removeEventListener(MouseEvent.MOUSE_UP, upHandler );
            _container.stage.removeEventListener(MouseEvent.MOUSE_UP, upHandler );
            _isDragging = false;
            _container.stopDrag();
        }
        
        private function update(e:Event):void{
            if( !_isDragging ) _spring.update();
            else _spring.setPos();
            
            graphics.clear();
            graphics.lineStyle(1,0xc999999);
            graphics.moveTo(_spring.sx, _spring.sy);
            graphics.lineTo(_spring.tx, _spring.ty);
        }
    }
}

import flash.display.*;
import flash.geom.*;

class Spring {
    private var _strong:Number = 1;
    private var _length:Number  = 232;
    private var _length2:Number = 232;
    private var _target:DisplayObject;
    private var _sx:Number;
    private var _sy:Number;
    private var _vx:Number = 0;
    private var _vy:Number = 0;
    private var _tx:Number;
    private var _ty:Number;
    private const G:Number = 0.98;
    private const F:Number = 0.96;
    
    public function get sx():Number{ return _sx; }
    public function get sy():Number{ return _sy; }
    public function get tx():Number{ return _tx; }
    public function get ty():Number{ return _ty; }
    public function Spring ( target:DisplayObject, sx:Number, sy:Number, length:Number ){
        _target = target;
        _sx = sx;
        _sy = sy;
        
        _tx = _target.x;
        _ty = _target.y;
        
        _length = length;
        _length2 = length*length;
    }
    public function update():void{
        var dx:Number = _tx -_sx;
        var dy:Number = _ty -_sy;
        
        var len:Number  = Math.sqrt( dx*dx + dy*dy );
        var diff:Number = 1 - len / _length;
        if( diff < 0 ) {
            _vx += dx * diff * 0.02;
            _vy += dy * diff * 0.02;
        }
        
        _vx += 0;
        _vy += G;
        
        _vx *= F;
        _vy *= F;
        
        _tx += _vx;
        _ty += _vy;
        
        _target.x = _tx;
        _target.y = _ty;
    }
    
    public function setPos():void{
        _tx = _target.x;
        _ty = _target.y;
    }
}


