/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vQHl
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import net.hires.debug.*;
    
    [SWF(frameRate=60, width=465, height=465)]
    public class UITest extends Sprite
    {
        public static const WINDOW_COLOR:uint = 0x757575;
        public static const WINDOW:int = 2;
        
        private var pixelCanvas:PixelCanvas;    
        
        private var mDown:Boolean;  
        private var mDownX:int;
        private var mDownY:int;
        private var mDownFlag:int;
        private var mDownPixel:Pixel;
        
        private var currentX:int;
        private var currentY:int;
        
        private var window:Vector.<Pixel>;
        
        private var dataField:DataField;
        
        public function UITest()
        {
            pixelCanvas = new PixelCanvas();
            dataField = new DataField();
            window = new Vector.<Pixel>;
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
        }
        
        public function addedToStageHandler($event:Event) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
            
            addChild(pixelCanvas);
            addWindow(5, 5, 40, 30);
            
            addChild(new Stats());
            
            addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        public function mouseDownHandler($mouseEvent:MouseEvent) :void
        {
            mDown = true;
            mDownX = Math.round(stage.mouseX / 5) as int;
            mDownY = Math.round(stage.mouseY / 5) as int;
            mDownPixel = pixelCanvas.getPixelFromTable(mDownX, mDownY);
            mDownFlag = mDownPixel.flag;
        }
        
        public function mouseUpHandler($mouseEvent:MouseEvent): void
        {
            mDown = false;
        }
        
        public function addWindow($x:int, $y:int, $w:int, $h:int) :void
        {
            var $pixel:Pixel;
            
            for (var $cY:int = $y; $cY<$h; $cY++)
            {
                for (var $cX:int = $x; $cX<$w; $cX++)
                {
                    $pixel = pixelCanvas.getPixelFromTable($cX, $cY);
                    ($cX == $x || $cX == $w-1 || $cY == $y || $cY == $h-1) ? $pixel.addCommand({delay:0, color:0x3A3A3A, flag:WINDOW}) :
                                                                             $pixel.addCommand({delay:0, color:WINDOW_COLOR, flag:WINDOW});
                    window.push($pixel);
                }
            }
        }
        
        public function moveWindow($pixel:Pixel, $dX:int, $dY:int) :void
        {
            for (var $:int = 0; $<window.length; $++)
            {
                var $checkDest:Pixel = pixelCanvas.getPixelFromTable(window[$].cX - $dX, window[$].cY - $dY);
                var $retainColor:uint = window[$].color;
                
                ($checkDest.flag != 2) ? window[$].addCommand({delay:0, color:0xDCDCDC, flag:0}) : null;
                window[$] = pixelCanvas.getPixelFromTable(window[$].cX + $dX, window[$].cY + $dY);
                window[$].addCommand({delay:0, color:$retainColor, flag:WINDOW});
            }
        }
        
        public function enterFrameHandler($event:Event) :void
        {
            if (mDown && (mDownX != 0 || mDownY != 0))
            {
                currentX = Math.round(stage.mouseX / 5) as int;
                currentY = Math.round(stage.mouseY / 5) as int;
                
                if (mDownFlag == 2)
                {
                    if (currentX != mDownPixel.cX || currentY != mDownPixel.cY)
                    {
                        moveWindow(mDownPixel, (currentX - mDownX), (currentY - mDownY));    
                        mDownX = currentX;
                        mDownY = currentY;
                        
                    }
                }
            }
        }
    }
}


//tracasseur.display

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.IEventDispatcher;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.text.Font;
import flash.text.TextField;
import flash.text.TextFormat;

class PixelCanvas extends Sprite
{
    public static const PIXEL_STATIC:int = -1;
    public static const PIXEL_ACTIVE:int = 0;
    
    public static var STATIC_COLOR:uint;
    public static var CANVAS_COLOR:uint;
    
    private var _canvas:BitmapData;
    private var _canvasSize:int;
    private var _canvasBmpSize:int;
    private var _canvasClipping:Boolean;
    private var _pixelSize:int;
    private var _pixelDrawTable:Vector.<Vector.<Pixel>>;
    
    public function PixelCanvas($size:int = 465, $pixelSize:int = 5, $clipping:Boolean = true, $canvasColor:uint = 0xDCDCDC, $staticColor:uint = 0) 
    {
        _pixelDrawTable = new Vector.<Vector.<Pixel>>(); 
        _pixelSize = $pixelSize;
        _canvasClipping = $clipping;
        _canvasBmpSize = $size;
        _canvasSize = $size / $pixelSize;
        _canvas = new BitmapData(_canvasBmpSize, _canvasBmpSize, false, CANVAS_COLOR);
        
        CANVAS_COLOR = $canvasColor;
        STATIC_COLOR = $staticColor;
        
        addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
    }
    
    private function addedToStageHandler($event:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);

        initializeCanvas();
        
        addEventListener(Event.ENTER_FRAME, enterFrameHandler);
    }
    
    private function initializeCanvas() :void
    {
        addChild(new Bitmap(_canvas));
        
        initializePixels();
    }
    
    private function initializePixels() :void
    {
        var $command:Object;
        var $size:int = _canvasSize-1;
        
        for (var $y:int = 0; $y < _canvasSize; $y++)
        {
            _pixelDrawTable[$y] = new Vector.<Pixel>;
            
            for (var $x:int = 0; $x < _canvasSize; $x++)
            {
                if (_canvasClipping && ($x == 0 || $y == 0 || $x == $size || $y == $size)) 
                     {$command = {delay:0, color:STATIC_COLOR, flag:PIXEL_STATIC}}
                else {$command = {delay:0, color:CANVAS_COLOR, flag:PIXEL_ACTIVE}}
                
                _pixelDrawTable[$y][$x] = new Pixel(_pixelSize * $x, _pixelSize * $y, _pixelSize, $command);
            }
        }
    }
    
    private function enterFrameHandler($event:Event) :void
    {
        var $pixel:Pixel;
        
        for (var $y:int = 0; $y < _canvasSize; $y++)
        {
            for (var $x:int = 0; $x < _canvasSize; $x++)
            {
                $pixel = _pixelDrawTable[$y][$x];
            
                if ($pixel.commands.length > 0)
                {       
                    if ($pixel.state)
                    {
                        if ($pixel.commands[0].delay > 0) 
                        {
                            $pixel.commands[0].delay--;
                        }else{
                            updatePixel($pixel);
                        }
                    }
                }
            }
        }
    }
    
    private function updatePixel($pixel:Pixel) :void
    {
        var $command:Object = $pixel.commands.shift();
            $pixel.color = $command.color;
            $pixel.flag = $command.flag;
        var $pixelVolume:Rectangle = new Rectangle($pixel.x, $pixel.y, _pixelSize, _pixelSize);
        
        _canvas.lock();
        _canvas.fillRect($pixelVolume, $command.color);
        _canvas.unlock();
        
        $pixel.state = ($command.flag == PIXEL_STATIC) ? false : true;
    }
    
    public function getPixelFromPoint($x:int, $y:int) :Pixel
    {
        $x = ($x / _pixelSize); 
        $y = ($y / _pixelSize); 
        
        return _pixelDrawTable[$y][$x];
    }
    
    public function getPixelFromTable($x:int, $y:int) :Pixel
    {
        return _pixelDrawTable[$y][$x];
    }
    
    public function get canvasSize() :int
    { return _canvasSize }
    public function get canvasBmpSize() :int
    { return _canvasBmpSize }
    public function get canvasClipping() :Boolean
    { return true }    
    public function get pixelSize() :int
    { return _pixelSize }
    public function get pixelDrawTable() :Vector.<Vector.<Pixel>>
    { return _pixelDrawTable }
}

class Pixel
{
    private var _x:int;
    private var _y:int;
    private var _cX:int;
    private var _cY:int;
    private var _size:int;
    private var _flag:int;
    private var _color:uint;
    private var _state:Boolean;
    private var _commands:Vector.<Object>; //{delay:int, color:uint, flag:int}
    
    public function Pixel($x:int, $y:int, $size:int, $command:Object)
    {
        _commands = new Vector.<Object>;
        _commands.push($command);
        _state = true;
        _color = $command.color;
        _flag = $command.flag;
        _size = $size;
        _cY = $y/$size;
        _cX = $x/$size;
        _y = $y;
        _x = $x;
    }
    
    public function get x() :int
    { return _x }
    public function get y() :int
    { return _y }
    public function get cX() :int
    { return _cX }
    public function get cY() :int
    { return _cY }
    public function get size() :int
    { return _size }
    public function get flag() :int
    { return _flag }
    public function get color() :uint
    { return _color }
    public function get state() :Boolean
    { return _state }
    public function get commands() :Object
    { return _commands }
    
    public function set flag($flag:int) :void
    { _flag = $flag }
    public function set color($color:uint) :void
    { _color = $color }
    public function set state($state:Boolean) :void
    { _state = $state }
    public function addCommand($command:Object) :void
    { (_state) ? _commands.push($command) : null }
}

class PixelCommand
{
    public var delay:int;
    public var color:uint;
    public var flag:int;
}

//tracasseur.utils

class DataField extends TextField
{
    private var _x :Number;
    private var _y :Number;
    private var _font :String;
    private var _data :String;
    
    public function DataField($data:String = "", $x:Number = 4, $y:Number = 2, $font:String = "Consolas")
    {
        _x = $x;
        _y = $y;
        _font = $font;
        _data = $data;
        
        addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
    }
        
    private function addedToStageHandler($event:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
        
        multiline = true;
        autoSize = "left";
        selectable = false;
        mouseEnabled = false;
        
        init();
    }
        
    private function init() :void
    {
        x = _x;
        y = _y;
        text = _data;
        
        setTextFormat(new TextFormat(font, null, 0));
    }
        
    public function get font() :String
    { return _font }
    
    public function set font($font:String) :void
    { _font = $font; setTextFormat(new TextFormat(font, null, 0)); }
    public override function set text($data:String) :void
    { super.text = $data; setTextFormat(new TextFormat(font, null, 0)); }
}
