/**
 * Copyright hacker_szoe51ih ( http://wonderfl.net/user/hacker_szoe51ih )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vPxB
 */

package {
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.net.URLRequest;
	import flash.utils.Timer;
	
	[SWF(width="465", height="465", backgroundColor="0x0", frameRate="90")]
	public class PigeonClock extends Sprite
	{
		//表示パーツ
		private var _longDart:Sprite = new Sprite();
	 	private var _shortDart:Sprite = new Sprite();
	 	private var _secDart:Sprite = new Sprite();
	 	private var base:Sprite = new Sprite();
	 	private var body:Sprite = new Sprite();
	 	private var furiko:Sprite = new Sprite();
	 	private var _pigeon:Loader;
	 	private var _pigeon2:Loader;
	 	private var _wakeUpDart:Sprite = new Sprite();
	 	private var _wakeUpPoint:Sprite = new Sprite();
 	
		private var loader:Loader = new Loader();
		//ローダー
		private var _allLoader:DataLoaders = new DataLoaders();
		//時計クラス
		private var _clock:ClockMaster = new ClockMaster();
		//鳩アニメ用タイマー
		private var poppotimer:Timer = new Timer(500);
		private var poppo_counter:int = 0;
		//目ざまし角度
		private var _wakeRotate:int=0;
		
		/**
		 * 鳩時計を作ります。
		 */
		/**
		 * コンストラクタ
		 * データ読み込み→表示オブジェクトを配置→鳩を1回実行→時計スタートの順番
		 */
		public function PigeonClock()
		{
			_step1_dataload(); //ステップ１ データ読み込み
		}
		//ステップ１ データ読み込み
		private function _step1_dataload():void
		{
			//読み込み完了ハンドラ
			_allLoader.addEventListener(Event.COMPLETE, _LoadComplete);
			//読み込み開始
			_allDataLoad();
		}
		//データを読み込む関数
		private function _allDataLoad():void
		{
			_allLoader.addLoadItem("short", "http://assets.wonderfl.net/images/related_images/9/99/99b7/99b704fec21c9b0f884566c0bc88254846a6cc4d");
			_allLoader.addLoadItem("long", "http://assets.wonderfl.net/images/related_images/f/fd/fd7f/fd7f8e2dbebbfa57c0fc50ddc0559cb7cdafc061");
			_allLoader.addLoadItem("sec", "http://assets.wonderfl.net/images/related_images/8/88/88bf/88bf23d320ba18d01c387b89db651eb8319fb483");
			_allLoader.addLoadItem("body", "http://assets.wonderfl.net/images/related_images/f/fc/fc26/fc26d4b361f51da5f33d9fb67b2ef8f2cfe8987f");
			_allLoader.addLoadItem("alarmDart", "http://assets.wonderfl.net/images/related_images/1/1e/1e89/1e89181b840dc5a7c07753bb639f4befac900433");
			_allLoader.addLoadItem("alarmHand", "http://assets.wonderfl.net/images/related_images/0/02/02b9/02b90ab43bc3b1589e4c6efae5b29238ee3f98fd");
			_allLoader.addLoadItem("poppo", "http://assets.wonderfl.net/images/related_images/d/d4/d4f3/d4f3084298d09906edadbeb556ee674cdb615dbc");
			_allLoader.addLoadItem("poppo2", "http://assets.wonderfl.net/images/related_images/e/e4/e477/e47725c6099fae966713995479f422b6181181d3");
			
			_allLoader._loadStart();
		}
		//読み込み完了ハンドラ
		private function _LoadComplete(e:Event):void
		{
			_step2_setItems(); //ステップ2　Displayアイテムの配置
			_step3_setClock(); //ステップ３　時計イベントの設定
			_step4_setArarm(); //ステップ４　アラームの設定
		}
		
		//ステップ2　Displayアイテムの配置
		private function _step2_setItems():void
		{
			//１ 読み込んだデータを、あらかじめ用意したMCに配置する
			//本体
			body.addChild(_allLoader.items.body);
			//長針
			_longDart.addChild(_allLoader.items.long);
				_allLoader.items.long.x = -_allLoader.items.long.width/2;
				_allLoader.items.long.y = -_allLoader.items.long.height+5;
			//短針
			_shortDart.addChild(_allLoader.items.short);
				_allLoader.items.short.x = -_allLoader.items.short.width/2;
				_allLoader.items.short.y = -_allLoader.items.short.height+5;
			//秒針
			_secDart.addChild(_allLoader.items.sec);
				_allLoader.items.sec.y = -_allLoader.items.sec.height;
			//アラーム針
			_wakeUpDart.addChild(_allLoader.items.alarmDart);
				_allLoader.items.alarmDart.x = -_allLoader.items.alarmDart.width/2;
				_allLoader.items.alarmDart.y = -_allLoader.items.alarmDart.height;
			//アラーム針の持ち手
			_wakeUpPoint.addChild(_allLoader.items.alarmHand);
				_allLoader.items.alarmHand.x = -_allLoader.items.alarmHand.width/2;
				_allLoader.items.alarmHand.y = _allLoader.items.alarmHand.height/2+50;
			//鳩
			_pigeon = _allLoader.items.poppo;
			_pigeon2 = _allLoader.items.poppo2;
			
			//2 データが配置されたMCをステージに配置する
			addChild(body);
			 body.addChild(base);
			  base.addChild(_wakeUpDart);
			  base.addChild(_longDart);
			  base.addChild(_shortDart);
			  base.addChild(_secDart);
			 //body.addChild(furiko);
			 body.addChild(_pigeon);
			 body.addChild(_pigeon2);
			base.x = 465/2; base.y = 350;
			_pigeon.x = body.width/2-20-70; _pigeon.y = 200-45;
			_pigeon2.x = body.width/2-20-70-95; _pigeon2.y = 200-45-210;
			_pigeon2.visible = false;
		}
		
		//ステップ3　時計のイベントの設定
		private function _step3_setClock():void
		{
			_secHandler(null);
			_minHandler(null);
			_hourHandler(null);
			_clock.addEventListener(ClockEvent.SECONDS_CHANGED, _secHandler);
			_clock.addEventListener(ClockEvent.MINUTES_CHANGED, _minHandler);
			_clock.addEventListener(ClockEvent.HOURS_CHANGED, _hourHandler);
		}
		private function _secHandler(e:ClockEvent):void
		{
			_secDart.rotation = _clock.secondsDegree;
			_shortDart.rotation = _clock.hoursDegree;
			_longDart.rotation = _clock.minutesDegree;
			//目覚まし機能
			if(Math.abs(_wakeRotate-_shortDart.rotation) == 0) {
				_pigeonPlay(1);
			}
		}
		private function _minHandler(e:ClockEvent):void
		{
			_longDart.rotation = _clock.minutesDegree;
		}
		private function _hourHandler(e:ClockEvent):void
		{
			//_shortDart.rotation = _clock.hoursDegree;
			_pigeonPlay(_clock.hours);
		}
		/**
		 * 鳩の動き／今の時間を参照して、今の時間の回数実行します。
		 */
		private var poppoMax:int;
		private var _pigeonPlayTimer:Timer = new Timer(300);
		private function _pigeonPlay(h:int):void
		{
			poppo_counter = 0;
			poppoMax = h;
			
			_pigeonCoo();
			poppo_counter++;
			poppotimer.addEventListener(TimerEvent.TIMER, poppoNext);
			poppotimer.start();
		}
		private function poppoNext(e:TimerEvent):void
		{
			if(poppo_counter==poppoMax) {
				poppotimer.stop();
				poppotimer.removeEventListener(TimerEvent.TIMER,poppoNext);
			} else {
				_pigeonCoo();
				poppo_counter++;
			}
		}
		private function _pigeonCoo():void {
			_pigeonPlayTimer.addEventListener(TimerEvent.TIMER, pplayTimeHandler);
			_pigeonPlayTimer.start();
			_pigeon2.visible = true;
			_pigeon.visible = false;
		}
		private function pplayTimeHandler(event:TimerEvent):void {
			_pigeon2.visible = false;
			_pigeon.visible = true;
			_pigeonPlayTimer.stop();
			_pigeonPlayTimer.removeEventListener(TimerEvent.TIMER, pplayTimeHandler);	
		}
		/**
		 * 目覚ましの動き／マウスドラッグ回転する針を作ります。
		 * マウスアップのイベントでタイマーをセットします。
		 */
		private function _step4_setArarm():void
		{
			_wakeUpDart.graphics.lineStyle(1,0xFF0000);
			_wakeUpDart.graphics.moveTo(0,0);
			_wakeUpDart.graphics.lineTo(0,-20);
			_wakeUpDart.addChild(_wakeUpPoint);
			_wakeUpPoint.y = -_wakeUpDart.height*0.9;
			_wakeUpPoint.buttonMode=true;
			_wakeUpPoint.addEventListener(MouseEvent.MOUSE_DOWN, downHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP, upHandler);
		}
		private function downHandler(e:MouseEvent):void
		{
			_wakeUpDart.addEventListener(Event.ENTER_FRAME, wakeUpEnterFrame);
		}
		private function wakeUpEnterFrame(e:Event):void
		{
			var dx:Number = base.mouseX - _wakeUpDart.x;
			var dy:Number = base.mouseY - _wakeUpDart.y;
			_wakeUpDart.rotation =Math.atan2(dy,dx)*180/Math.PI+90;
		}
		private function upHandler(e:MouseEvent):void
		{
			_wakeUpDart.removeEventListener(Event.ENTER_FRAME, wakeUpEnterFrame);
			_wakeRotate = _wakeUpDart.rotation;
		}
	}
}
	import flash.display.Sprite;
	import flash.display.Loader;
	import flash.net.URLRequest;
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.display.DisplayObject;
	import flash.display.Bitmap;
	


/**
 *時計を管理するクラス。
 */
class ClockMaster extends EventDispatcher {
	private var _hours:int;
	private var _minutes:int;
	private var _seconds:int;
	private var preSeconds:int;
	private var _dispatcher:DisplayObject;
	public function ClockMaster():void
	{
		_dispatcher = new Sprite();
		_enterFrameHandler(null);
		_dispatcher.addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
	}
	private function _enterFrameHandler(e:Event):void
	{
		var _date:Date = new Date();
		_hours = (_date.getHours());
		_minutes = _date.getMinutes();
		_seconds = _date.getSeconds();
		if (_seconds != preSeconds) { 
			dispatchEvent(new ClockEvent(ClockEvent.SECONDS_CHANGED));
			if (_seconds == 0) { 
				dispatchEvent(new ClockEvent(ClockEvent.MINUTES_CHANGED));
				if (_minutes == 0) {
					dispatchEvent(new ClockEvent(ClockEvent.HOURS_CHANGED));
				}
			}
		}
		preSeconds = _seconds;
	}
	// 時間を返す
	public function get hours():int { return _hours; } 
	public function get minutes():int { return _minutes; }
	public function get seconds():int { return _seconds; }
	// 上位1桁返す
	public function get hoursUpper():int { return _hours / 10; }
	public function get minutesUpper():int { return _minutes / 10; }
	public function get secondsUpper():int { return _seconds / 10; }
	// 下位1桁返す
	public function get hoursLower():int { return _hours % 10; }
	public function get minutesLower():int { return _minutes % 10; }
	public function get secondsLower():int { return _seconds % 10; } 
	//アナログ時計にした時の針の角度を返す。
	public function get hoursDegree():Number {
		return ((_hours % 12) * 30) + (_minutes / 2) + (_seconds/120);
	}
	public function get minutesDegree():Number {
		return (_minutes * 6) + (_seconds / 10);
	}
	public function get secondsDegree():Number {
		return _seconds * 6;
	}
}


/**
 * データ読み込みクラス
 */
 class DataLoaders extends Sprite {
 	private var _counter:int = 0;
 	private var _loadNum:int = 0;
 	public var items:Object = new Object();
 	private var urls:Object = new Object();
 	public static var LOADCOMPLETE:String = "loadComp";
 	public function DataLoaders() {
 		
 	}
 	public function addLoadItem(_name:String,_url:String):void
 	{
 		items[_name]=new Loader();
 		urls[_name]=_url;
 		_loadNum++;
 	}
 	public function _loadStart():void
 	{
 		var i:String;
 		for(i in items) {
 			var loderUnit:Loader = items[i];
 			var urlUnit:String = urls[i];
 			loderUnit.contentLoaderInfo.addEventListener(Event.COMPLETE, loadCompHandler);
 			loderUnit.load(new URLRequest(urlUnit));
 		}
 	}
 	private function loadCompHandler(e:Event):void
 	{
 		///if(e.target.content is Bitmap)
 		//	Bitmap(e.target.content).smoothing = true;
 		_counter++;
 		if(_counter == _loadNum){
 			dispatchEvent(new Event(Event.COMPLETE));
 		}
 	}
 }
 
 /**
 *時計イベントクラス
 */
 class ClockEvent extends Event {
 	public static const HOURS_CHANGED:String = "hoursChanged";
 	public static const MINUTES_CHANGED:String = "minutesChanged";
 	public static const SECONDS_CHANGED:String = "secondsChanged";
 	public function ClockEvent(type:String, bubbles:Boolean=false, cancelable:Boolean=false){
 		super(type, bubbles, cancelable);
 	}
 	public override function clone():Event { 
 		return new ClockEvent(type, bubbles, cancelable);
 	}
 	public override function toString():String{ 
 		return formatToString("ClockEvent", "type", "bubbles", "cancelable", "eventPhase");
 	} 
 }
 