/**
 * Copyright yurij.shaulov ( http://wonderfl.net/user/yurij.shaulov )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vOin
 */

// forked from NewKrok's Flag with reflection
// forked from NewKrok's forked from: forked from: Chapter 37 Example 13
// forked from maxhirez's forked from: Chapter 37 Example 13
// forked from actionscriptbible's Chapter 37 Example 13
package {
  import flash.system.LoaderContext;
  import flash.display.*;
  import flash.events.Event;
  import flash.filters.DisplacementMapFilter;
  import flash.filters.DisplacementMapFilterMode;
  import flash.geom.*;
  import flash.net.URLRequest;
  [SWF(backgroundColor="#000000",frameRate="60")]
  public class ch37ex13 extends Sprite {
    protected const FLAG_WIDTH:Number = 380, FLAG_HEIGHT:Number = 250;
    protected const WIND_SPEED:Number = -5;
    protected const DISPLACEMENT:Number = 50;
    protected const OCTAVES:int = 3;
    protected const SHIFT_COLORS:ColorTransform = new ColorTransform(2, 2, 2, 1, -128, -128, -128, 0);
    protected var flag:DisplayObject;
    protected var fadeOutWave:Shape;
    protected var map:BitmapData;
    protected var offsets:Array;
    protected var perlinSeed:Number;
    protected var displacementFilter:DisplacementMapFilter;
    public function ch37ex13() {
      loadImage ( "http://assets.wonderfl.net/images/related_images/c/c4/c447/c447f85f2cc5a6ac335013476890650dcbbe1d48", onLoadComplete )
    }
    
    private function loadImage ( $url:String, $onComplete:Function ) :void {
        var imageLoader:Loader = new Loader ();
        imageLoader.contentLoaderInfo.addEventListener ( Event.COMPLETE, $onComplete );
        var image:URLRequest = new URLRequest ( $url );
        imageLoader.load ( image, new LoaderContext ( true ) );
        graphics.beginFill ( 0x00CCFF, 1 );
        graphics.drawRect ( 0, 0, 465, 250 );
        graphics.endFill();
        graphics.beginFill ( 0x0066CC, 1 );
        graphics.drawRect ( 0, 250, 465, 250 );
        graphics.endFill();
    }
    
    protected function onLoadComplete(event:Event):void {
      flag = LoaderInfo(event.target).content;
      flag.width = FLAG_WIDTH;
      flag.height = FLAG_HEIGHT;
      flag.x = stage.stageWidth / 2 - flag.width / 2;
      flag.y = 10
      map = new BitmapData(FLAG_WIDTH, FLAG_HEIGHT, false, 0);
      displacementFilter = new DisplacementMapFilter(map, new Point(),
          BitmapDataChannel.RED, BitmapDataChannel.RED,
          DISPLACEMENT*1.5, DISPLACEMENT,
          DisplacementMapFilterMode.COLOR);
      addChild(flag);
      flag.filters = [displacementFilter];
      perlinSeed = int(Math.random() * int.MAX_VALUE);
      offsets = new Array();
      for (var i:int = 0; i < OCTAVES; i++) offsets[i] = new Point();
      
      fadeOutWave = new Shape();
      var m:Matrix = new Matrix();
      m.createGradientBox(FLAG_WIDTH/2, FLAG_HEIGHT);
      fadeOutWave.graphics.beginGradientFill(GradientType.LINEAR, [0x808080, 0x808080], [1, 0], [0, 255], m);
      fadeOutWave.graphics.drawRect(0, 0, FLAG_WIDTH/2, FLAG_HEIGHT);
      fadeOutWave.graphics.endFill();
      
      var shadeBitmap:Bitmap = new Bitmap(map);
      shadeBitmap.height = FLAG_HEIGHT + DISPLACEMENT*2;
      shadeBitmap.width = FLAG_WIDTH + DISPLACEMENT;
      shadeBitmap.y = -DISPLACEMENT;
      shadeBitmap.blendMode = BlendMode.OVERLAY;
      shadeBitmap.alpha = 0.4;
      
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    protected function onEnterFrame(event:Event):void {
      for (var i:int = 0; i < OCTAVES; i++) {
        offsets[i].x += Math.pow((1+i), 0.2) * WIND_SPEED;
      }
      map.perlinNoise(map.width, map.height * 6, OCTAVES, perlinSeed, false, true, 0, true, offsets);
      map.colorTransform(map.rect, SHIFT_COLORS);
      map.draw(fadeOutWave);
      displacementFilter.mapBitmap = map;
      flag.filters = [displacementFilter];
      Reflection.generate ( flag, 100, .8, 10 );
    }
  }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.DisplayObject;
import flash.display.MovieClip
import flash.geom.Matrix;
import flash.geom.Rectangle
import flash.geom.ColorTransform;
class Reflection {
    
    private static var transformMatrix:    Matrix
    private static var ct:                ColorTransform = new ColorTransform ()
            
    private static var reflections:        Array = new Array ()
    
    private static const rotate:        Number = .5 * Math.PI
    
    public function Reflection () :void {
    }        
    
    /**
     * Make reflect for displayobject
     * @param Target The selected displayobject
     * @param Height The height of reflection
     * @param Alpha The starting Alpha
     * @param YOffset The y offset of reflection
     * @param AlphaStep The step of alpha decrease ( the lower is better )
     */
    public static function generate ( Target:DisplayObject, Height:Number = 100, Alpha:Number = .8, YOffset:Number = 0, AlphaStep:Number = 1 ) :void {
        
        var selectedReflect:Object = getReflectionInfo ( Target )
        if ( selectedReflect )
            selectedReflect.reflection.bitmapData = new BitmapData ( Target.width, Height, true, 0x60 )
        else {
            reflections.push ( { reflection: new Bitmap ( new BitmapData ( Target.width, Height, true, 0x60 ) ) , target: Target } )
            selectedReflect = reflections[reflections.length - 1] 
        }
        transformMatrix = new Matrix ()
        transformMatrix.scale ( 1, -1 )
        transformMatrix.translate ( 0, Target.height )
        selectedReflect.reflection.bitmapData.draw ( Target, transformMatrix )
        
        selectedReflect.reflection.x = Target.x
        selectedReflect.reflection.y = Target.y + Target.height + YOffset

        var rec:Rectangle = new Rectangle ( 0, 0, Target.width, AlphaStep )
        var ratio:Number = Alpha / Height
        var i:int = 0
        while ( i < Height ) {
            rec.y = i
            ct.alphaMultiplier = Alpha - ( i * ratio )
            selectedReflect.reflection.bitmapData.colorTransform ( rec, ct )
            i += AlphaStep
        }
        
        Target.parent.addChild ( selectedReflect.reflection )
    
    }

    private static function getReflectionInfo ( Target:DisplayObject ) :Object {
    
        for each ( var info:Object in reflections ) {
            if ( info.target == Target )
                return info
        }
        
        return null
        
    }
    
    /**
     * Remove reflection from target
     * @param Target The selected target.
     */
    public static function remove ( Target:DisplayObject ) :void {
    
        var i:int = 0
        while ( i < reflections.length ) {
            if ( reflections[i].target == Target ) {
                Target.parent.removeChild ( reflections[i].reflection )
                reflections.splice ( i, 1 )
                break
            }
            i++
        }
        
    }
    
}