/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vNNy
 */

// forked from k__'s flash on 2009-5-25

package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import org.papervision3d.cameras.*;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.render.*;
    import org.papervision3d.scenes.*;
    import org.papervision3d.view.*;
    import org.papervision3d.lights.*;
    
    public class Main extends Sprite {
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var viewport:Viewport3D;
        private var renderer:BasicRenderEngine;
        private var objects:Array = [];
        private var materials:Array = [];
        private var light:PointLight3D;

        public function Main() {
            //bg
            graphics.beginFill(0x000000);
            graphics.drawRect(0,0,500,500);
            scene = new Scene3D();
            //camera
            camera = new Camera3D();
            camera.x = camera.y = 0;
            camera.z = -1000;
            camera.focus = 100;
            camera.zoom = 10;
            //vieport
            viewport = new Viewport3D(500,500);
            addChild(viewport);

            //renderer
            renderer = new BasicRenderEngine();

            //光源
            light = new PointLight3D();
            light.x = 100;
            light.y = 100;
            light.z = -100;
            
            scene.addChild(light);

            // create materials
            
            var bmp:BitmapData = new BitmapData(100,100);
            bmp.noise(0);
            var bmp2:BitmapData = new BitmapData(100,100);
            bmp2.perlinNoise(20,20,3,0,true,true,3);
            var bmp3:BitmapData = tex();
            var ar:Array = new Array();
            //var bm4:BitmapData = func2(bmp3,1*16,0,16,16);
            for(i=0;i<16;i++){
                for(j=0;j<3;j++){
                    var bm4:BitmapData = func2(bmp3,i*16,j*16,16,16);
                    ar.push(bm4);
                    materials.push(new BitmapMaterial(bm4,true));
                }
            }
    
            //create objects
            var cnt:int = 0;
            var mList:MaterialsList;
            var object:DisplayObject3D;
            for (var j:uint = 0; j <= 300; j += 100) {
                for (var i:uint = 0; i <= 300; i += 100) {
                    mList= new MaterialsList();
                    mList.addMaterial(materials[1+(cnt*3) % materials.length],"all");
                    mList.addMaterial(materials[(cnt*3) % materials.length],"top");
                    mList.addMaterial(materials[2+(cnt*3) % materials.length],"bottom");
                    
                    object=new Cube(mList,50,50,50,1,1,1);//キューブ
                    
                    cnt++;
                    //位置
                    object.x=i - 150;
                    object.y=j - 150;
                    objects.push(object);//追加
                    scene.addChild(object);//表示
                }
            }
            stage.addEventListener(Event.ENTER_FRAME, drawPapervision3d);
        }

        private function drawPapervision3d(e:Event):void {
            for (var i:uint = 0; i < objects.length; i ++) {
                objects[i].rotationX+=1;
                objects[i].rotationY+=1;
                objects[i].rotationZ+=1;
            }
            renderer.renderScene(scene, camera, viewport);
        }
        
        
        
        //ビットマップ切り出し
        private function func2(res:BitmapData,x:int,y:int,w:int,h:int):BitmapData{
            var dat:BitmapData = new BitmapData(w,h);
            var rect:Rectangle = new Rectangle(x,y,w,h);
            var ar:Vector.<uint> = res.getVector(rect);
            
            for(var i:int=0;i<w;i++){
                for(var j:int=0;j<h;j++){
                    var col:int = ar[i+j*w];
                    dat.setPixel32(i,j,col);
                }

            }

            return dat;
        }
                
        private function tex():BitmapData{
            initTexMap();
            var dat:BitmapData = new BitmapData(16*16,16*3,false,0xffffff);
            dat.lock();
            for ( var i:int = 1; i < 16; i++) {//ブロックの種類
                //var br:int = 255 - ((Math.random() * 96) | 0);
                for ( var y:int = 0; y < 16 * 3; y++) {
                    for ( var x:int = 0; x < 16; x++) {
                        var col:int = texmap[x + y * 16 + i * 256 * 3];
                        dat.setPixel32(x+(16*i),y,col);
                    }
                }
            }
            dat.unlock();
            return dat;
            

        }

        
        //テクスチャデータ
        private var texmap: Vector.<int> = new Vector.<int>(16 * 16 * 3 * 16, true);        
        //テクスチャ生成
        private function initTexMap():void {
            for ( var i:int = 1; i < 16; i++) {//ブロックの種類
                var br:int = 255 - ((Math.random() * 96) | 0);
                for ( var y:int = 0; y < 16 * 3; y++) {
                    for ( var x:int = 0; x < 16; x++) {
                        var color:int = 0x966C4A;
                        if (i == 4)color = 0x7F7F7F;
                        
                        if (i != 4 || ((Math.random() * 3) | 0) == 0) {
                            br = 255 - ((Math.random() * 96) | 0);
                        }
                        
                        if ((i == 1 && y < (((x * x * 3 + x * 81) >> 2) & 3) + 18)) {
                            color = 0x6AAA40;
                        }
                        else if ((i == 1 && y < (((x * x * 3 + x * 81) >> 2) & 3) + 19)) {
                            br = br * 2 / 3;
                        }
                        
                        if (i == 7) {//木
                            color = 0x675231;
                            if (x > 0 && x < 15
                                && ((y > 0 && y < 15) || (y > 32 && y < 47))) {
                                color = 0xBC9862;
                                var xd:int = (x - 7);
                                var yd:int = ((y & 15) - 7);
                                if (xd < 0)
                                xd = 1 - xd;
                                if (yd < 0)
                                yd = 1 - yd;
                                if (yd > xd)
                                xd = yd;

                                br = 196 - ((Math.random() * 32) | 0) + xd % 3 * 32;
                            } else if (((Math.random() * 2) | 0) == 0) {
                                br = br * (150 - (x & 1) * 100) / 100;
                            }
                        }

                        if (i == 5) {//レンガ
                            color = 0xB53A15;
                            if ((x + (y >> 2) * 4) % 8 == 0 || y % 4 == 0) {
                                color = 0xBCAFA5;
                            }
                        }
                        if(i == 10){
                            color = 0xeecc99;
                        }

                        
                        if (i == 9) {//水
                            color = 0x4040ff;
                        }
                        var brr:int = br;
                        if (y >= 32)
                        brr /= 2;

                        if (i == 8) {//葉っぱ
                            color = 0x50D937;
                            if (((Math.random() * 2) | 0) == 0) {
                                color = 0;
                                brr = 255;
                            }
                        }

                        var col:int = (((color >> 16) & 0xff) * brr / 255) << 16
                        | (((color >> 8) & 0xff) * brr / 255) << 8
                        | (((color) & 0xff) * brr / 255);
                        texmap[x + y * 16 + i * 256 * 3] = col;//ドットカラー
                    }//for
                }//for
            }//for
        }//function


    }
}