/**
 * Copyright chutaicho ( http://wonderfl.net/user/chutaicho )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vNMK
 */

//--------------------------------------------------
// title : wire
// 
// 曲線の練習
//--------------------------------------------------
package 
{
    import __AS3__.vec.Vector;
    
    import flash.display.GradientType;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.geom.Matrix;
    import flash.utils.Timer; 
    
    [SWF(backgroundColor="0x000000", frameRate="30")]
    public class DrawCode01 extends Sprite
    {    
        private const DOTS_MAX:Number = 30; 
		
	private var _dotNumber:Number = 0;
	private var _dots:Vector.<Dot>;
        
        public function DrawCode01()
        {
	    init();
        }
        private function init():void
        {
           _dots = new Vector.<Dot>();
			
            var timer:Timer = new Timer(100, 0);
	    timer.addEventListener(TimerEvent.TIMER, createDot);
	    timer.start();
			
	    addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        private function createDot(e:TimerEvent):void 
        {
	    var dot:Dot = new Dot();
	    dot.x = mouseX;
	    dot.y = mouseY;
	    addChild(dot);
			
	    _dots.push(dot);	
				
	    if (_dotNumber >= DOTS_MAX) 
	    {
		var target:Dot = _dots.shift();
		removeChild(target);
		target = null;
	    }	
			
	    _dotNumber ++;	
	}
		
        private function enterFrameHandler (e:Event):void
	{		
	    graphics.clear();
	    
	    var l:int = _dots.length;
	    for(var i:int = l-1; i > 0; i-- )
	    {
				
		var dot:Dot = _dots[i];
		dot.upDate();

                // 下についたら跳ね返る
		if (dot.y > stage.stageHeight - dot.rad ) 
		{
		    dot.y = stage.stageHeight - dot.rad;
		    dot.speedY *= -1;
		}
				
		if( i == l-1 )
		{
		    graphics.moveTo(dot.x, dot.y);
		}
		else
		{
		    var dotB:Dot = _dots[i-1];
		    var mx:Number = dot.x + (dotB.x - dot.x)*.8;
		    var my:Number = dot.y + (dotB.y - dot.y)*.8;
		    graphics.lineStyle(1, 0xFFFFFF, 1);
		    graphics.curveTo(dot.x, dot.y, mx, my);				
		}				
	    }				
        }
    }
}

import flash.display.Sprite;

/**
*
* 円のクラス
*/   
class Dot extends Sprite
{
    private const GRAVITY:Number  = 0.5; // 重力
    private const FRICTION:Number = 0.98; // 減速抵抗
    
    public var rad:Number = 5;
    public var speedX:Number;
    public var speedY:Number;
    public var gravity:Number;
    
    public function Dot()
    {
    	init();
    }
    private function init():void
    {
        var rand:Number = Math.random() * 2;
	var angle:Number = Math.random()*Math.PI*2;
		
	speedX = Math.cos(angle) * rand;
	speedY = Math.sin(angle) * rand;
        
        graphics.beginFill(0xFFFFFF, 1);
	graphics.drawCircle(0, 0, rad);
	graphics.endFill();    	
    }
    public function upDate():void
    {
    	speedY += GRAVITY;
				
	speedX *= FRICTION;
	speedY *= FRICTION;
		
	this.x += speedX;
	this.y += speedY;
    }
}