/**
 * Copyright insocium ( http://wonderfl.net/user/insocium )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vLi5
 */

/**
 * Copyright insocium ( http://wonderfl.net/user/insocium )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jZPV
 */

/**

 * Copyright zob ( http://wonderfl.net/user/zob )

 * MIT License ( http://www.opensource.org/licenses/mit-license.php )

 * Downloaded from: http://wonderfl.net/c/uRNO

 */



package

{

    import flash.display.*;

    import flash.filters.*;

    import flash.events.*;

    import flash.net.*;

    import flash.utils.*;

    import flash.geom.*;

    import flash.text.*;

    import flash.system.*;

    import flash.ui.*;

    import flash.media.*;

    import net.hires.debug.Stats;

    

    [SWF(width=1600,height=465,backgroundColor=0x000000,frameRate=60)]

    public class galaxy extends Sprite

    {

        // data

        public var bmpd:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight);

        private var bmp:Bitmap = new Bitmap(bmpd);

        

        // objects

        private var stars:Array = new Array();

        private var starLimit:int = 2000;

        private var SPF:int = 20; // Star Per Frame

        private var damp:Number = 0.7;

        private var speed:Number = 0.5;

        private var focalLength:Number = 1000;

        private var cp:Dot = new Dot(stage.stageWidth/2, stage.stageHeight/2);

        

        // sounds

        private var sound:Sound;

        private var FFTswitch:Boolean = false;

        private var bytes:ByteArray = new ByteArray();

        private var byteTotal:Number = 0;

        

        // effects

        private var blurEffect:BlurFilter = new BlurFilter(1.3,1.3,3);

        private var colors:Array = [0xFFFFFF,0x333333,0x333333];

        private var alphas:Array = [1,0,0];

        private var ratios:Array = [0,64,255];

        private var m:Matrix = new Matrix();

        private var light:Sprite = new Sprite();

        private var lightRatio:Number = 48;

        private var blendSwitch:Number = 0;

        

        public function galaxy()

        {

            addChild(new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x0)));
            
            addChild(light);

            addChild(bmp);

            bmpd.fillRect(bmpd.rect, 0x0);

            m.translate(stage.stageWidth/2, stage.stageHeight/2);

            init();

        }

        

        private function init():void

        {

            sound = new Sound();

            var context:SoundLoaderContext = new SoundLoaderContext(1,true);

            var req:URLRequest = new URLRequest("http://listen2.myradio24.com:9000/8304");

            var soundChannel:SoundChannel=new SoundChannel();

            sound.load(req, context);

            soundChannel = sound.play(0, 9999);

            stage.addEventListener(Event.ENTER_FRAME, processing);

        }

        

        private function processing(e:Event):void

        {

            update();

            paint();

        }

        

        private function update():void

        {

            var i:int = 0;

            SoundMixer.computeSpectrum(bytes, FFTswitch, 0);

            

            byteTotal = 0;

            for(i = 0; i < 512; i++)

            {

                byteTotal += Math.abs(bytes.readFloat());

            }

            byteTotal /= 512;

            speed = 0.5 + 80 * byteTotal;



            if(300 * byteTotal > lightRatio) lightRatio = 400 * byteTotal;

            lightRatio -= (lightRatio-32) * 0.03333333;

            

            ratios[1] = lightRatio;

            with(light.graphics)

            {

                clear();

                beginGradientFill(GradientType.RADIAL,colors,alphas,ratios,m);

                drawRect(0,0,stage.stageWidth,stage.stageHeight);

                endFill();

            }

            

            if(byteTotal > blendSwitch) blendSwitch = byteTotal;

            blendSwitch *= 0.9;

            

            if(blendSwitch > 0.1)

                bmp.blendMode = BlendMode.ADD;

            else

                bmp.blendMode = BlendMode.HARDLIGHT;

            

            for(i = 0; i < SPF; i++)

            {

                if(stars.length < starLimit)

                    if(Math.random() * Math.random() < 0.5)

                        stars.push(new Dot(Math.random() * 1465, Math.random() * 465, 1000));

                    else

                        stars.push(new Dot(-150 + Math.random() * 800, -150 + Math.random() * 800, 1000));

            }

            

            for(i = 0; i < stars.length; i++)

            {

                stars[i].oz = stars[i].z;

                stars[i].vz += speed;

                stars[i].vz *= damp;

                stars[i].z -= stars[i].vz;

            }

        }

        

        private function paint():void

        {

            bmpd.lock();

            bmpd.applyFilter(bmpd, bmpd.rect, new Point(), blurEffect);

            

            var i:int = 0;

            var scaleRatio:Number = 0;

            var px:Number = 0;

            var py:Number = 0;

            var ox:Number = 0;

            var oy:Number = 0;

            var alphaC:uint = 0;

            var color:uint = 0;

            var ratio:Number = 0;

            for(i = 0; i < stars.length; i++)

            {

                color = 0xFF000000;

                scaleRatio = focalLength/(focalLength + stars[i].z);

                px = (stars[i].x - cp.x) * scaleRatio + cp.x;

                py = (stars[i].y - cp.y) * scaleRatio + cp.y;

                

                if(px > stage.stageWidth || px < 0 || py < 0 || py > stage.stageHeight)

                {

                    stars.splice(i, 1);

                    i--;

                } else {

                    scaleRatio = focalLength/(focalLength + stars[i].oz);

                    ox = (stars[i].x - cp.x) * scaleRatio + cp.x;

                    oy = (stars[i].y - cp.y) * scaleRatio + cp.y;

                    ratio = Math.abs(1000-stars[i].z)/2000;

                    color += (0xAA + (0x33-0xAA) * ratio);

                    color += (0xAA + (0xCC-0xAA) * ratio) << 8;

                    color += (0xAA + (0xFF-0xAA) * ratio) << 16;

                    lineFast(bmpd, int(px), int(py), int(ox), int(oy), color);

                }

            }

            

            bmpd.unlock();

        }

        

        public function lineFast(target:BitmapData, x0:int, y0:int, x1:int, y1:int, color:uint):void

        {    

            var pix      :uint = color;

            var dy       :int = y1 - y0;

            var dx       :int = x1 - x0;

            var stepx    :int;

            var stepy    :int;

            var fraction :int;

            

            if (dy < 0) { dy = -dy;  stepy = -1; } else { stepy = 1; }

            if (dx < 0) { dx = -dx;  stepx = -1; } else { stepx = 1; }

            dy <<= 1;

            dx <<= 1;

            target.setPixel32(x0, y0, pix);

            if (dx > dy)

            {

                fraction = dy - (dx >> 1);

                while (x0 != x1)

                {

                    if (fraction >= 0)

                    {

                        y0 += stepy;

                        fraction -= dx;

                    }

                    x0 += stepx;

                    fraction += dy;

                    target.setPixel32(x0, y0, pix);

                }

            } else {

                fraction = dx - (dy >> 1);

                while (y0 != y1)

                {

                    if (fraction >= 0)

                    {

                        x0 += stepx;

                        fraction -= dy;

                    }

                    y0 += stepy;

                    fraction += dx;

                    target.setPixel32(x0, y0, pix);

                }

            }

        }

    }

}



class Dot

{

    public var x:Number = 0;

    public var y:Number = 0;

    public var z:Number = 0;

    public var vx:Number = 0;

    public var vy:Number = 0;

    public var vz:Number = 0;

    public var oz:Number = 0; 

    

    public function Dot(px:Number=0,py:Number=0, pz:Number=0)

    {

        x = px;

        y = py;

        z = pz;

    }

}