/**
 * Copyright mwelsh ( http://wonderfl.net/user/mwelsh )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vLcQ
 */


package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class FlashTest extends Sprite {
        static private const GRID_WIDTH : uint = 10;
        static private const GRID_HEIGHT : uint = 10;
        
        private var cells : Array;
        private var tickTimer : uint;
        
        public function FlashTest() {
            // create grid
            var x:uint;
            var y:uint;
            cells = new Array();
            for( x = 0; x < GRID_WIDTH; x++ )
            {
                cells[x] = new Array();
                for( y = 0; y < GRID_HEIGHT; y++ )
                {
                    var cell : Cell = new Cell();
                    cell.x = x * 25;
                    cell.y = y * 25;
                    addChild( cell );
                    cells[x][y] = cell;
                }

            }

            addEventListener( Event.ENTER_FRAME, onEnterFrame );
        }
        
        private function onEnterFrame( event : Event ) : void
        {
            tickTimer++;
            if( tickTimer >= 10 )
            {
                tickTimer = 0;
                
                tickCells();
            }

        }
        
        private function tickCells() : void
        {
            for( x = 0; x < GRID_WIDTH; x++ )
            {
                for( y = 0; y < GRID_HEIGHT; y++ )
                {
                    var cell : Cell = cells[x][y];
                    cell.oldState.up = cell.state.up;
                    cell.oldState.down = cell.state.down;
                    cell.oldState.left = cell.state.left;
                    cell.oldState.right = cell.state.right;
                    cell.state.up = false;
                    cell.state.down = false;
                    cell.state.left = false;
                    cell.state.right = false;
                }
            }
            
            for( x = 0; x < GRID_WIDTH; x++ )
            {
                for( y = 0; y < GRID_HEIGHT; y++ )
                {
                    cell = cells[x][y];
                    if( x < GRID_WIDTH-1 && cells[x+1][y].oldState.left )
                    {
                        cell.blink();
                        cell.state.left = true;
                        
                    }
                    if( x > 0 && cells[x-1][y].oldState.right )
                    {
                        cell.blink();
                        cell.state.right = true;
                    }
                    if( y < GRID_HEIGHT-1 && cells[x][y+1].oldState.up )
                    {
                        cell.blink();
                        cell.state.up = true;
                    }
                    if( y > 0 && cells[x][y-1].oldState.down )
                    {
                        cell.blink();
                        cell.state.down = true;
                    }
                }
            }

        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.ColorTransform;

class CellState
{
    public var up : Boolean;
    public var down : Boolean;
    public var left : Boolean;
    public var right : Boolean;
}



class Cell extends Sprite
{
    public var state : CellState;
    public var oldState : CellState;
    public var color : ColorTransform;

    public function Cell()
    {
        super();
        state = new CellState();
        oldState = new CellState();
        
        graphics.beginFill(0x110000);
        graphics.drawRect( 0, 0, 20, 20 );
        graphics.endFill();

        color = new ColorTransform();        
        
        buttonMode = true;
        
        addEventListener( MouseEvent.MOUSE_DOWN, onMouseDown );
        addEventListener(Event.ENTER_FRAME, onEnterFrame );
        
    }
    
    private function onMouseDown( e : MouseEvent ) : void
    {
        blink();
        state.up = state.down = state.left = state.right = true;
    }

    public function blink() : void
    {
        color.redOffset = 255;
    }

    private function onEnterFrame( e : Event ) : void
    {
        color.redOffset -= 4;
        if( color.redOffset < 0 ) color.redOffset = 0;
        transform.colorTransform = color;
    }

}