/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vLTf
 */

package  
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.utils.getTimer;
	/**
	 * ...
	 * @author lizhi http://game-develop.net/
	 */
	public class Chain extends Sprite
	{
		private var ps:Vector.<P> = new Vector.<P>;
		private var a:Number = 0;
		public function Chain() 
		{
			for (var i:int = 0; i < 30;i++ ) {
				var p:P = new P;
				p.x = 0;
				p.y = 0;
				p.length = Math.cos(i/30*Math.PI/2)*30;
				p.angle = 0;
				if (i != 0) p.parent = ps[i - 1];
				ps.push(p);
			}
			addEventListener(Event.ENTER_FRAME, enterFrame);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, stage_mouseMove);
		}
		
		private function stage_mouseMove(e:MouseEvent):void 
		{
			a=Math.atan2(-mouseY+ps[0].y,-mouseX+ps[0].x)
		}
		
		private function enterFrame(e:Event):void 
		{
			graphics.clear();
			graphics.lineStyle(0);
			ps[0].x = mouseX;
			ps[0].y = mouseY;
			
			ps[0].angle = a+Math.sin(getTimer() / 300)/5;
			for each(var p:P in ps) {
				if (p.parent) {
					p.angle = Math.atan2(p.y - p.parent.y, p.x - p.parent.x);
					p.x += .5*(p.parent.x + p.parent.length * Math.cos(p.parent.angle)-p.x);
					p.y += .5*(p.parent.y + p.parent.length * Math.sin(p.parent.angle)-p.y);
					graphics.moveTo(p.x, p.y);
					graphics.lineTo(p.parent.x, p.parent.y);
				}
				graphics.drawCircle(p.x, p.y, 5);
			}
		}
		
	}

}
class P {
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
	public var r:Number;
	public var weight:Number;
	public var angle:Number;
	public var length:Number;
	public var parent:P;
}