/**
 * Copyright John_Blackburne ( http://wonderfl.net/user/John_Blackburne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vL0N
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;

    public class FlashTest extends Sprite {
        
        public const kRandNum:int      = 32;
        public const kRandMask:int     = 31;
        public const kNumTrials:int    = 5000000;
        
        public var aRand:Vector.<Number>;
        public var iRandIndex:int;
        
        public var tf:TextField;

        public function FlashTest() {
            var iTime:int;
            
            InitText();
            InitRandTable();
            
            iTime = getTimer();
            TestLibraryRand();
            tf.appendText("Library:" + String(getTimer() - iTime));

            iTime = getTimer();
            TestCustomRand1();
            tf.appendText("\nCustom 1:" + String(getTimer() - iTime));


            iTime = getTimer();
            TestCustomRand2();
            tf.appendText("\nCustom 2:" + String(getTimer() - iTime));

            iTime = getTimer();
            TestCustomRand3();
            tf.appendText("\nCustom 3:" + String(getTimer() - iTime));
            
            tf.appendText("\nDone");
            
        }
        
        public function InitText():void {
            tf = new TextField();
            addChild(tf);
        }

        public function InitRandTable():void {
            var iRand:int;
            
            aRand = new Vector.<Number>();    
            for (iRand = 0; iRand < kRandNum * 2; iRand++) {
                aRand.push(Math.random());
            }
        }

        public function TestLibraryRand():void {
            var iTrial:int, fRand:Number, fSum:Number;
            fSum = 0;
            for (iTrial = 0; iTrial < kNumTrials; iTrial++) {
                fRand = Math.random();
                fSum += fRand;
            }
            
        }

        public function TestCustomRand1():void {
            var iTrial:int, fRand:Number, fSum:Number;
            fSum = 0;
            iRandIndex = 0;
            for (iTrial = 0; iTrial < kNumTrials; iTrial++) {
                fRand = aRand[iRandIndex++];
                if (iRandIndex >= kRandNum) iRandIndex = 0;
                fSum += fRand;
            }
        }

        public function TestCustomRand2():void {
            var iTrial:int, fRand:Number, fSum:Number;
            fSum = 0;
            iRandIndex = 0;
            for (iTrial = 0; iTrial < kNumTrials; iTrial++) {
                fRand = aRand[iRandIndex++ & kRandMask];
                fSum += fRand;
            }
        }

        public function TestCustomRand3():void {
            var iTrial:int, fRand:Number, fSum:Number;
            fSum = 0;
            iRandIndex = 0;
            for (iTrial = 0; iTrial < (kNumTrials / 4); iTrial++) {
                fRand = aRand[iRandIndex++];
                fSum += fRand;
                fRand = aRand[iRandIndex++];
                fSum += fRand;
                fRand = aRand[iRandIndex++];
                fSum += fRand;
                fRand = aRand[iRandIndex++];
                fSum += fRand;
                if (iRandIndex >= kRandNum) iRandIndex -= kRandNum;
            }
        }


    }
}