/**
 * Copyright John_Blackburne ( http://wonderfl.net/user/John_Blackburne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vKc2J
 */

// forked from John_Blackburne's Accessor performance test
// forked from John_Blackburne's flash on 2011-12-16
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;

    public class FlashTest extends Sprite {
        
        public const kNumTrials:int    = 5000000;
        public var aData:Vector.<Vec2D>;
        public var tf:TextField;

       public var iTime:int, iIndex:int, v:Vec2D, iSum:int, iTrial:int;

        public function FlashTest() {
            InitText();
            InitData();
            
            // run the 1st test once before timing: otherwise the first test
            // is slow, possibly as the first time the data's accessed it takes
            // more time. Running a test without timing seems to fix it.
            Test1();
            
            iTime = getTimer();
            Test1();
            tf.appendText("\nTest 1: "
                + String(getTimer() - iTime));

            iTime = getTimer();
            Test1a();
            tf.appendText("\nTest 1a: "
                + String(getTimer() - iTime));

            iTime = getTimer();
            Test2();
            tf.appendText("\nTest 2: "
                + String(getTimer() - iTime));

            iTime = getTimer();
            Test2a();
            tf.appendText("\nTest 2a: "
                + String(getTimer() - iTime));

            tf.appendText("\nDone");
            
        }
        
        public function InitText():void {
            tf = new TextField();
            tf.width = 400;
            tf.text = "Initialised";
            addChild(tf);
        }

        public function InitData():void {

            aData = new Vector.<Vec2D>();
            for (iIndex = 0; iIndex < kNumTrials; iIndex++) {
                aData.push(new Vec2D(iIndex % 7, iIndex % 11));
            }
        }

        public function Test1():int {
            var iS:int, iT:int, u:Vec2D;
            iS = 0;

            for (iT = 0; iT < kNumTrials; iT++) {
                u = aData[iTrial];
                iS += u.iX;
            }
            return iS;
        }

        public function Test1a():int {
            iSum = 0;

            for (iTrial = 0; iTrial < kNumTrials; iTrial++) {
                v = aData[iTrial];
                iSum += v.iX;
            }

            return iSum;
        }

        public function Test2():int {
            var iS:int, iT:int;
            iS = 0;

            for (iT = 0; iT < kNumTrials; iT++) {
                iS += aData[iT].iX;
            }
            
            return iS;
        }

        public function Test2a():int {
            iSum = 0;

            for (iTrial = 0; iTrial < kNumTrials; iTrial++) {
                iSum += aData[iTrial].iX;
            }
            
            return iSum;
        }

    }
}


class Vec2D {
 public var iX:int;
 public var iY:int;
 
 public function Vec2D(x:int, y:int) {iX = x; iY = y;}
 public function X():int {return iX;}
 public function Y():int {return iY;}
}

