/**
 * Copyright FLASHMAFIA ( http://wonderfl.net/user/FLASHMAFIA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vKJC
 */

package {
    import flash.display.BlendMode;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.GlowFilter;
    import flash.geom.Matrix;

    [SWF(width='465', height='465')]
    public class Persistence2 extends Sprite
    {
        private const O_NUM : uint = 3;
        /* */
        private var ooo : Vector.<O>;
        private var ogfx : Graphics;
        private var bg : Shape;
        private var mtx : Matrix;
        private var tx : Number = 0.0;
        private var ty : Number = 0.0;
        private var mx : Number = 0.0;
        private var my : Number = 0.0;
        private var k : Number = 0.92;
        private var grow : Number = 4.0;
        private var shpeed : int = 7;
        private var fcnt : int = (8888 * Math.random()) >> 0;

        public function Persistence2()
        {
            stage.stageFocusRect = tabChildren = tabEnabled = mouseChildren = mouseEnabled = false;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.MEDIUM;
            stage.frameRate = 64;
            opaqueBackground = 0x0;

            addChild(bg = new Shape());
            bg.opaqueBackground = 0x0;

            mtx = new Matrix();
            mtx.createGradientBox(465, 465);

            var oshp : Shape = new Shape();
            oshp.filters = [new GlowFilter(0x00F0FF, 1.0, 24.0, 24.0, 5, BitmapFilterQuality.MEDIUM)];
            oshp.blendMode = BlendMode.ADD;
            addChild(oshp);

            ogfx = oshp.graphics;

            ooo = new Vector.<O>(O_NUM, true);

            var n : uint = O_NUM;
            while (n-- != 0) {
                ooo[n] = new O();
            }

            addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(e : Event) : void
        {
            fcnt++;

            shpeed = (1 << (1 + ((fcnt >> 6) & 7))) - 1;

            if ((fcnt & shpeed) == 1)
            {
                mx = 64 + (465 - 64) * Math.random();
                my = 64 + (465 - 64) * Math.random();
                grow = 0.5 + 1.5 * Math.random();
            }

            if ((fcnt & 127) == 127) {
                k = 0.02 + 0.98 * Math.random();
            }

            var vx : Number = mx - tx;
            var vy : Number = my - ty;
            var vd : Number = Math.sqrt(vx * vx + vy * vy);

            tx += vx * 0.125;
            ty += vy * 0.125;

            var a : Number = ((fcnt & 63) / 64) * (6.283185307179586);
            var rad : Number = 22 + (465 / 2) * (vd / (465 / grow)) + (11 * sin(a / 3));
            var swp : Number = (6.283185307179586) / O_NUM;

            /* draw bg */

            mtx.tx = tx;
            mtx.ty = ty;

            bg.graphics.clear();
            bg.graphics.beginGradientFill('radial', [0x40808F, 0x124044], [0.5, 0.5], [24, 255], mtx, 'pad', 'rgb');
            bg.graphics.drawRect(0, 0, 465, 465);
            bg.graphics.endFill();

            /* draw flares */

            ogfx.clear();
            ogfx.lineStyle(4, 0xF8FCFF, 1.0, false, 'none', 'none');

            for each (var o : O in ooo)
            {
                a += swp;

                var ox : Number = ((o.x0 - o.x1) + o.x0);
                var oy : Number = ((o.y0 - o.y1) + o.y0);

                o.x1 = o.x0;
                o.y1 = o.y0;

                o.x0 = (ox * k) + ((1 - k) * (tx + rad * cos(a)));
                o.y0 = (oy * k) + ((1 - k) * (ty + rad * sin(a)));

                ogfx.moveTo(o.x0, o.y0);
                ogfx.lineTo(o.x1, o.y1);
            }
        }

        private function sin(n : Number) : Number {
            n %= 6.283185307179586;
            if (n > 3.141592653589793) n -= 6.283185307179586;
            if (n < -3.141592653589793) n += 6.283185307179586;
            var s : Number = (n <= 0) ? (1.27323954 * n + 0.405284735 * n * n) : (1.27323954 * n - 0.405284735 * n * n);
            return (s < 0) ? (0.225 * (s * -s - s) + s) : (0.225 * (s * s - s) + s);
        }

        private function cos(n : Number) : Number {
            n += 1.5707963267948966;
            n %= 6.283185307179586;
            if (n > 3.141592653589793) n -= 6.283185307179586;
            if (n < -3.141592653589793) n += 6.283185307179586;
            var s : Number = (n <= 0) ? (1.27323954 * n + 0.405284735 * n * n) : (1.27323954 * n - 0.405284735 * n * n);
            return (s < 0) ? (0.225 * (s * -s - s) + s) : (0.225 * (s * s - s) + s);
        }
    }
}

internal class O {
    public var x0 : Number = 0.0;
    public var y0 : Number = 0.0;
    public var x1 : Number = 0.0;
    public var y1 : Number = 0.0;
}