/**
 * Copyright savinius ( http://wonderfl.net/user/savinius )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vHuG
 */

// forked from eff_01's forked from: エフェクトみたいなもの２
// forked from termat's エフェクトみたいなもの２
package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldType;

    [SWF(width="480", height="480", backgroundColor="0xffffff", frameRate="30")];
    public class Practice59 extends Sprite{
        private var canvas:Canvas;
        
        public function Practice59() {
            canvas = new Canvas(480, 480);
            addChild(canvas);
            addEventListener(Event.ENTER_FRAME, update);
            canvas.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
        }
    
        private function update(e:Event):void {
            canvas.update();
        }
        
        private function onDown(e:MouseEvent):void {
            canvas.next();
        }
    }

}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.MovieClip;
import flash.events.Event;
import flash.display.Loader;
import flash.net.URLRequest;
import flash.filters.BlurFilter;
import flash.filters.BitmapFilterQuality;
import flash.system.LoaderContext;
import flash.system.Security;

class Canvas extends MovieClip {
    private var bmp:BitmapData;
    private var tmp:BitmapData;
    private var images:Array;
    private var list:Vector.<Particle>;
    private var filter:BlurFilter;
    private var id:int = 0;

    private var url:Array = ["http://farm4.static.flickr.com/3273/2824587969_f4a1cff8f8_m.jpg",
                            "http://farm1.static.flickr.com/190/508971226_cdcfd71c4d_m.jpg",
                            "http://farm2.static.flickr.com/1185/1464649124_49691c6057_m.jpg",
                            "http://farm3.static.flickr.com/2168/2224323796_193b9c58dc_m.jpg",
                            "http://farm1.static.flickr.com/216/508866526_152e9cf6ec_m.jpg",
                            "http://farm3.static.flickr.com/2379/2221908369_4c85ca67c1_m.jpg"];
                            
    public function Canvas(w:int,h:int) {
        bmp = new BitmapData(w, h, false, 0xffffff);
        addChild(new Bitmap(bmp));
        Particle.bmp = bmp;
        images = [];
        list = new Vector.<Particle>();
        for (var i:int = 1; i < 5;i++) Security.loadPolicyFile("http://farm"+i.toString()+".static.flickr.com/crossdomain.xml");
        for (i = 0; i < url.length; i++) {
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadCompleted);
            loader.load(new URLRequest(url[i]), new LoaderContext(true));
        }
    }
    
    private function loadCompleted(e:Event):void {
        var loader:Loader = e.target.loader;
        var t:BitmapData = new BitmapData(loader.width, loader.height);
        t.draw(loader);
        images.push(t);
        if (images.length == 1) {
            tmp = images[0];
            createperticle();
            slide(300);
        }
    }
    
    private function createperticle():void {
        while (list.length > 0) list.pop();
        var mx:int = (bmp.width - tmp.width) / 2;
        var my:int = (bmp.height - tmp.height) / 2;
        for (var i:int = 0; i < tmp.width; i++) {
            for (var j:int = 0; j < tmp.height; j++) {
                var c:uint = tmp.getPixel(i, j);
                var p:Particle = new Particle(i+mx, j+my, c);
                list.push(p);
            }
        }
    }

    public function update():void {
        bmp.fillRect(bmp.rect, 0xffffff);
        for each(var p:Particle in list) {
            if (p.canDraw()) bmp.setPixel(p.x, p.y, p.color);
            p.update();
        }
    }
    
    public function next():void {
        id = (id + 1) % images.length;
        tmp = images[id];
        createperticle();
        slide(300);
    }
    
    private var mode:int = 0;
    private var op:Array = [[[1, 1], [1, 1]],
                            [[1, 0], [ -1, 0]],
                            [[0, 1], [0, -1]], 
                            [[1, 1], [1, -1], [ -1, 1], [ -1, -1]],
                            [[1, 0], [-1, 0], [ 0, 1], [ 0, -1]],
                            [[1, 0], [ -1, 0]], 
                            [[0, 1], [ 0, -1]], 
                            [[1, 1], [ 1, -1], [ -1, 1], [ -1, -1]]];
    
    private function slide(r:Number):void {
        mode = (mode + 1) % op.length;
        var s:Array = op[mode];
        var i:int = 0;
        if (mode < 5) {
            Particle.mode = 0;
            for each(var p:Particle in list) {
                var ii:int = i++ % s.length;
                p.x = p.bx + r * s[ii][0];
                p.y = p.by + r * s[ii][1];
            }
        }else {
            Particle.mode = 1;
            for each(p in list) {
                ii = i++ % s.length;
                p.x = p.bx + r * s[ii][0] * i;
                p.y = p.by + r * s[ii][1] * i;
            }
        }
    }
}

class Particle {
    public var x:int;
    public var y:int;
    public var color:uint;
    public var bx:Number;
    public var by:Number;
    public var vx:Number;
    public var vy:Number;
    public static var bmp:BitmapData;
    private var sp:Number = 0.5;
    private var fr:Number = 0.7;
    public static var mode:int = 0;
    
    public function Particle(_x:int, _y:int, _c:uint) {
        x = _x, y = _y, color = _c;
        bx = x, by = y;
        vx = 0, vy = 0;
    }
    
    public function canDraw():Boolean {
        if (x < 0) return false;
        if (x > bmp.width) return false;
        if (y < 0) return false;
        if (y > bmp.height) return false;
        return true;
    }
    public function update():void {
        if (x == bx && y == by) return;
        if (mode == 0) {
            x += vx, y += vy;
            var ax:Number = (bx - x) * sp;
            var ay:Number = (by - y) * sp;
            vx += ax, vy += ay;
            vx *= fr, vy *= fr;
        }else {
            x += vx, y += vy;
            vx = Math.round((bx - x) * sp);
            vy = Math.round((by - y) * sp);
            if (vx == 0 && vy == 0) {
                x = bx, y = by;
            }
        }
    }
}