/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vHjY
 */

package
{
    import nape.geom.*;
    import nape.phys.*;
    import nape.shape.*;
    import nape.space.*;
    import flash.events.*;
    import flash.display.*;
    import net.hires.debug.*;
    
    [SWF(frameRate = 60, width = 465, height = 465)]
    public class Main extends Sprite
    {
        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        public function addedToStage($e:Event) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
            addChild(new Stats());
        
            Buffer.buildContext(this);
            
            _init();
        }
        
        public function _init() :void
        {
            graphics.clear();
            graphics.lineStyle(1, 0, 0.75);
            graphics.drawRect(0, 0, 464, 464);
        }
    }
}

import nape.util.*;
import nape.phys.*;
import nape.geom.*;
import nape.shape.*;
import nape.space.*;
import flash.geom.*;
import flash.events.*;
import flash.display.*;

class Buffer
{
    public static var instanceContext :Object;
    public static var instanceDebug :Debug;
    public static var instanceSpace :Space;
    public static var instanceList :Array;
    public static var spaceGravity :Vec2;
    
    public static function buildContext($context:Object) :void
    {
        instanceList = [];
        instanceContext = $context;
        
        spaceGravity = Vec2.weak(0, 0);
        instanceSpace = new Space(spaceGravity);
        //instanceDebug = new BitmapDebug(465, 465, 0xFFFFFF, true);
        
        var $c:Body = new Body(BodyType.STATIC);
            $c.shapes.add(new Polygon(Polygon.rect(0, 0, 465, -1)));
            $c.shapes.add(new Polygon(Polygon.rect(0, 465, 465, -1)));
            $c.shapes.add(new Polygon(Polygon.rect(0, 0, -1, 465)));
            $c.shapes.add(new Polygon(Polygon.rect(465, 0, -1, 465)));
            $c.space = instanceSpace;
        
        for (var $i:int = 0; $i < 400; $i++)
        {
            var $b:instanceBody = new instanceBody(Math.random() * 465, Math.random() * 465, 8);
            
            instanceList.push($b);
            $context.addChild($b);
        }
        
        //$context.addChild(instanceDebug.display);
        
        $context.addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    public static function onEnterFrame($e:Event) :void
    {
        instanceSpace.step(1 / 60);
        
        for (var i:int = 0; i < instanceSpace.liveBodies.length; i++)
        {
            var $body :Body = instanceSpace.liveBodies.at(i);
                $body.userData.graphicUpdate($body);
        }
        
        //instanceDebug.clear();
        //instanceDebug.draw(instanceSpace);
        //instanceDebug.flush(); 
    }
}

class instanceBody extends Sprite
{
    private var _body :Body;
    
    protected var _x :Number;
    protected var _y :Number;
    protected var _s :Number;
    
    public function instanceBody($x:Number, $y:Number, $s:Number)
    {
        _x = $x;
        _y = $y;
        _s = $s;
        
        _init();
        
        Buffer.instanceContext.parent.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
    }

    public function _init() :void
    {
        graphics.beginFill(0);
        graphics.drawCircle(0, 0, 8);
        graphics.endFill();
        
        _body = new Body();
        _body.position.setxy(_x, _y);
        _body.shapes.add(new Circle(_s));
        _body.space = Buffer.instanceSpace;
        _body.userData.graphic = this;
        _body.userData.graphicUpdate = function (body:Body):void
        {
            _body.userData.graphic.rotation = ((body.rotation * 180)/Math.PI);
            _body.userData.graphic.x = body.position.x;
            _body.userData.graphic.y = body.position.y;
        }
    }
    
    private var firstPoint :Point = new Point();
    private var currentPoint :Point = new Point();
    private var calcPoint :Point = new Point();
    
    public function onMouseDown($e:MouseEvent) :void
    {
        firstPoint = new Point($e.stageX, $e.stageY);

        Buffer.instanceContext.parent.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        Buffer.instanceContext.parent.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
    }
    
    public function onMouseMove($e:MouseEvent) :void
    {
        currentPoint = new Point($e.stageX, $e.stageY);
        calcPoint = Point(currentPoint.subtract(firstPoint));
        
        if (((_body.position.x - $e.stageX) < 10) && ((_body.position.y - $e.stageY) < 10))
        {
            //_body.velocity = new Vec2(calcPoint.x*100, calcPoint.y*100);
            _body.velocity = new Vec2(calcPoint.y*100, calcPoint.x*100);
        }
        
        if (((_body.position.x - $e.stageX) < 10) && ((_body.position.y - $e.stageY) < 10))
        {
            _body.force = new Vec2(calcPoint.x*100, calcPoint.y*100);
        }

        
        firstPoint = currentPoint;
    }

    public function onMouseUp($e:MouseEvent) :void
    {
        Buffer.instanceContext.parent.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        Buffer.instanceContext.parent.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        
        _body.velocity = new Vec2(0, 0);
    }
}

