/**
 * Copyright Verotic3 ( http://wonderfl.net/user/Verotic3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vGkP
 */

// forked from flashrod's Tetris
package { 
    import flash.display.Sprite; 
    import flash.text.TextField; 
    import flash.events.Event; 
    import flash.events.KeyboardEvent; 

    public class Tetris extends Sprite { 
        private const W:int = 10; 
        private const H:int = 20; 
        private const UNIT:int = 23; 
        private const COLOR:Array =[0x000000, 0x001070, 0x100070, 0x002070, 0x200070, 0x300070, 0x003070, 0x400070]; 
        private const PAT:Array =[[[1, 1, 1, 1]], 
                                  [[0, 2, 0], [2, 2, 2]], 
                                  [[3, 3, 0], [0, 3, 3]], 
                                  [[0, 4, 4], [4, 4, 0]], 
                                  [[5, 5], [5, 0], [5, 0]], 
                                  [[6, 6], [0, 6], [0, 6]], 
                                  [[7, 7], [7, 7]]]; 
        private const SPEED:Array = [30, 20, 10, 5]; 

        private const VK_H:int = 37;   
        private const VK_J:int = 38; 
        private const VK_K:int = 32; 
        private const VK_L:int = 39; 
        private const VK_SPC:int = 40; 

        private var field:Array = []; 
        private var piece:Array; 
        private var next:Array; 
        private var text:TextField = new TextField(); 
        private var keytable:Array = []; 
        private var count:int = 0; 
        private var step:int = 0; 
        private var px:int; 
        private var py:int; 

        public function Tetris() { 
            text.x = W*UNIT; 
            text.text="Next:"; 
            addChild(text); 
            var t:TextField = new TextField(); 
            t.x = W * UNIT; 
            t.y = 8 * UNIT; 
            t.text = "usage: Arrow keys"; 
            addChild(t); 
            field = new Array(H).map(function():*{ 
                return new Array(W).map(function():*{ 
                    return 0; 
                }) 
            }); 
            keytable[VK_H] = function():void {px -= space(px-1, py, piece)}; 
            keytable[VK_J] = function():void {rotate(true)}; 
            keytable[VK_K] = function():void {rotate(false)}; 
            keytable[VK_L] = function():void {px += space(px+1, py, piece)}; 
            keytable[VK_SPC] = function():void {drop(); pick();}; 
            stage.addEventListener(KeyboardEvent.KEY_DOWN, function(e:KeyboardEvent):void { 
                if (keytable[e.keyCode]) { 
                    keytable[e.keyCode](); 
                    repaint(); 
                } 
            }); 
            pick(); 
            pick(); 
            addEventListener(Event.ENTER_FRAME, function(e:Event):void { 
                if (--step < 0) { 
                    step=SPEED[int(count/10)]; 
                    if (space(px, py+1, piece)) { 
                        ++py; 
                        repaint(); 
                    } else { 
                        drop(); 
                        pick(); 
                    } 
                } 
            }); 
        } 

        private function rotate(clock:Boolean):void { 
            var r:Array = new Array(piece[0].length).map(function():*{return [];}); 
            for (var j:int = 0; j<piece.length; ++j) 
                for (var i:int = 0; i < r.length; ++i) 
                    if (clock) 
                        r[i][piece.length-1-j] = piece[j][i]; 
                    else 
                        r[r.length-1-i][j] = piece[j][i]; 
            if (space(px, py, r)) 
                piece = r; 
        } 

        private function repaint():void { 
            graphics.clear(); 
            for (var j:int = 0; j < H; ++j) 
                for (var i:int = 0; i < W; ++i) { 
                    var g:int = 0; 
                    if (py <= j && j < (py+piece.length) && px <= i && i < (px+piece[0].length)) 
                        g = piece[j-py][i-px]; 
                    if (g == 0) 
                        g = field[j][i]; 
                    graphics.beginFill(COLOR[g]); 
                    graphics.drawRect(i*UNIT, j*UNIT, UNIT, UNIT); 
                } 
            for (j = 0; j < next.length; ++j) 
                for (i = 0; i < next[j].length; ++i) { 
                    graphics.beginFill(COLOR[next[j][i]]); 
                    graphics.drawRect((i+W+1)*UNIT, (j+2)*UNIT, UNIT, UNIT); 
                } 
        } 

        private function space(x:int, y:int, p:Array):int { 
            for (var j:int = 0; j < p.length; ++j) { 
                if (0 > (y+j) || (y+j) >= H) 
                    return 0; 
                for (var i:int = 0; i < p[j].length; ++i) { 
                    if (0 > (x+i) || (x+i) >= W) 
                        return 0; 
                    if (p[j][i] && field[y+j][x+i]) 
                        return 0; 
                } 
            } 
            return 1; 
        } 

        private function drop():void { 
            for (; space(px, py+1, piece); py++) 
                ; 
            for (var j:int = 0; j < piece.length; ++j) 
                for (var i:int = 0; i < piece[j].length; ++i) 
                    if (piece[j][i]) 
                        field[py+j][px+i] = piece[j][i]; 
            for (j=0; j<H; ++j) 
                if (field[j].indexOf(0) < 0) { 
                    field.splice(j, 1); 
                    field.unshift([]); 
                    for (i=0; i<W; ++i) 
                        field[0][i] = 0; 
                } 

            count++; 
            if (count/10 >= SPEED.length) 
                count = 0; 
        } 

        private function pick():void { 
            piece = next; 
            if (piece != null) { 
                px = (W-piece[0].length)/2; 
                py = 0; 
                if (!space(px, py, piece)) 
                    text.text="GAME OVER"; 
            } 
            next = PAT[int(Math.random()*PAT.length)]; 
        } 
    } 
} 