/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vGdX
 */

/*

参考
http://help.adobe.com/ja_JP/AS3LCR/Flash_10.0/flash/text/engine/TextBlock.html
http://help.adobe.com/ja_JP/AS3LCR/Flash_10.0/flash/text/engine/EastAsianJustifier.html
http://level0.kayac.com/2008/12/textbox.php
*/

package {
	import flash.display.Sprite;
	import flash.text.engine.FontDescription;
	import flash.text.engine.TextBlock;
	import flash.text.engine.TextElement;
	import flash.text.engine.TextLine;
	import flash.text.engine.TextRotation;
	import flash.text.engine.ElementFormat;
	import flash.text.engine.EastAsianJustifier;
	import flash.text.TextField;
	import flash.events.MouseEvent;
	
	[SWF(width = "465", height = "465", backgroundColor = 0xEEEEEE, frameRate = "30")]
	public class Main extends Sprite {
		
		private var inputTF:TextField = new TextField();
		private var commentBase:Sprite = new Sprite();
		public function Main():void {
			addChild(commentBase);
			inputTF.x = 12;
			inputTF.y = this.stage.stageHeight-24-110;
			inputTF.width = this.stage.stageWidth - 24;
			inputTF.height = 108;
			inputTF.text = "方丈記　　鴨長明\n行く川のながれは絶えずして、しかも本の水にあらず。よどみに浮ぶうたかたは、かつ消えかつ結びて久しくとゞまることなし。\n＊＊＊＊＊\nFlashPlayer10から追加されたTextBlockクラスでは縦書きの日本語表示がより奇麗になりました。このデモはリファレンス（http://help.adobe.com/ja_JP/AS3LCR/Flash_10.0/flash/text/engine/TextBlock.html）のコード例を改変したものです。\n以前からあるTextFieldクラスと違って、段落毎に分けて指定すると良いみたいだけど、イマイチ納得できない。\nまだよく理解できていません（笑）。";
			inputTF.border = true;
			inputTF.type = "input";
			inputTF.wordWrap = true;
			addChild(inputTF);
			var btnText:TextField = new TextField();
			btnText.x = this.stage.stageWidth-90;
			btnText.y = this.stage.stageHeight - 18;
			btnText.width = 170;
			btnText.height = 21;
			btnText.text = "to TextBlock";
			btnText.selectable = false;
			addChild(btnText);
			
			var button:Sprite = new Sprite();
			button.graphics.lineStyle (2, 0x999999, 1.0);
			button.graphics.beginFill (0xCCCCCC, 0);
			button.graphics.drawRoundRect (this.stage.stageWidth-110, this.stage.stageHeight - 22 , 100 , 20 , 10 , 10);
			button.buttonMode = true;
			button.addEventListener(MouseEvent.CLICK,CLICK);
			addChild(button);
			
			
			CLICK();
		}
		private function CLICK(e:MouseEvent = null):void {
			while (commentBase.numChildren) {
				commentBase.removeChildAt(0);
			}
			var fontDescription:FontDescription = new FontDescription("MS Mincho");
			var format:ElementFormat = new ElementFormat();
			format.fontSize = 15;
			format.fontDescription = fontDescription;
			
			var txt_array:Array = inputTF.text.split("\r");
			var linePosition:Number = stage.stageWidth - 30;
			
			for (var i:int = 0; i < txt_array.length; i++) {
				setTB(txt_array[i]);
			}
			function setTB(txt:String):void{
				var textElement:TextElement = new TextElement(txt, format); 
				var textBlock:TextBlock = new TextBlock();
				textBlock.content = textElement;
				textBlock.lineRotation = TextRotation.ROTATE_90;
				textBlock.textJustifier = new EastAsianJustifier();
	
				var previousLine:TextLine = null;
			
				while (true) {
					var textLine:TextLine = textBlock.createTextLine(
						previousLine, 
						300);
					if (textLine == null) 
						break;
					textLine.y = 16;
					textLine.x = linePosition;
					linePosition -= 24;
					commentBase.addChild(textLine);				
					previousLine = textLine;
				}
			}
		}
	}
}