/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vGWc
 */

/*
Matrix3D.position;
と同じ機能の関数を作ってみる。
MAC 10,0,2,54,MAC 10,0,12,36で動作確認。

実体行列.position

処理としては
実体行列を分解して再構成する。


各要素をrandomで値を入れて、positionし、
比較して確認とした。


Matrix3D.position
http://help.adobe.com/ja_JP/AS3LCR/Flash_10.0/flash/geom/Matrix3D.html#position
*/
package {
	import flash.display.Sprite;
	import flash.geom.Matrix3D;
	import flash.geom.Orientation3D;
	import flash.text.TextField;
	import flash.geom.Vector3D;
	import flash.system.Capabilities;
	public class FlashTest extends Sprite {
		public function FlashTest() {
			var txt:String="◆同機能関数Mtrx3D.position　"+Capabilities.version+"での実行結果\n\n";
			
			//確認用の値を用意
			var entity:Matrix3D=new Matrix3D(Util.random16());
			var entity1:Matrix3D=entity.clone();
			var entity2:Matrix3D=entity.clone();
			var vec:Vector3D=new Vector3D(Math.random()*200-100,Math.random()*200-100,Math.random()*200-100,Math.random()*200-100);
			
			
			//実行
			var return1:Vector3D = entity1.position;
			entity1.position = vec;
			var return2:Vector3D = Mtrx3D.get_position(entity2);
			Mtrx3D.set_position(entity2,vec)
			
			
			//確認
			var entity1RawData:Vector.<Number>=entity1.rawData;
			txt+="↓Matrix3D.positionの結果\n"+return1+"\n"+entity1RawData+"\n";
			var entity2RawData:Vector.<Number>=entity2.rawData;
			txt+="\n↓同機能関数Mtrx3D.positionの結果\n"+return2+"\n"+entity2RawData+"\n\n";
			txt+=Util.hikaku(entity1RawData,entity2RawData);
				
			
			//テキストフィールドを作りtxtを流し込み。
			var tf:TextField = new TextField();
			tf.width=stage.stageWidth;
			tf.height=stage.stageHeight;
			tf.wordWrap=true;
			stage.addChild(tf);
			tf.text=txt;
		}
	}
}
import flash.display.Sprite;
class Mtrx3D extends Sprite {
	import flash.geom.Matrix3D;
	import flash.geom.Vector3D;
	import flash.system.Capabilities;
	public static function get_position(entity:Matrix3D):Vector3D{
		var e:Vector.<Number> = Vector.<Number>(entity.rawData);
		return new Vector3D(e[12],e[13],e[14]);
	}
	public static function set_position(entity:Matrix3D,v:Vector3D):void{
		var e:Vector.<Number> = Vector.<Number>(entity.rawData);
		e[12] = v.x;
		e[13] = v.y;
		e[14] = v.z;
		entity.rawData = e;
	}
}
class Util {
	import flash.geom.Matrix3D;
	import flash.geom.Vector3D;
	public static function hikaku(v0:Vector.<Number>,v1:Vector.<Number>):String {
		var _str:String="↓二つのMatrix3Dの要素毎の差\n";
		var _n:int=v0.length;
		for (var i:int=0; i<_n; i++) {
			_str += "["+i+"]:"+(v0[i]-v1[i])+"\n";
		}
		return _str;
	}
	public static function hikaku2(v0:Vector3D,v1:Vector3D):String {
		var _str:String="↓二つのVector3Dの要素毎の差\n";
		_str += ".x:"+(v0.x-v1.x)+"\n";
		_str += ".y:"+(v0.y-v1.y)+"\n";
		_str += ".z:"+(v0.z-v1.z)+"\n";
		_str += ".w:"+(v0.w-v1.w)+"\n";
		return _str;
	}

	public static function random16():Vector.<Number> {
		var _v:Vector.<Number>=new Vector.<Number>(16,true);
		for (var i:int=0; i<16; i++) {
			_v[i]=Math.random()*200-100;
		}
		return _v;
	}
	public static function random9():Vector.<Number> {
		var _mt:Matrix3D = new Matrix3D();
		var v:Vector.<Vector3D>=new Vector.<Vector3D>  ;
		v[0]=new Vector3D(200*Math.random()-100,200*Math.random()-100,200*Math.random()-100);//平行移動、
		v[1]=new Vector3D(10*Math.random()-5,10*Math.random()-5,10*Math.random()-5);//回転
		v[2]=new Vector3D(100*Math.random(),100*Math.random(),100*Math.random());//拡大 / 縮小
		_mt.recompose(v);
		return _mt.rawData;
	}
}