/**
 * Copyright simon4761 ( http://wonderfl.net/user/simon4761 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vGP1
 */

// forked from rsakane's トランジション
/*
 * パターンは吉里吉里のマスクを使用しています。
 * 読み込むまでに時間がかかる場合があるかもしれません。
 */
package
{
    import flash.display.*;
    import flash.events.Event;
    import flash.geom.*
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
 
    public class Main extends Sprite
    {
        private var loader:ImageLoader;
        private var images:Array = new Array();
        private var bd:BitmapData;
        private var maskCount:int = 0;
        private var count:int = 0;
        private var image:BitmapData;
        private var temp:BitmapData;
        
        public function Main()
        {
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.INIT, initHandler);
            loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/d/d2/d28d/d28d4dcf04a4406a6d98d9eb0c97e55ae1761358"), new LoaderContext(true));
        }
        
        private function initHandler(event:Event):void
        {
            var l:Loader = event.currentTarget.loader;
            image = new BitmapData(l.width, l.height, false);
            image.draw(l);
            
            loader = new ImageLoader();
            loader.addEventListener(Event.COMPLETE, onComplete);
            loader.load(URL.DATA);
        }
 
        private function onComplete(event:Event):void
        {
            for (var i:int = 0; i < loader.images.length; i++)
            {
                var matrix:Matrix = new Matrix();
                matrix.scale(image.width / loader.images[i].width, image.height / loader.images[i].height);
                var m:BitmapData = new BitmapData(image.width, image.height, false);
                m.draw(loader.images[i], matrix);
                images.push(m);
            }
            
            bd = new BitmapData(image.width, image.height, false);
            addChild(new Bitmap(bd));
            
            temp = new BitmapData(image.width, image.height, true);
            
            init();
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function init():void
        {
            count = -1;
            maskCount = (maskCount + 1) % URL.DATA.length;
            bd.fillRect(bd.rect, 0xFFFFFF);
        }
        
        private function onEnterFrame(event:Event):void
        {
            count += 2;
            if (count > 0xFF)
            {
                if (count < 0xFF + 60) return;
                init();
                return;
            }
            
            var maskbd:BitmapData = images[maskCount];
            temp.fillRect(temp.rect, 0x0);
            temp.threshold(maskbd, maskbd.rect, new Point(), "<=", count, 0xFF000000, 0xFF);
            bd.copyPixels(image, image.rect, new Point(), temp, new Point());
        }
    }
}

import flash.display.*;
import flash.events.Event;
import flash.net.URLRequest;
import flash.system.LoaderContext;

class ImageLoader extends Sprite
{
    public var images:Array = new Array();
    
    public function load(url:Array):void
    {
        var count:int = 0;
        for (var i:int = 0; i < url.length; i++)
        {
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.INIT,
            function(event:Event):void
            {
                images.push(event.currentTarget.loader);
                if (++count == url.length) dispatchEvent(new Event(Event.COMPLETE));
            } );
            loader.load(new URLRequest(url[i]), new LoaderContext(true));
        }
    }
}

class URL
{
    public static const DATA:Array = 
    [
        "http://assets.wonderfl.net/images/related_images/1/10/10fb/10fbc051ef8e7fa3275d74ca3cc6e94d47e131cf",
        "http://assets.wonderfl.net/images/related_images/b/b7/b74b/b74b4f6bb337b2a8431cb83b159fe4be8f6a49b2",
        "http://assets.wonderfl.net/images/related_images/f/f6/f633/f6337382cf2a9b8882e85963a4a9abe6d0caa871",
        "http://assets.wonderfl.net/images/related_images/3/3c/3cb6/3cb6fe1915f7e77470c71e28d6dc6b465dd826ce",
        "http://assets.wonderfl.net/images/related_images/6/67/6730/6730657ece607aa80877ba1af913af4a17004945",
        "http://assets.wonderfl.net/images/related_images/b/b9/b9f5/b9f55242584c7442902ac7651142ba1d0ef2faaa",
        "http://assets.wonderfl.net/images/related_images/8/81/8191/8191fed9edd766eb4230765904912eefcd84fdf2",
        "http://assets.wonderfl.net/images/related_images/e/e0/e08e/e08ed333ff542b2724c8f3a1044679c00574c330",
        "http://assets.wonderfl.net/images/related_images/f/f8/f89b/f89bb078bcb2b13dd54aee3c1f052147697c8ebb",
        "http://assets.wonderfl.net/images/related_images/c/ca/ca96/ca96bde67543279be622fa8520f01a922a27a118",
        "http://assets.wonderfl.net/images/related_images/d/d0/d009/d0096c053850769b71b6f180e88eab28ee08e9f5",
        "http://assets.wonderfl.net/images/related_images/a/a8/a88b/a88b7f8678f190d50595764ecc829e0f272baf85",
        "http://assets.wonderfl.net/images/related_images/e/ed/ed58/ed583c913cde20982306bc6879f449bd63697a50",
        "http://assets.wonderfl.net/images/related_images/6/62/621b/621bbf4a38394a11506fd5facefa1108eb1ad601",
        "http://assets.wonderfl.net/images/related_images/4/4a/4a13/4a13787cc8b9064930a8827026ffde8ca26cdf5f",
        "http://assets.wonderfl.net/images/related_images/e/e3/e3ff/e3ff93ac932364b8e3187ca09de2ec32832dd577",
        "http://assets.wonderfl.net/images/related_images/5/54/5441/54419036b63566d0f4c8e60027d010affb727bbd",
        "http://assets.wonderfl.net/images/related_images/1/15/1524/1524552c787e8ba3a36b64549b555ad1f12f4236",
        "http://assets.wonderfl.net/images/related_images/a/a3/a353/a353240d2966ab38e0284ee1dfb31b14309671c5"
    ];
}