/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vFma
 */

package {
	import flash.display.BitmapData;
	import flash.geom.Utils3D;
	import flash.events.Event;
	import flash.geom.PerspectiveProjection;
	import flash.display.TriangleCulling;
	import flash.geom.Matrix3D;
	import flash.geom.Vector3D;
	import flash.display.Shape;
    import flash.display.Sprite;
    [SWF(backgroundColor=0x000000, frameRate=60)]
    public class FlashTest extends Sprite {
    		private var viewport:Shape;
    		private var worldMatrix:Matrix3D;
    		private var viewMatrix:Matrix3D;
    		private var projection:PerspectiveProjection;
    		
    		private var vertices:Vector.<Number>;
    		private var indeces:Vector.<int>;
    		private var uvData:Vector.<Number>;
    		
    		private var texture:BitmapData;
    		
    		
        public function FlashTest() {
            // write as3 code here..
            viewport = new Shape();
            viewport.x = stage.stageWidth>>1;
            viewport.y = stage.stageHeight>>1;
            addChild(viewport);
            
            createMesh();
            
            worldMatrix = new Matrix3D();
            viewMatrix = new Matrix3D();
            viewMatrix.appendTranslation(0,0,200)
            projection = new PerspectiveProjection();
            projection.fieldOfView = 60;
            
            texture = new BitmapData(512, 512, false);
            texture.perlinNoise(100, 100, 5, 0, true, true, 7);
            
            //render();
            addEventListener( Event.ENTER_FRAME, enterframeHandler );
       	}
       	private function enterframeHandler(e:Event):void{
       		update();
       		render();
       	}
      	private function createMesh():void{
       		vertices = new Vector.<Number>();
       		uvData = new Vector.<Number>();
       		indeces = new Vector.<int>();
       		
       		vertices.push( -50, -50, -50 );
       		vertices.push( +50, -50, -50 );
       		vertices.push( -50, +50, -50 );
       		vertices.push( +50, +50, -50 );
       		vertices.push( -50, -50, +50 );
       		vertices.push( +50, -50, +50 );
       		vertices.push( -50, +50, +50 );
       		vertices.push( +50, +50, +50 );
       		
       		uvData.push( 1/3, 0, 0 );
       		uvData.push( 2/3, 0, 0 );
       		uvData.push( 1/3, 1, 0 );
       		uvData.push( 2/3, 1, 0 );
       		uvData.push( 0/3, 0, 0 );
       		uvData.push( 3/3, 0, 0 );
       		uvData.push( 0/3, 1, 0 );
       		uvData.push( 3/3, 1, 0 );
       		
       		indeces.push(0, 2, 1, 1, 2, 3);
       		indeces.push(4, 0, 5, 5, 0, 1);
       		indeces.push(5, 1, 7, 7, 1, 3);
       		indeces.push(7, 3, 6, 6, 3, 2);
       		indeces.push(6, 2, 4, 4, 2, 0);
       		indeces.push(5, 7, 4, 4, 7, 6);
      	}
      	private function update():void{
      		worldMatrix.appendRotation( 1, Vector3D.Y_AXIS);
      	}
      	
      	private function render():void{
      		var m:Matrix3D = new Matrix3D();
      		m.append(worldMatrix);
      		m.append(viewMatrix);
      		m.append(projection.toMatrix3D());
      		
      		var projected:Vector.<Number> = new Vector.<Number>();
      		Utils3D.projectVectors( m, vertices, projected, uvData );
      		
      		viewport.graphics.clear();
       		viewport.graphics.lineStyle( -1, 0xFFFFFF );
        		viewport.graphics.beginBitmapFill( texture, null, false, true );
        		viewport.graphics.drawTriangles( projected, indeces, uvData, TriangleCulling.POSITIVE );
        		viewport.graphics.endFill();
        		
        	}
    }
}