/**
 * Copyright NewKrok ( http://wonderfl.net/user/NewKrok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vFQv
 */

package  {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;

    public class Table extends Sprite {
        
        private const _tableURL:        String = "http://assets.wonderfl.net/images/related_images/c/c7/c758/c7582c7c3ba7deb83ed6f583475290df2740a01c";
        private var _tableBMD:            BitmapData;        
        
        private var _leftChains:            Vector.<Chain> = new Vector.<Chain>;
        private var _rightChains:            Vector.<Chain> = new Vector.<Chain>;        
        
        private var _table:                    Sprite;
        
        private const _radianConversion:    Number = ( 180 / Math.PI );
        private const _chainLeftStrength:    Number = Math.random () * .5 + .5;
        private const _chainRightStrength:    Number = Math.random () * .5 + .5;
        
        private var _chainCount:            uint = 10;
        private var _chainLength:            uint = 10;
        
        public function Table () {
            loadImage ( _tableURL, build );
        }
        
        private function build ( event:Event ) :void {
            _tableBMD = new BitmapData ( event.currentTarget.content.width, event.currentTarget.content.height, true, 0x60 );
            _tableBMD.draw ( event.currentTarget.content );
            addChild ( _table = new Sprite );
            _table.addChild ( new Bitmap ( _tableBMD ) );
            /*_table.graphics.beginFill ( 0, .5 );
            _table.graphics.drawRect ( 0, 0, 300, 100 );
            _table.graphics.endFill ();*/
            for ( var i:uint; i < _chainCount; i++ ) {
                _leftChains.push ( addChild ( new Chain ( i > 0 ? _leftChains[i - 1] : null ) ) as Chain );
                _rightChains.push ( addChild ( new Chain ( i > 0 ? _rightChains[i - 1] : null ) ) as Chain );
                _leftChains[i].x = 50;
                _leftChains[i].y = 50;
                _rightChains[i].x = 350;
                _rightChains[i].y = 50;
                if ( i > 0 ) {
                    _leftChains[i].x += 50
                    _rightChains[i].x += 50
                }
            }
            addEventListener ( Event.ENTER_FRAME, core );
        }
        
        private function loadImage ( $url:String, $onComplete:Function ) :void {
            var imageLoader:Loader = new Loader ();
            imageLoader.contentLoaderInfo.addEventListener ( Event.COMPLETE, $onComplete );
            var image:URLRequest = new URLRequest ( $url );
            imageLoader.load ( image, new LoaderContext ( true ) );
        }
        
        private function core ( event:Event ) :void {
            graphics.clear ();
            graphics.lineStyle ( 2, 0x666666, 1 );
            for ( var i:uint = 0; i < _chainCount - 1; i++ ) {
                var circleXTMP:Number = _leftChains[i].x + _leftChains[i].vec2d.x;
                var circleYTMP:Number = _leftChains[i].y + _leftChains[i].vec2d.y;
                var circleXTMPNew:Number = _leftChains[i + 1].x + _leftChains[i + 1].vec2d.x;
                var circleYTMPNew:Number = _leftChains[i + 1].y + _leftChains[i + 1].vec2d.y;
                var xDistance:Number = circleXTMPNew - circleXTMP;
                var yDistance:Number = circleYTMPNew - circleYTMP;
                var zDistance:Number = Math.sqrt ( Math.pow ( xDistance, 2 ) + Math.pow ( yDistance, 2 ) );
                var angle:Number = Math.asin ( yDistance / zDistance ) * _radianConversion;
                angle = ( xDistance < 0 ) ? ( 180-angle ) : angle;
                if ( angle < 0 )
                    angle += 360;
                var rate:Number = ( zDistance - _chainLength ) / zDistance;
                rate *= -_chainLeftStrength;
                xDistance *= rate * 0.5;
                yDistance *= rate * 0.5;
                _leftChains[i].vec2d.x -= ( !isNaN ( xDistance ) ) ? xDistance : 0;
                _leftChains[i].vec2d.y -= ( !isNaN ( yDistance ) ) ? yDistance : 0;
                _leftChains[i + 1].vec2d.x += ( !isNaN ( xDistance ) ) ? xDistance : 0;
                _leftChains[i + 1].vec2d.y += ( !isNaN ( yDistance ) ) ? yDistance : 0;
                circleXTMP = _rightChains[i].x + _rightChains[i].vec2d.x;
                circleYTMP = _rightChains[i].y + _rightChains[i].vec2d.y;
                circleXTMPNew = _rightChains[i + 1].x + _rightChains[i + 1].vec2d.x;
                circleYTMPNew = _rightChains[i + 1].y + _rightChains[i + 1].vec2d.y;
                xDistance = circleXTMPNew - circleXTMP;
                yDistance = circleYTMPNew - circleYTMP;
                zDistance = Math.sqrt ( Math.pow ( xDistance, 2 ) + Math.pow ( yDistance, 2 ) );
                angle = Math.asin ( yDistance / zDistance ) * _radianConversion;
                angle = ( xDistance < 0 ) ? ( 180-angle ) : angle;
                if ( angle < 0 )
                    angle += 360;
                rate = ( zDistance - _chainLength ) / zDistance;
                rate *= -_chainRightStrength;
                xDistance *= rate * 0.5;
                yDistance *= rate * 0.5;
                _rightChains[i].vec2d.x -= ( !isNaN ( xDistance ) ) ? xDistance : 0;
                _rightChains[i].vec2d.y -= ( !isNaN ( yDistance ) ) ? yDistance : 0;
                _rightChains[i + 1].vec2d.x += ( !isNaN ( xDistance ) ) ? xDistance : 0;
                _rightChains[i + 1].vec2d.y += ( !isNaN ( yDistance ) ) ? yDistance : 0;
                if ( i > 0 ) {
                    graphics.moveTo ( _leftChains[i].x + _leftChains[i].vec2d.x, _leftChains[i].y + _leftChains[i].vec2d.y );
                    graphics.lineTo ( _leftChains[i]._nextChain.x + _leftChains[i]._nextChain.vec2d.x, _leftChains[i]._nextChain.y + _leftChains[i]._nextChain.vec2d.y );
                    graphics.moveTo ( _rightChains[i].x + _rightChains[i].vec2d.x, _rightChains[i].y + _rightChains[i].vec2d.x );
                    graphics.lineTo ( _rightChains[i]._nextChain.x + _rightChains[i]._nextChain.vec2d.x, _rightChains[i]._nextChain.y + _rightChains[i]._nextChain.vec2d.y );
                } else {
                    graphics.drawCircle ( _leftChains[0].x, _leftChains[0].y, 10 );
                    graphics.drawCircle ( _rightChains[0].x, _rightChains[0].y, 10 );
                    graphics.moveTo ( _leftChains[0].x, _leftChains[0].y );
                    graphics.lineTo ( _leftChains[1]._nextChain.x, _leftChains[1]._nextChain.y );
                    graphics.moveTo ( _rightChains[0].x, _rightChains[0].y );
                    graphics.lineTo ( _rightChains[1]._nextChain.x, _rightChains[1]._nextChain.y );
                }
            }
            var p1:Point = new Point ( _leftChains[_leftChains.length - 1].x + _leftChains[_leftChains.length - 1].vec2d.x, _leftChains[_leftChains.length - 1].y + _leftChains[_leftChains.length - 1].vec2d.y );
            var p2:Point = new Point ( _rightChains[_rightChains.length - 1].x + _rightChains[_rightChains.length - 1].vec2d.x, _rightChains[_rightChains.length - 1].y + _rightChains[_rightChains.length - 1].vec2d.y );
            graphics.drawCircle ( p1.x, p1.y, 5 );
            graphics.drawCircle ( p2.x, p2.y, 5 );            
            graphics.moveTo ( p1.x, p1.y );
            graphics.lineTo ( p2.x, p2.y );
            _leftChains[0].vec2d.x = 0;
            _leftChains[0].vec2d.y = 0;
            _rightChains[0].vec2d.x = 0;
            _rightChains[0].vec2d.y = 0;
            _table.x = ( p1.x + p2.x ) / 2 - _table.width / 2;            
            _table.rotation = 0;
            _table.y = ( p1.y + p2.y ) / 2;
            var tmpY:Number = _table.y;
            angle = Math.atan2 ( p2.y - p1.y, p2.x - p1.x ) * (180 / Math.PI);
            angle < 0 ? angle + 360 : angle;
            _table.rotation = angle;
            _table.y -= _table.y - tmpY;
        }
        
    }
    
}

import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Point
class Chain extends Sprite {
    
    public var vec2d:            Point = new Point ();
    
    public var _nextChain:        Chain;
    
    public function Chain ( $nextChain:Chain = null ) :void {
        _nextChain = $nextChain;
        addEventListener ( Event.ENTER_FRAME, core );
    }
    
    private function core ( event:Event ) :void {
        x += vec2d.x;
        y += vec2d.y;
        vec2d.y += .5;
        vec2d.x *= .95;
    }
    
}
