/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vFQE
 */

package {
	import flash.display.Graphics;
    import flash.display.Sprite;
	import flash.events.MouseEvent;
    public class FlashTest extends Sprite {
		private const NUM:uint = 31;
		
        public function FlashTest() {
			draw();
			stage.addEventListener(MouseEvent.CLICK, onClick);
        }
		
		private function onClick(e:MouseEvent):void {
			draw();
		}
		
		private function draw():void {
			var order:Array = createOrderArray();

			var g:Graphics = this.graphics;
			g.clear();
			g.beginFill(0xffc0c0);
			g.drawRect(0, 0, 465, 465);
			g.endFill();
			for each (var num:uint in order) {
				var x:uint = num % NUM;
				var y:uint = num / NUM;
				drawPiece(x, y);
			}
		}
		
		private function drawPiece(x:uint, y:uint):void {
			var g:Graphics = this.graphics;

			var gb:uint = 128 + (Math.random() * 64);
			var color:uint = (255 << 16) + (gb << 8) + (gb << 0);

			var px:Number = (x * 15);
			var py:Number = (y * 15);
			var size:Number = Math.random() * 20 + 50;

			g.beginFill(color);
			for (var index:uint = 0; index < 3; ++index) {
				var rad:Number = Math.random() * Math.PI * 2;
				if (index == 0) {
					g.moveTo(px + (Math.cos(rad) * size), py + (Math.sin(rad) * size));
				}
				g.lineTo(px + (Math.cos(rad) * size), py + (Math.sin(rad) * size));
			}
			g.endFill();
		}

		private function createOrderArray():Array {
			var array:Array = new Array();
			var shuffled:Array = new Array();
			for (var index:uint = 0; index < NUM * NUM; ++index) {
				array.push(index);
			}
		
			while (array.length > 0) {
				var i:uint = Math.random() * array.length;
				shuffled.push(array[i]);
				array.splice(i, 1);
			}
			return shuffled;
		}
    }
}