/**
 * Copyright NewKrok ( http://wonderfl.net/user/NewKrok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vEKA
 */

package {
    import flash.display.Sprite;
    public class Main extends Sprite {
        public function Main () {
            for ( var i:uint = 0; i < 360; i += 360 / 10 ) {
                var radius:Number = 40;
                var angle:Number = i * ( Math.PI / 180 );
                var circle:Sprite = addChild ( new Clock ( radius ) ) as Sprite;
                circle.x = 450 / 2 - 150 * Math.cos ( angle ) - radius;
                circle.y = 450 / 2 - 150 * Math.sin ( angle ) - radius;
            }
            circle = addChild ( new Clock ( 100, 0 ) ) as Sprite;
            circle.x = 450 / 2 - 100;
            circle.y = 450 / 2 - 100;
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
class Clock extends Sprite {
    private var colorThemes:Vector.<Vector.<uint>> = new <Vector.<uint>> [
        new <uint> [0xBDBDBD,0xCCCCCC,0x999999,0x000000]
    ];
    private var currentTime:Date;
    private var _radius:Number;
    private var _colorThemeIndex:uint;
    public function Clock ( $radius:Number, $colorTheme:int = -1 ) :void {
        for ( var i:uint = 0; i < 20; i++ ) {
            colorThemes.push ( new <uint> [Math.floor ( Math.random () * uint.MAX_VALUE ), Math.floor ( Math.random () * uint.MAX_VALUE ), Math.floor ( Math.random () * uint.MAX_VALUE ), Math.floor ( Math.random () * uint.MAX_VALUE )] );
        }
        _radius = $radius;
        _colorThemeIndex = $colorTheme == -1 ? Math.floor ( Math.random () * colorThemes.length ) : $colorTheme;
        addEventListener ( Event.ENTER_FRAME, update );
    }
    private function update ( event:Event ) :void {
        currentTime = new Date ();
        graphics.clear ();
        drawBack ();
        drawMSec ();
        drawSec ();
        drawMin ();
        drawHour ();
    }
    private function drawBack () :void {
        graphics.lineStyle ( 2, colorThemes[_colorThemeIndex][0], 1 );
        graphics.beginFill ( colorThemes[_colorThemeIndex][1], 1 );
        graphics.drawCircle ( _radius, _radius, _radius );
        graphics.endFill ();
        for ( var i:uint = 0; i < 360; i += 360 / 60 ) {
            var angle:Number = i * ( Math.PI / 180 );
            var smallerRadius:Number = _radius * .98;
            var biggerRadius:Number = _radius * 1.02;
            graphics.moveTo ( _radius + smallerRadius * Math.cos ( angle ), _radius + smallerRadius * Math.sin ( angle ) );
            graphics.lineTo ( _radius + biggerRadius * Math.cos ( angle ), _radius + biggerRadius * Math.sin ( angle ) );
        }
        graphics.lineStyle ( 2, colorThemes[_colorThemeIndex][2], 1 );
        for ( i = 0; i < 360; i += 360 / 12 ) {
            angle = i * ( Math.PI / 180 );
            smallerRadius = _radius * .98;
            biggerRadius = _radius * 1.02;
            graphics.moveTo ( _radius + smallerRadius * Math.cos ( angle ), _radius + smallerRadius * Math.sin ( angle ) );
            graphics.lineTo ( _radius + biggerRadius * Math.cos ( angle ), _radius + biggerRadius * Math.sin ( angle ) );
        }
    }
    private function drawMSec () :void {
        graphics.lineStyle ( 1, colorThemes[_colorThemeIndex][3], .1 );
        graphics.moveTo ( _radius, _radius );
        var newRadius:Number = _radius;
        var angle:Number = currentTime.getMilliseconds () / 1000 * 360 * ( Math.PI / 180 );
        graphics.lineTo ( _radius + newRadius * Math.cos ( angle ), _radius + newRadius * Math.sin ( angle ) );
    }
    private function drawSec () :void {
        graphics.lineStyle ( 1, colorThemes[_colorThemeIndex][3], .2 );
        graphics.moveTo ( _radius, _radius );
        var newRadius:Number = _radius * .9;
        var angle:Number = currentTime.getSeconds () / 60 * 360 * ( Math.PI / 180 );
        graphics.lineTo ( _radius + newRadius * Math.cos ( angle ), _radius + newRadius * Math.sin ( angle ) );
    }
    private function drawMin () :void {
        graphics.lineStyle ( 1, colorThemes[_colorThemeIndex][3], .2 );
        graphics.moveTo ( _radius, _radius );
        var newRadius:Number = _radius * .75;
        var angle:Number = currentTime.getMinutes () / 60 * 360 * ( Math.PI / 180 );
        graphics.lineTo ( _radius + newRadius * Math.cos ( angle ), _radius + newRadius * Math.sin ( angle ) );
    }
    private function drawHour () :void {
        graphics.lineStyle ( 1, colorThemes[_colorThemeIndex][3], .2 );
        graphics.moveTo ( _radius, _radius );
        var newRadius:Number = _radius * .5;
        var angle:Number = currentTime.getHours () / 24 * 360 * ( Math.PI / 180 );
        graphics.lineTo ( _radius + newRadius * Math.cos ( angle ), _radius + newRadius * Math.sin ( angle ) );
    }
}