/**
 * Copyright aruerula ( http://wonderfl.net/user/aruerula )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vDe9
 */

package  
{
    //http://d.hatena.ne.jp/ActionScript/20090409/as3_math_atan2
    
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(width = 465, height = 465, backgroundColor = 0xffffff, frameRate = 30)]
    
    public class Arrow extends Sprite 
    {
        private var scx:Number;
        private var scy:Number;
        private var arrow:Sprite;
        
        public function Arrow():void 
        {
            scx = stage.stageWidth * 0.5;
            scy = stage.stageHeight * 0.5;
            
            setup();
            
            stage.addEventListener(Event.ENTER_FRAME, draw);
        }
        
        private function setup():void
        {
            arrow = makeArrow();
            arrow.x = scx;
            arrow.y = scy;
            this.addChild(arrow);
        }
        
        private function makeArrow():Sprite
        {
            var sp:Sprite = new Sprite();
            sp.graphics.lineStyle(1, 0, 1);
            sp.graphics.beginFill(0x6699cc);
            sp.graphics.moveTo( -50, -25);
            sp.graphics.lineTo(0, -25);
            sp.graphics.lineTo(0, -50);
            sp.graphics.lineTo(50, 0);
            sp.graphics.lineTo(0, 50);
            sp.graphics.lineTo(0, 25);
            sp.graphics.lineTo( -50, 25);
            sp.graphics.lineTo( -50, -25);
            sp.graphics.endFill();
            
            return sp;
        }
        
        private function draw(event:Event):void 
        {
            var dx:Number = mouseX - arrow.x;
            var dy:Number = mouseY - arrow.y;
            var radians:Number = Math.atan2(dy, dx);
            arrow.rotation = radians * 180 / Math.PI;
            
        }
        
    }
    
}