/**
 * Copyright aruerula ( http://wonderfl.net/user/aruerula )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vDNS
 */

package {
    
    //http://www.pandama.net/memo/2009/11/as3-colortransformbitmapdatadraw.php

    import flash.display.*;
    import flash.events.*;  
    
    import flash.filters.BlurFilter; 
    import flash.geom.*; 
    

    
    public class Sample20091109 extends Sprite {
        
        private var _ball:Ball;
        private var _canvas:BitmapData;
        private var _world:Sprite;
        
        private var _startBtn:StartBtn;
        
        public function Sample20091109():void{
            
            stage.scaleMode=StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            _init();
        
        }
        
        private function _init():void {
            
            _startBtn = new StartBtn();
            addChild(_startBtn);
            _startBtn.x = stage.stageWidth / 2 - _startBtn.width / 2;
            _startBtn.y = stage.stageHeight / 2 - _startBtn.height / 2;
            _startBtn.addEventListener(MouseEvent.MOUSE_DOWN, _startHandler);
            
        }
        
        private function _startHandler(e:MouseEvent):void {
            
            removeChild(_startBtn);
            
            _ball = new Ball();
            _canvas = new BitmapData( stage.stageWidth,  stage.stageHeight, true, 0xFFFFFF);
            addChild(new Bitmap(_canvas)) as Bitmap;
            
            _world = new Sprite(); 
            _world.addChild(_ball);
            
            this.stage.addEventListener(Event.ENTER_FRAME, _enterframeHandler);

        }
        
        private function _enterframeHandler(e:Event):void {
            _canvas.lock();
            _canvas.applyFilter( _canvas, _canvas.rect, new Point(), new BlurFilter(2,2,3)); 
            _canvas.colorTransform(_canvas.rect, new ColorTransform(1,1,1,1,0,0,0,-1)); 
            _canvas.draw( _world, null, null); 
            _ball.x +=  ((stage.mouseX-_ball.width/2) - _ball.x)/10; 
            _ball.y +=  ((stage.mouseY-_ball.height/2) - _ball.y)/10; 
            _canvas.unlock(); 
        }
    }
}

import flash.display.Sprite; 
 
class Ball extends Sprite {
    
    public function Ball():void {
        
        this.graphics.beginFill(0xCC0000);
        this.graphics.drawCircle(0, 0, 30);
        this.graphics.endFill();
        
    }
    
}

import flash.display.Sprite; 
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormatAlign;
 
class StartBtn extends Sprite {
    
    public function StartBtn():void {
        
        this.graphics.beginFill(0x666666);
        this.graphics.drawRect(0,0, 140, 30);
        this.graphics.endFill();

        this.buttonMode = true;
        this.mouseChildren = false;
        
        var tf= new TextField();
        tf.width = 140;
        tf.autoSize = TextFieldAutoSize.CENTER;    //autoSizeを指定しないと高さが100pxになる
        tf.y = 4;
        tf.selectable=false;
        this.addChild(tf);
            
        var format:TextFormat=new TextFormat();
        format.color=0xFFFFFF;
        format.size = 14;
        format.bold = true;
        tf.defaultTextFormat = format;
        tf.text = "S T A R T";
        
    }
    
}

