/**
 * Copyright darman ( http://wonderfl.net/user/darman )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vDEw
 */

package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    /**
     * マウスを押している間だけカラフルな線が描画される。
     * 
     * @author darman
     */
    public class Issue5 extends Sprite
    {
        //ばねの運動用の変数
        private var _spring:Number = 0.2;
        private var _easing:Number = 0.9;
        private var _vx:Number = 0;
        private var _vy:Number = 0;
        
        //１フレーム前の座標を格納
        private var _prePosX:Number = 0;
        private var _prePosY:Number = 0;
        
        //描画のオンオフ
        private var _isMouseFlg:Boolean = false;
        
        /**
         * コンストラクタでステージを取得する
         */
        public function Issue5() {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        /**
         * 初期設定
         */
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //ステージの設定
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.HIGH;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            //テキストの配置
            var txt:TextField = new TextField();
            txt.defaultTextFormat = new TextFormat("MS Gothic", 23, 0x99ff55, true);
            txt.selectable = false;
            txt.mouseEnabled = false;
            txt.text = "Click Please!";
            txt.autoSize = "left";
            txt.x = stage.stageWidth / 2 - txt.width / 2;
            txt.y = stage.stageHeight / 2 - txt.height / 2;
            addChild(txt);
            
            //マウスに付いて来るオブジェクト
            var mousePoint:Sprite = new Sprite();
            mousePoint.graphics.beginFill(0xff0000);
            mousePoint.graphics.drawCircle(0, 0, 10);
            mousePoint.graphics.endFill();
            mousePoint.mouseEnabled = false;
            addChild(mousePoint);
            
            //イベント登録
            stage.addEventListener(MouseEvent.MOUSE_DOWN, _down );
            stage.addEventListener(MouseEvent.MOUSE_UP, _up );
            mousePoint.addEventListener(Event.ENTER_FRAME, _upData );
        }
        
        /**
         * mousePointを動かし続ける
         */
        private function _upData(e:Event):void {
            //ばねの運動を計算してmousePointに適用
            e.target.x -= _vx = (_vx+(e.target.x - mouseX) * _spring ) * _easing;
            e.target.y -= _vy = (_vy+(e.target.y - mouseY) * _spring ) * _easing;
            
            //mousePointの１レーム前の場所と、現在の場所の差分を描画する
            if (_isMouseFlg) {
                //線の太さと線の色をランダムに生成
                graphics.lineStyle(Math.random() * 20, Math.random() * 0xffffff);
                //線の支点を１フレーム前の座標に設定
                graphics.moveTo(_prePosX, _prePosY);
                //線の終点を現在の座標に設定
                graphics.lineTo(e.target.x, e.target.y);
            }
            
            //mousePointの現在の場所を保存する
            _prePosX = e.target.x;
            _prePosY = e.target.y;
        }
        
        /**
         * マウスダウンで描画を開始する
         */
        private function _down(e:MouseEvent):void {
            _isMouseFlg = true;
        }
        /**
         * マウスアップで描画を終了して、画面を白に戻す
         */
        private function _up(e:MouseEvent):void {
            _isMouseFlg = false;
            graphics.clear();
        }
        
        
        
    }
}