/**
 * Copyright usami ( http://wonderfl.net/user/usami )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vCkz
 */

package {
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import frocessing.display.F5MovieClip2D;
	import frocessing.geom.FGradientMatrix;
	
	[SWF(width=465,height=465,backgroundColor=0x000000,frameRate=60)]
	public class CurveSketch extends F5MovieClip2D
	{
		
		//加速度運動の変数
		//位置
		private var xx:Number;
		private var yy:Number;
		//速度
		private var vx:Number;
		private var vy:Number;
		//加速度の係数
		private var ac:Number;
		//速度の減衰係数
		private var de:Number;
		
		//描画座標
		private var px0:Array;
		private var py0:Array;
		private var px1:Array;
		private var py1:Array;
		//グラデーション用の変数
		private var cs:Array;
		private var ratios:Array;
		
		//描画グループ
		private var shapes:Array;
		

		public function CurveSketch() 
		{
			
			//初期化
			vx = vy = 0.0;
			xx = mouseX;
			yy = mouseY;
			ac = 0.06;
			de = 0.9;
			px0 = [xx, xx, xx, xx];
			py0 = [yy, yy, yy, yy];
			px1 = [xx, xx, xx, xx];
			py1 = [yy, yy, yy, yy];
			
			cs = [0xcc0000,0xcc0000];
			ratios = [0, 255];
			
			shapes = [];
			
			
			//線と塗りの色指定
			noStroke();
			
		}
		
		public function draw():void
		{
			//加速度運動
			xx += vx += ( mouseX - xx ) * ac;
			yy += vy += ( mouseY - yy ) * ac;
			
			var len:Number = mag( vx, vy );
			
			//新しい描画座標
			var x0:Number = xx + 5 + len * 0.15;
			var y0:Number = yy - 4 - len * 0.15;
			var x1:Number = xx - 5 - len * 0.15;
			var y1:Number = yy + 4 + len * 0.15;
			
			//描画座標
			px0.shift(); px0.push( x0 );
			py0.shift(); py0.push( y0 );
			px1.shift(); px1.push( x1 );
			py1.shift(); py1.push( y1 );
			
			//グラデーション形状指定
			var mtx:FGradientMatrix = new FGradientMatrix();
			mtx.createLinear( px0[1], py0[1], px0[2], py0[2] );
			
			var _px0:Array = [px0[0], px0[1], px0[2], px0[3]];
			var _py0:Array = [py0[0], py0[1], py0[2], py0[3]];
			var _px1:Array = [px1[0], px1[1], px1[2], px1[3]];
			var _py1:Array = [py1[0], py1[1], py1[2], py1[3]];
			
			shapes.push( { px0:_px0, py0:_py0, px1:_px1, py1:_py1, mtx:mtx} );
			if (shapes.length >= 60) shapes.shift();
			

			var shapesLength:int = shapes.length;
			for (var i:int = shapesLength-1; i >= 0; i--) 
			{
				var sh:Object = shapes[i];
				var a1:Number = i * 0.03;
				var a2:Number = (i - 1) * 0.03;
				if (a1 > 1) a1 = 1.0;
				if (a2 > 1) a2 = 1.0;
				else if (a2 < 0) a2 = 0.0;
				
				beginGradientFill( "linear", cs, [a2,a1], ratios, sh.mtx );
				beginShape();
				curveVertex( sh.px0[0], sh.py0[0] );
				curveVertex( sh.px0[1], sh.py0[1] );
				curveVertex( sh.px0[2], sh.py0[2] );
				curveVertex( sh.px0[3], sh.py0[3] );
				vertex( sh.px1[2], sh.py1[2] );
				curveVertex( sh.px1[3], sh.py1[3] );
				curveVertex( sh.px1[2], sh.py1[2] );
				curveVertex( sh.px1[1], sh.py1[1] );
				curveVertex( sh.px1[0], sh.py1[0] );
				endShape();
			}
			
			//減衰処理
			vx *= de;
			vy *= de;
		}

	}
}
