/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vBYx
 */

// forked from aobyrne's forked from: forked from: forked from: Tiling
// forked from aobyrne's forked from: forked from: Tiling
// forked from whirlpower's forked from: Tiling
// forked from quqjp's Tiling
package 
{
    /*
    * BitmapをやめてShapeにしてみた。
    * 構造理解のため、そぎ落とせるところはそぎ落としている。
    *
    * ※ 止まりません。
    */
    /**
     * http://wonderfl.net/c/7LZE
     */

    import flash.display.*;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import frocessing.color.ColorHSV;
    import frocessing.color.ColorRGB;
    
    public class TilingLine extends Sprite
    {
        static private const LIMIT_Y:Number = 480;
        private var mapLogic:MapLogic;
        public static var textField:TextField;
        private var csprite:Sprite;
        private var lsprite:Sprite;
        private var currentLine:Line;
        private var lines:Vector.<Line>;
        private var textFormat:TextFormat;
        
        public function TilingLine():void
        {
            if (stage) init(null)
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event):void 
        {
            textFormat = new TextFormat("Lucida Console", 9);
            trace( "TilingLine.init > e : " + e );
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            setDebug();
            csprite = new Sprite;
            addChild(csprite);
            lsprite = new Sprite;
            addChild(lsprite);
            lines = Vector.<Line>([]);
            mapLogic = new MapLogic( 45, 45, 10, 10,false);
            //addEventListener( Event.ENTER_FRAME, render );
            //Wonderfl.capture_delay( 120 );
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            //theMethod();
            yetAnotherMethod();
            
        }
        private function onKeyDown(e:KeyboardEvent):void 
        {
            switch (e.keyCode) 
            {
                /*
                case String("D").charCodeAt():
                    viewAllColors();
                break;
                case String("A").charCodeAt():
                    clearDebug();
                break;
                case String("S").charCodeAt():
                    clearClicked();
                break;
                case String("F").charCodeAt():
                    traceLines();
                break;
                */
                case String("Q").charCodeAt():
                    traceLinesWithTwoColors();
                break;
                /*
                case String("W").charCodeAt():
                    traceLinesWithHueColors();
                break;
                */
                default:
                    
                break;
            }
        }
        
        private function traceLinesWithHueColors():void 
        {
            var le:int = lines.length;
            var colorHSVi:ColorHSV;
            var colorHSVf:ColorHSV;
            for (var i:int = 0; i < le; i++) 
            {
                colorHSVi = new ColorHSV;
                colorHSVf = new ColorHSV;
                colorHSVi.h = 360*((i % 6) / 6 + Math.random() * (1 / 12))
                trace( "colorHSVi.h : " + colorHSVi.h );
                colorHSVf.h = 360*colorHSVi.h * 1.1;
                trace( "colorHSVf.h : " + colorHSVf.h );
                var initColor:Number = colorHSVi.value;
                trace( "initColor : " + initColor );
                var finaColor:Number = colorHSVf.value;
                trace( "finaColor : " + finaColor );
                
                var item:Line = lines[i];
                var t:Vector.<Tile> = item.tiles;
                var normalizedRGB:NormalizedRGB;
                for (var k:int = 0; k < t.length; k++) 
                {
                    normalizedRGB = new NormalizedRGB;
                    var tileItem:Tile = t[k];
                    normalizedRGB.value = interpolateColorsCompact(initColor, finaColor, k / t.length);
                    
                    tileItem.transform.colorTransform = new ColorTransform( normalizedRGB.rr, normalizedRGB.bb, normalizedRGB.gg);
                    
                    var textField:TextField = new TextField;
                    tileItem.addChild(textField);
                    textField.selectable = false;
                    textField.defaultTextFormat = textFormat;
                    textField.text = k.toString();
                }
            }
            
        }
        /**
         * From Quasimondo @ 
         * http://wonderfl.net/c/eYx0
         * @param    a
         * @param    b
         * @param    lerp
         * @return
         */
        private function interpolateColorsCompact( a:int, b:int, lerp:Number ):int
        { 
            var MASK1:int = 0xff00ff; 
            var MASK2:int = 0x00ff00; 

            var f2:int = 256 * lerp;
            var f1:int = 256 - f2;

            return  ((((( a & MASK1 ) * f1 ) + ( ( b & MASK1 ) * f2 )) >> 8 ) & MASK1 ) 
                  | ((((( a & MASK2 ) * f1 ) + ( ( b & MASK2 ) * f2 )) >> 8 ) & MASK2 );
                
        }        
        private function traceLinesWithTwoColors():void 
        {
            
            var l:Vector.<Line> = lines;
            var le:int = l.length
            for (var i:int = 0; i < le; i++) 
            {
                var initColor:Number = 0xffffff * Math.random()-100;
                var endnVolor:Number = initColor+100;
                var item:Line = l[i];
                var t:Vector.<Tile> = item.tiles;
                var normalizedRGB:NormalizedRGB;
                for (var k:int = 0; k < t.length; k++) 
                {
                    normalizedRGB = new NormalizedRGB;
                    var tileItem:Tile = t[k];
                    normalizedRGB.value = interpolateColorsCompact(initColor, endnVolor, k / t.length);
                    
                    tileItem.transform.colorTransform = new ColorTransform( normalizedRGB.rr, normalizedRGB.bb, normalizedRGB.gg);;
                    var textField:TextField = new TextField;
                    tileItem.addChild(textField);
                    textField.selectable = false;
                    textField.defaultTextFormat = textFormat;
                    textField.text = k.toString();
                }
            }
            
        }
        
        private function traceLines():void 
        {
            var l:Vector.<Line> = lines;
            var le:int = l.length
            for (var i:int = 0; i < le; i++) 
            {
                var item:Line = l[i];
                var t:Vector.<Tile> = item.tiles;
                for (var k:int = 0; k < t.length; k++) 
                {
                    var tileItem:Tile = t[k];
                    
                }
                var normalizedRGB:NormalizedRGB;
                var colorHSV:ColorHSV = new ColorHSV;
                var colorTransform:ColorTransform;
                cTrace( "item.numChildren : " + item.numChildren );
                for (var j:int = 0; j < item.numChildren; j++) 
                {
                    normalizedRGB = new NormalizedRGB;
                    colorHSV = new ColorHSV;
                    
                    colorHSV.h = 360 * j / (item.numChildren -1);
                    normalizedRGB.value = colorHSV.value;
                    
                    var tile:Tile = item.getChildAt(j) as Tile;
                    
                    colorTransform = new ColorTransform( normalizedRGB.rr, normalizedRGB.bb, normalizedRGB.gg);
                    
                    tile.transform.colorTransform = colorTransform;
                    var textField:TextField = new TextField;
                    tile.addChild(textField);
                    textField.selectable = false;
                    textField.defaultTextFormat = textFormat;
                    textField.text = j.toString();
                }
            }
        }
        
        private function clearClicked():void 
        {
            var l:Vector.<Line> = lines;
            var le:int = l.length
            for (var i:int = 0; i < le; i++) 
            {
                var item:Line = l[i];
                item.doClearClick();
                
            }
        }
        
        private function clearDebug():void 
        {
            textField.text = "";
        }
        
        private function viewAllColors():void 
        {
            cTrace( "viewAllColors");
            var l:Vector.<Line> = lines;
            cTrace( "lines : " + lines );
            for each (var item:Line in l) 
            {
                cTrace( "item : " + item );
                item.doColorTransform();
            }
        }
        
        private function setDebug():void 
        {
            textField = new TextField();
            textField.width = 400;
            textField.height = 670;
            textField.border = true;
            textField.x = 465;
            textField.defaultTextFormat = textFormat;
            addChild(textField);
        }
        
        
        private function theMethod():void 
        {
            trace( "TilingLine.theMethod" );
            csprite.visible = false;
            trace( "csprite.visible : " + csprite.visible );
            while (Tile(csprite.addChild( mapLogic.create() )).y < LIMIT_Y) 
            {
                
                
            }
            setTilesStaticProperties();
            mapLogic.reset();
            mapLogic.hasPeriodBeenSet = true;
            while (csprite.numChildren)
            {
                csprite.removeChildAt(csprite.numChildren-1)
            }
            
            csprite.visible = true;
            ///*/
            addEventListener( Event.ENTER_FRAME, render );
            /*/
            var tile:Tile = Tile(csprite.addChild(mapLogic.create()));
            setCurrentLine(0, 0);
            currentLine.addChild(tile);
            tile.y = tile.y - currentLine.y;
            while (tile.y < LIMIT_Y) 
            {
                tile = Tile(csprite.addChild( mapLogic.create() ));
                if (true && tile.x<2) 
                {
                    setCurrentLine(tile.x,tile.y);
                }
                currentLine.addChild(tile);
                tile.y = tile.y - currentLine.y;
            }
            //*/
        }
        
        private function setTilesStaticProperties():void 
        {
            Tile.period = Tile.counter;
            Tile.counter = 0;
            Tile.linePeriod = Tile.lineCounter;
            Tile.lineCounter = 0;
        }
        
        private function yetAnotherMethod():void 
        {
            while (mapLogic.setValues()<LIMIT_Y) 
            {
                
            }
            var v:Array = mapLogic.values;
            var tile:Tile; 
            for (var i:int = 0; i < v.length; i++) 
            {
                var item:Array = v[i];
                tile = Tile(csprite.addChild(new Tile(item[0], item[1], item[2], item[3], item[4], item[5])));
                if (true && tile.x<2) 
                {
                    setCurrentLine(tile.x,tile.y);
                }
                currentLine.addChild(tile);
                tile.y = tile.y - currentLine.y;
            }
            trace('finished');
            //mapLogic
        }
        
        private function cTrace(msg:String):void 
        {
            traceAt(msg);
        }
        
        private function render( e:Event ):void
        {
            var tile:Tile = Tile( mapLogic.create() );
            if (tile.y > LIMIT_Y)
            {
                removeEventListener(Event.ENTER_FRAME, render );
                
            }
            else
            {
                if (true && tile.x<2) 
                {
                    setCurrentLine(tile.x,tile.y);
                }
                currentLine.addChild(tile);
                tile.y = tile.y - currentLine.y;
                
            }
        }
        
        private function setCurrentLine(xArg:Number, yArg:Number):void 
        {
            cTrace( "pos : " + xArg+', ' + yArg );
            currentLine = new Line;
            lines[lines.length] = currentLine;
            currentLine.colorRGB.value = 0xffffff * Math.random();
            lsprite.graphics.lineStyle(3, currentLine.colorRGB.value);
            lsprite.graphics.moveTo(xArg, yArg);
            lsprite.graphics.lineTo(xArg + 465, yArg);
            addChild(currentLine);
            currentLine.y = yArg;
            //addOverOutListeners(currentLine,true);
            //currentLine.addEventListener(MouseEvent.CLICK, currentLineClickHandler);
            swapChildren(currentLine,lsprite);
        }
        
        public static function traceAt(msg:String):void
        {
            textField.appendText(msg + '\n');
            textField.scrollV = textField.maxScrollV;
        }
        
    }
}

import flash.display.*;
import flash.events.MouseEvent;
import flash.text.TextField;
import frocessing.color.ColorHSV;
import frocessing.color.ColorRGB;
import flash.geom.ColorTransform;    
internal class MapLogic
{
    private var _map            :Array = [];
    
    private var gridW        :int;
    private var igridW        :int;
    
    private var gridH        :int;
    private var igridH        :int;
    
    private var tileMax        :int;
    private var itileMax        :int;
    
    private var tileScale    :int = 10;
    private var itileScale    :int = 10;
    
    private var _isDisplaying:Boolean;
    public  var emptyPos        :int = 0;
    public var hasPeriodBeenSet:Boolean;
    
    private var _values:Array;
    private var count:uint;
    
    public function MapLogic( gridW:int, gridH:int, tileMax:int, tileScale:int ,isDisplaying:Boolean = true):void
    {
        _isDisplaying = isDisplaying;
        this.gridW        = igridW=gridH;
        this.gridH        = igridH=gridW;
        this.tileMax        = itileMax=tileMax;
        this.tileScale    = itileScale=tileScale;
        _values = [];
    }
    
    
    private function cTrace(arg1:String):void 
    {
        TilingLine.traceAt(arg1);
    }
    
    public function setValues():uint
    {
        cTrace('-----------------------'+_values.length+'----------------------------');
        var position        :int = -1;
        var emptyWidth    :int = 0;
        var icount:int = 0;
        for ( var i:int = emptyPos; i < emptyPos + 500 ; i++ )
        {
            icount++;
            if (hasPeriodBeenSet)
            {
                //cTrace( "i : " + i );
            }
            if ( !_map[i] && position == -1 )
            {
                //cTrace( "( !_map[i] && position == -1 ) : " + ( !_map[i] && position == -1 ) );
                position = i;
                emptyWidth++;
            } else if ( emptyWidth >= tileMax )
            {
                //cTrace( "( emptyWidth >= tileMax ) : " + ( emptyWidth >= tileMax ) );
                break;
            } else if ( !_map[i] && !( i % gridW == 0 && i != emptyPos ) ) 
            {
                //cTrace( "( !_map[i] && !( i % gridW == 0 && i != emptyPos ) ) : " + ( !_map[i] && !( i % gridW == 0 && i != emptyPos ) ) );
                emptyWidth++;
            } else if ( position != -1 ) 
            {
                //cTrace( "( position != -1 ) : " + ( position != -1 ) );
                break;
            }
        }
        cTrace( "_map.length : " + _map.length );
        cTrace( "icount : " + icount );
        //trace( "count : " + count );
        var ww:int    = int( Math.random() * emptyWidth ) + 1;
        
        var p:int = position;
        for ( var yy:int = 0; yy < ww; yy++ )
        {
            for ( var xx:int = 0; xx < ww; xx++ )
            {
                _map[p] = 1;
                p++;
            }
            p += gridW - ww;
        }
        emptyPos = position + ww;
        
        var px:int = position % gridW * tileScale;
        var py:int = position == 0 ? 0 : int( position / gridW ) * tileScale;
        var color:uint = !hasPeriodBeenSet?0:1;
        _values[_values.length] = [px, py, ww * tileScale, ww * tileScale, _isDisplaying ,0xffffff];  
        cTrace('---------------------------------------------------');
        return uint (py);
    }
    public function create():Tile
    {
        var position        :int = -1;
        var emptyWidth    :int = 0;
        var icount:int = 0;
        for ( var i:int = emptyPos; i < emptyPos + 500 ; i++ )
        {
            icount++;
            if (hasPeriodBeenSet)
            {
                //cTrace( "i : " + i );
            }
            if ( !_map[i] && position == -1 )
            {
                //cTrace( "( !_map[i] && position == -1 ) : " + ( !_map[i] && position == -1 ) );
                position = i;
                emptyWidth++;
            } else if ( emptyWidth >= tileMax )
            {
                //cTrace( "( emptyWidth >= tileMax ) : " + ( emptyWidth >= tileMax ) );
                break;
            } else if ( !_map[i] && !( i % gridW == 0 && i != emptyPos ) ) 
            {
                //cTrace( "( !_map[i] && !( i % gridW == 0 && i != emptyPos ) ) : " + ( !_map[i] && !( i % gridW == 0 && i != emptyPos ) ) );
                emptyWidth++;
            } else if ( position != -1 ) 
            {
                //cTrace( "( position != -1 ) : " + ( position != -1 ) );
                break;
            }
        }
        cTrace( "_map.length : " + _map.length );
        cTrace( "icount : " + icount );
        trace( "-count : " + count );
        var ww:int    = hasPeriodBeenSet ? _values[count++][2] / tileScale:int( Math.random() * emptyWidth ) + 1;
        
        var p:int = position;
        for ( var yy:int = 0; yy < ww; yy++ )
        {
            for ( var xx:int = 0; xx < ww; xx++ )
            {
                _map[p] = 1;
                p++;
            }
            p += gridW - ww;
        }
        emptyPos = position + ww;
        
        var px:int = position % gridW * tileScale;
        var py:int = position == 0 ? 0 : int( position / gridW ) * tileScale;
        var color:uint = 0;
        if (!hasPeriodBeenSet)
        {
            _values[_values.length] = [px, py, ww * tileScale, ww * tileScale, _isDisplaying ];  
        }
        else 
        {
            color = 1;
        }
        return new Tile( px, py, ww * tileScale, ww * tileScale,_isDisplaying,color );
    }
    
    public function reset():void 
    {
        trace( "MapLogic.reset" );
        this.gridW        = igridW;
        this.gridH        = igridH;
        this.tileMax      = itileMax;
        this.tileScale    = itileScale;
        count = 0;
        trace( "count : " + count );
        //values.length = 0;
        _map = null;
        _map = [];
        emptyPos = 0;
    }
    
    public function draw(csprite:Sprite):void 
    {
    }
    
    public function get values():Array 
    {
        return _values.concat();
    }
}
internal class Tile extends Sprite
{
    static private var color:uint;
    public static var counter:int;
    public static var lineCounter:int;
    public static var period:uint = 310;
    public static var linePeriod:uint = 310;
    private const colors:Array=[0xff0000,0,0xff]
    private var pCounter:int;
    public function Tile( _x:int, _y:int, _w:int, _h:int,isDisplaying:Boolean=true,colorArg:uint=0 ):void
    {
        if (_x<0.1) 
        {
            lineCounter++;
            if (colorArg) 
            {
                color = Math.random() * 0xffffff;
                color = 0xffffff;
                if (lineCounter%2==1 && false) 
                {
                    color = colors[lineCounter % colors.length];
                    //color = 0;
                }
            }
            else
            {
                color = colors[lineCounter % colors.length];
            }
        }
        this.x = _x+1;
        this.y = _y+1;
        counter++;
        if (isDisplaying)
        {
            var tf:TextField = (addChild(new TextField) as TextField);
            tf.text = counter.toString();
            tf.border = true;
            tf.selectable = false;
            tf.width = _w-3;
            tf.height = 20;
        }
        if (lineCounter%2==1)graphics.lineStyle( 2,  colors[lineCounter % colors.length] );
        graphics.beginFill(color);
        graphics.lineStyle(0);
        graphics.drawRect( 0, 0, _w - 2, _h - 2 );
        addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
        pCounter = counter;
    }
    
    public function cowlorize():void 
    {
        
        //transform.colorTransform = 
    }
    
    private function onMouseOver(e:MouseEvent):void 
    {
        
    }
    
    private function cTrace(arg1:String):void 
    {
        TilingLine.traceAt(arg1);
    }
}
class Line extends Sprite
{
    
    public var colorRGB:NormalizedRGB = new NormalizedRGB();
    private var _hasBeenClicked:Boolean;
    private var isToBeReset:Boolean;
    private var isShowing:Boolean;
    public var tiles:Vector.<Tile> = Vector.<Tile>([]);
    public function get colorTransform():ColorTransform { return new ColorTransform(colorRGB.rr, colorRGB.gg, colorRGB.bb); }
    
    public function get hasBeenClicked():Boolean 
    {
        return _hasBeenClicked;
    }
    override public function addChild(child:DisplayObject):DisplayObject 
    {
        tiles[tiles.length] = Tile(child);
        return super.addChild(child);
    }
    public function Line() 
    {
        super();
        addEventListener(MouseEvent.CLICK, doClickHandler);
        setOverOutListeners(true);
    }
    
    private function doClickHandler(e:MouseEvent):void
    {
        if (hasBeenClicked) 
        {
            setOverOutListeners(true);
            doMouseOut(null);
        }
        else
        {
            setOverOutListeners(false);
            transform.colorTransform = colorTransform;
        }
        _hasBeenClicked = !_hasBeenClicked;
    }
    
    private function setOverOutListeners(isAdding:Boolean):void 
    {
        if (isAdding) 
        {
            addEventListener(MouseEvent.MOUSE_OVER, doMouseOver);
            addEventListener(MouseEvent.MOUSE_OUT, doMouseOut);
        }
        else
        {
            removeEventListener(MouseEvent.MOUSE_OVER, doMouseOver);
            removeEventListener(MouseEvent.MOUSE_OUT, doMouseOut);
        }
    }
    
    private function doMouseOver(e:MouseEvent):void 
    {
        transform.colorTransform = new ColorTransform(colorRGB.rr, colorRGB.gg, colorRGB.bb, 1);
    }
    
    private function doMouseOut(e:MouseEvent):void 
    {
        transform.colorTransform = new ColorTransform(1, 1, 1, 1);
    }
    
    public function doColorTransform():void 
    {
        if (!isShowing) 
        {
            transform.colorTransform = colorTransform;
            setOverOutListeners(false);
        }
        else
        {
            if (!_hasBeenClicked) 
            {
                doMouseOut(null);
                setOverOutListeners(true);
            }
        }
        isShowing = !isShowing;
    }
    
    public function doClearClick():void 
    {
        isShowing = false;
        if (_hasBeenClicked) 
        {
            setOverOutListeners(true);
        }
        _hasBeenClicked = false;
        doMouseOut(null);
    }
    
}
class NormalizedRGB extends  ColorRGB
{
    private const inv:Number = 1 / 255;
    public function get rr():Number { return r*inv; }
    public function get gg():Number { return g*inv; }
    public function get bb():Number { return b*inv; }
}