/**
 * Copyright saku_K ( http://wonderfl.net/user/saku_K )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vAb2l
 */

// forked from soundkitchen's 393 with blur
/**
 *  we can get each twitter icons with flash!!
 */
package
{
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.net.*;
    import flash.system.*;

    /**
     *  I try to getting sakusan393's icon!!
     */
    [SWF(width=465, height=465, frameRate=45, backgroundColor=0xFFFFFF)]
    public class sakusan393 extends Sprite
    {
        /**
         *  declared url for his icon.
         */
        public static const IMAGE_URL:String = "http://a3.twimg.com/profile_images/770090945/icon.jpg";
        
        private var canvas:Sprite;
        private var film:BitmapData;
        private var photo:Bitmap;

        /**
         *  constructor.
         */        
        public function sakusan393()
        {
            addEventListener(Event.ADDED_TO_STAGE, initialize);
        }
        
        /**
         *  initialize the object.
         */
        private function initialize(evt:Event):void
        {
            var req:URLRequest,
                ctx:LoaderContext,
                loader:Loader,
                info:LoaderInfo;

            // remove event.
            removeEventListener(Event.ADDED_TO_STAGE, initialize);
            // setup for loading image.
            req = new URLRequest(IMAGE_URL);
            ctx = new LoaderContext(true, ApplicationDomain.currentDomain);
            loader = new Loader();
            info = loader.contentLoaderInfo;
            info.addEventListener(Event.INIT, initHandler);
            info.addEventListener(IOErrorEvent.IO_ERROR, errorHandler);
            info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, errorHandler);
            // start loading.
            loader.load(req, ctx);
        }
        
        /**
         *  will execute when initialized loader object.
         */
        private function initHandler(evt:Event):void
        {
            var W:Number, H:Number,
                loader:Loader,
                info:LoaderInfo,
                image:Bitmap,
                background:Shape,
                container:Sprite;

            W = stage.stageWidth || 465;
            H = stage.stageHeight || 465;
            
            background = addChildAt(new Shape(), 0) as Shape;
            background.graphics.beginFill(0);
            background.graphics.drawRect(0, 0, W, H);
            background.graphics.endFill();

            canvas = new Sprite();            
            film = new BitmapData(W, H, true, 0);
            photo = addChild(new Bitmap(film)) as Bitmap;
            photo.smoothing = true;

            info = LoaderInfo(evt.target);
            info.removeEventListener(Event.INIT, initHandler);
            info.removeEventListener(IOErrorEvent.IO_ERROR, errorHandler);
            info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, errorHandler);

            loader = info.loader;
            image = Bitmap(loader.content);
            image.x -= image.width >> 1;
            image.y -= image.height >> 1;
            container = canvas.addChild(new Sprite()) as Sprite;
            container.name = "393";
            container.addChild(image);
            container.x = W >> 1;
            container.y = H >> 1;
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        /**
         *  will execute when failed image loading.
         */
        private function errorHandler(evt:Event):void
        {
             // What can I do??
             trace(evt);
        }
        
        private function enterFrameHandler(evt:Event):void
        {
            var container:Sprite;
            
            container = canvas.getChildByName('393') as Sprite;

            if (!container) return;
            
            container.rotationY += 3;
            
            film.lock();
            //film.fillRect(film.rect, 0);
            film.applyFilter(film, film.rect, new Point(), new BlurFilter(64, 16, BitmapFilterQuality.MEDIUM));
            film.draw(canvas);
            film.colorTransform(film.rect, new ColorTransform(1, 1, 1, .95));
            film.unlock();
        }
    }
}