/**
 * Copyright mex_takagi ( http://wonderfl.net/user/mex_takagi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v9QF
 */

/**
 * ごく普通のワンコ掃除神経衰弱です。
 */
package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.MovieClip;
	import flash.display.Loader;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.net.URLRequest;
	import flash.system.ApplicationDomain;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.tweens.ITween;
	import org.libspark.betweenas3.events.TweenEvent;
	
	[SWF(backgroundColor="#FFFFFF", frameRate="30", width="465", height="465")]
	public class Unko extends Sprite 
	{
		public static var GRAPHICS_URL:String = "http://swf.wonderfl.net/static/assets/checkmate05/wancoAmateur.swf";
		private var _motionArray:Array = ["StayMotion", 
										  "JumpMotion", 
										  "HighJumpMotion", 
										  "WalkMotion", 
										  "RunMotion", 
										  "SquatMotion", 
										  "QuestionMotion", 
										  "ExclamationMotion", 
										  "HeartMotion", 
										  "PoutMotion", 
										  "StarMotion", 
										  "SingMotion", 
										  "SleepMotion"];
		private var _domain:ApplicationDomain;
		private var _max:uint;
		private var _wankoArray:Array;
		private var _judgeArray:Array;
		private var _triggerArray:Array;
		private var _motionMCArray:Array;
		private var _combo:uint;
		private var _restCount:uint;
		private var _score:uint;
		private var _life:uint;
		private var _scoreField:TextField;
		private var _lifeField:TextField;
		private var _titleField:TextField;
		private var _catchField:TextField;
		private var _blur:BlurFilter;
		/**
		 * constructor
		 */
		public function Unko()
		{
			super();
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			Wonderfl.capture_delay(5);
			_judgeArray = new Array();
			_wankoArray = new Array();
			_triggerArray = new Array();
			_motionMCArray = new Array();
			_max = 20;
			_restCount = 20;
			_combo = 0;
			_score = 0;
			_life = 5;
			
			_blur = new BlurFilter(20, 20, 1);
			
			_titleField = createField(createFormat(24), "Let's ワンコ掃除");
			_titleField.x = 40;
			_titleField.y = 30;
			addChild(_titleField);
			
			_catchField = createField(createFormat(14), "神経衰弱の要領でワンコを掃除しろ！！！！！");
			_catchField.x = 40;
			_catchField.y = _titleField.y + _titleField.height + 10;
			addChild(_catchField);
			
			_scoreField = createField(createFormat(11), "SCORE:0");
			_scoreField.x = stage.stageWidth - _scoreField.width - 40;
			_scoreField.y = 30;
			addChild(_scoreField);
			
			_lifeField = createField(createFormat(11), "LIFE:5");
			_lifeField.x = stage.stageWidth - _lifeField.width - 40;
			_lifeField.y = 45;
			addChild(_lifeField);
			
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onCompleteHanlder);
			loader.load(new URLRequest(GRAPHICS_URL));
		}
		/**
		 * ロード完了
		 * @param event Event
		 */
		private function onCompleteHanlder(event:Event):void 
		{
			event.target.removeEventListener(Event.COMPLETE, onCompleteHanlder);
			_domain = event.target.applicationDomain;
			
			var hNum:int = 5;
			var cnt:int = 0;
			var i:uint = 0;
			for (i = 0; i < _max;i++ )
			{
				var temp:MovieClip = new ( _domain.getDefinition( _motionArray[0] ) as Class );
				temp.x = cnt % hNum * 80 + 70;
				temp.y = Math.floor(cnt / hNum) * 80  + 180;
				temp.id = String(i);
				temp.gotoAndStop(1);
				_triggerArray.push(temp);
				cnt++;
			}
			generateGame();
		}
		/**
		 * ワンコ並べる
		 */
		private function generateGame():void 
		{
			var i:uint = 0;
			var rand:uint;
			var motionLen:uint = _motionArray.length;
			
			for (i = 0; i < _max / 2; i++ )
			{
				rand = Math.floor(Math.random() * motionLen);
				_wankoArray.push(_motionArray[rand]);
				_wankoArray.push(_motionArray[rand]);
			}
			//trace(_wankoArray);
			for (i = 0; i < _max;i++ )
			{
				var trigger:MovieClip = _triggerArray[i];
				addChild(trigger);
				rand = Math.floor(Math.random() * _wankoArray.length);
				var motion:MovieClip = new ( _domain.getDefinition( _wankoArray[rand] ) as Class );
				motion.type = _wankoArray[rand];
				motion.x = trigger.x;
				motion.y = trigger.y;
				motion.visible = false;
				addChild(motion);
				_motionMCArray.push(motion);
				trigger.targetMotion = motion;
				_wankoArray.splice(rand, 1);
			}
			addListener();
		}
		/**
		 * addListener
		 */
		private function addListener():void 
		{
			for (var i:uint = 0; i < _max;i++ )
			{
				var trigger:MovieClip = _triggerArray[i];
				trigger.wc2.addEventListener( MouseEvent.CLICK, clickHandler);
				trigger.buttonMode = trigger.useHandCursor = true;
			}
		}
		/**
		 * killListener
		 */
		private function killListener():void 
		{
			for (var i:uint = 0; i < _max;i++ )
			{
				var trigger:MovieClip = _triggerArray[i];
				trigger.wc2.removeEventListener( MouseEvent.CLICK, clickHandler);
				trigger.buttonMode = trigger.useHandCursor = false;
			}
		}
		/**
		 * クリック時
		 * @param event
		 */
		public function clickHandler(event:MouseEvent):void 
		{
			var motion:MovieClip = event.currentTarget.parent.targetMotion;
			motion.gotoAndPlay(1);
            motion.wc2.wc3.gotoAndPlay(2);
			event.currentTarget.parent.visible = false;
			motion.visible = true;
			var obj:Object = new Object();
			obj.trigger = event.currentTarget.parent;
			obj.motion = motion;
			//trace(motion.type);
			_judgeArray.push(obj);
			judge();
		}
		/**
		 * スコアアップデート
		 */
		private function updateScore():void 
		{
			_scoreField.text = "SCORE:" + String(_score);
			_scoreField.x = stage.stageWidth - _scoreField.width - 40;
		}
		/**
		 * ライフアップデート
		 */
		private function updateLife():void 
		{
			_lifeField.text = "LIFE:" + String(_life);
			_lifeField.x = stage.stageWidth - _lifeField.width - 40;
		}
		/**
		 * ゲームオーバー
		 */
		private function gameOver():void 
		{
			//trace("Game Over");
			var _gameOver:Sprite = createGameOver();
			addChild(_gameOver);
			_gameOver.buttonMode = true;
			_gameOver.addEventListener(MouseEvent.CLICK, function(event:MouseEvent):void
			{
				_gameOver.buttonMode = false;
				_gameOver.removeEventListener(MouseEvent.CLICK, arguments.callee);
				removeChild(_gameOver);
				regenerate(true);
			});
		}
		/**
		 * ゲーム終了時
		 */
		private function regenerate(over:Boolean = false):void 
		{
			var i:uint = 0;
			for (i = 0; i < _max;i++ )
			{
				_triggerArray[i].visible = true;
				if (contains(_motionMCArray[i])) removeChild(_motionMCArray[i]);
			}
			_restCount = 20;
			_wankoArray = [];
			generateGame();
			if (over)
			{
				_combo = 0;
				_score = 0;
				_life = 5;
				updateScore();
				updateLife();
			}
		}
		/**
		 * 判定
		 */
		private function judge():void 
		{
			if (_judgeArray.length == 2)
			{
				killListener();
				var i:uint = 0;
				if (_judgeArray[0].motion.type == _judgeArray[1].motion.type)
				{
					//trace("あたり");
					_judgeArray[1].motion.wc2.wc3.addEventListener(Event.ENTER_FRAME, function(event:Event):void
					{
						_judgeArray[1].motion.wc2.wc3.nextFrame;
						if (_judgeArray[1].motion.wc2.wc3.currentFrame == _judgeArray[1].motion.wc2.wc3.totalFrames)
						{
							_judgeArray[1].motion.wc2.wc3.removeEventListener(Event.ENTER_FRAME, arguments.callee);
							for (i = 0; i < 2; i++) 
							{
								_judgeArray[i].trigger.visible = true;
								_judgeArray[i].motion.visible = false;
								_judgeArray[i].trigger.gotoAndStop(1);
								_judgeArray[i].trigger.wc2.wc3.gotoAndStop(1);
								_judgeArray[i].motion.gotoAndStop(1);
								_judgeArray[i].motion.wc2.wc3.gotoAndStop(1);
								createPerfume(_judgeArray[i].trigger);
							}
							var t:ITween = BetweenAS3.parallel
														(
															BetweenAS3.tween(_judgeArray[0].trigger, { alpha:0 }, null, 1),
															BetweenAS3.tween(_judgeArray[1].trigger, { alpha:0 }, null, 1)
														);
							t.addEventListener(TweenEvent.COMPLETE, function(event:TweenEvent):void
							{
								_judgeArray[0].trigger.visible = false;
								_judgeArray[1].trigger.visible = false;
								_judgeArray[0].trigger.alpha = 1;
								_judgeArray[1].trigger.alpha = 1;
								_combo++;
								_score += _combo;
								_life++;
								updateScore();
								updateLife();
								addListener();
								_judgeArray = [];
								_restCount -= 2;
								if (_restCount == 0)
								{
									regenerate();
								}
							});
							t.play();
						}
					});
				}
				else
				{
					//trace("はずれ");
					_judgeArray[1].motion.wc2.wc3.addEventListener(Event.ENTER_FRAME, function(event:Event):void
					{
						_judgeArray[1].motion.wc2.wc3.nextFrame;
						if (_judgeArray[1].motion.wc2.wc3.currentFrame == _judgeArray[1].motion.wc2.wc3.totalFrames)
						{
							_judgeArray[1].motion.wc2.wc3.removeEventListener(Event.ENTER_FRAME, arguments.callee);
							for (i = 0; i < 2; i++) 
							{
								_judgeArray[i].trigger.visible = true;
								_judgeArray[i].motion.visible = false;
								_judgeArray[i].trigger.gotoAndStop(1);
								_judgeArray[i].trigger.wc2.wc3.gotoAndStop(1);
								_judgeArray[i].motion.gotoAndStop(1);
								_judgeArray[i].motion.wc2.wc3.gotoAndStop(1);
							}
							_combo = 0;
							_life--;
							if (_life == 0)
							{
								gameOver();
								updateLife();
								_judgeArray = [];
							}
							else
							{
								updateLife();
								addListener();
								_judgeArray = [];
							}
						}
					});
				}
			}
		}
		/**
		 * rank
		 */
		private function rank():String 
		{
			var str:String = "";
			if (_score <= 10)
			{
				str = "【 未熟な掃除人 】";
			}
			else if (_score > 10 && _score <= 30)
			{
				str = "【 普通の掃除人 】";
			}
			else if (_score > 30 && _score <= 50)
			{
				str = "【 いけてる掃除人 】";
			}
			else if (_score > 50 && _score <= 80)
			{
				str = "【 最高の掃除人 】";
			}
			else if (_score > 80)
			{
				str = "【 伝説の掃除人 】";
			}
			return str;
		}
		/**
		 * createGameOver
		 */
		private function createGameOver():Sprite 
		{
			var sprite:Sprite = new Sprite();
			sprite.graphics.beginFill(0x000000, 0.8);
			sprite.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			sprite.graphics.endFill();
			
			var format:TextFormat = new TextFormat();
			format.color = 0xFFFFFF;
			format.align = "center";
			var field:TextField = createField(format, "GAME OVER\n\nあなたのランクは\n" + rank() + "\n\n\nCLICK TO RETRY");
			field.mouseEnabled = false;
			field.x = (stage.stageWidth - field.width) / 2;
			field.y = (stage.stageHeight - field.height) / 2;
			sprite.addChild(field);
			
			return sprite;
		}
		/**
		 * createField
		 * @param format
		 * @param str
		 * @return textField
		 */
		private function createField(format:TextFormat, str:String):TextField 
		{
			var field:TextField = new TextField();
			field.defaultTextFormat = format;
			field.autoSize = "left";
			field.selectable = false;
			field.text = str;
			return field;
		}
		/**
		 * createFormat
		 * @param size
		 */
		private function createFormat(size:uint):TextFormat 
		{
			var format:TextFormat = new TextFormat();
			format.size = size;
			format.font = "_ゴシック";
			format.bold = true;
			
			return format;
		}
		/**
		 * おいにー
		 */
		private function createPerfume(target:MovieClip):void 
		{
			var sprite:Sprite = new Sprite();
			sprite.graphics.beginFill(0x996600, 1);
			sprite.graphics.drawCircle(0, 0, 25);
			sprite.graphics.endFill();
			sprite.x = target.x;
			sprite.y = target.y - 30;
			sprite.filters = [_blur];
			addChild(sprite);
			var t:ITween = BetweenAS3.tween(sprite, { y:target.y - 70, alpha:0 }, null, 1 );
			t.addEventListener(TweenEvent.COMPLETE, function():void
			{
				t.removeEventListener(TweenEvent.COMPLETE, arguments.callee);
				removeChild(sprite);
			});
			t.play();
		}
	}
}