/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v9Bm
 */

// forked from kotobuki's Gainer Basic Example: LED
// 準備
// ・aout 0にLEDと抵抗器（330Ωなど）を接続する
// 
// 画面上のボタンを押すとI/Oモジュール上のLEDが点灯し、
// 同時にaout 0に接続したLEDがフェードインします。
// ボタンを離すとI/Oモジュール上のLEDが消灯し、同時に
// aout 0に接続したLEDもフェードアウトします。
// 
// 基本的なセットアップについては以下のURLを参照してください
// http://funnel.cc/Main/GettingStarted

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    
    import funnel.*;
    import funnel.gui.*;
    import funnel.ui.*;

    public class GainerBasic_LED extends Sprite {
        private var externalLED0:LED;
        private var externalLED1:LED;
        private var externalLED2:LED;
        private var externalLED3:LED;

        private var gio:Gainer;

        private var squareButton:Sprite;

        public function GainerBasic_LED() {
            gio = new Gainer();

            squareButton = new Sprite();
            squareButton.graphics.beginFill(0xFF0000);
            squareButton.graphics.drawRect(-25, -25, 50, 50);
            squareButton.graphics.endFill();
            squareButton.x = stage.stageWidth / 2;
            squareButton.y = stage.stageHeight / 2;
            squareButton.buttonMode = true;
            this.addChild(squareButton);

            var gui:GainerGUI = new GainerGUI();
            addChild(gui);
            gio.gui = gui;

            externalLED0 = new LED(gio.analogOutput(0));
            externalLED1 = new LED(gio.analogOutput(1));
            externalLED2 = new LED(gio.analogOutput(2));
            externalLED3 = new LED(gio.analogOutput(3));

            squareButton.addEventListener(MouseEvent.MOUSE_DOWN, mousePressed);
            squareButton.addEventListener(MouseEvent.MOUSE_UP, mouseReleased);
        }

        private function mousePressed(e:MouseEvent):void {
            gio.led.on();
            externalLED0.fadeIn(125);
            externalLED1.fadeIn(250);
            externalLED2.fadeIn(500);
            externalLED3.fadeIn(1000);
            squareButton.scaleX = 1.2;
            squareButton.scaleY = 1.2;
        }

        private function mouseReleased(e:MouseEvent):void {
            gio.led.off();
            externalLED0.fadeOut(1000);
            externalLED1.fadeOut(500);
            externalLED2.fadeOut(250);
            externalLED3.fadeOut(125);
            squareButton.scaleX = 1.0;
            squareButton.scaleY = 1.0;
        }
    }
}
