/**
 * Copyright nausicaa ( http://wonderfl.net/user/nausicaa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v9Ae
 */

package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var ball:Sprite=new BallSprite(0xff9933);
            ball.x = 50;
            ball.y = 50;
            addChild(ball);
            
            var moveBall:Sprite=new MoveBallSprite(0x000066);
            ball.x = 100;
            ball.y = 50;
            addChild(moveBall);
            
            var dropBall:Sprite=new DropBallSprite(0x006600);
            dropBall.x = 150;
            dropBall.y = 50;
            addChild(dropBall);
            
            var mouseTraceBall:Sprite=new MouseTraceBallSprite(0xff3300);
            mouseTraceBall.x = 200;
            mouseTraceBall.y = 50;
            addChild(mouseTraceBall);
            
        }
    }
}

import flash.display.*;
import flash.events.*;

class BallSprite extends Sprite{
	public function BallSprite(color:uint){
		super();
		
		graphics.beginFill(color);
		graphics.drawCircle(0,0,10);
		graphics.endFill();
	}
}
class MoveBallSprite extends BallSprite{
	public var velocityX:Number=8;
	public var velocityY:Number=6;	
	public function MoveBallSprite(color:uint){
		super(color);
		addEventListener(Event.ENTER_FRAME,updatePosition);
	}
	private function updatePosition(e:Event):void{
			x += velocityX;
			y += velocityY;
	}
}
class DropBallSprite extends MoveBallSprite{
	public var gravity:Number=0.6;
	public function DropBallSprite(color:uint){
	super(color);
		addEventListener(Event.ENTER_FRAME,updateVelocity);
	}
	private function updateVelocity(e:Event):void{
			velocityY += gravity;
	}
}
class MouseTraceBallSprite extends MoveBallSprite{
	public function MouseTraceBallSprite(color:uint){
		super(color);
		addEventListener(Event.ENTER_FRAME,updateVelocity);
	}
	private function updateVelocity(e:Event):void{
		velocityX = (root.mouseX-x)*0.1;
		velocityY = (root.mouseY-y)*0.1;
	}
}
