/**
 * Copyright Kihara ( http://wonderfl.net/user/Kihara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v8t8
 */

package
{
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;

    import org.papervision3d.core.geom.TriangleMesh3D;
    import org.papervision3d.core.math.Number3D;
    import org.papervision3d.core.math.Plane3D;
    import org.papervision3d.core.utils.MeshUtil;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.materials.special.CompositeMaterial;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.render.QuadrantRenderEngine;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.stats.StatsView;

    [SWF(frameRate="25", width=600, height=600)]
    public class mash_game2 extends Sprite
    {

        private const N:uint=80;
        private var str:String="abcdefghijklmnopqrstuvwxyz";
        private var word3d:Vector.<Text3d>=new Vector.<Text3d>;
        private var count:uint=0;
        private var vec_p:Vector.<Plane>=new Vector.<Plane>;

        private var kabe1:Vector.<Plane>=new Vector.<Plane>;
        private var kabe2:Vector.<Plane>=new Vector.<Plane>;
        private var kabe3:Vector.<Plane>=new Vector.<Plane>;
        private var kabe4:Vector.<Plane>=new Vector.<Plane>;
        private var kabe:Vector.<Vector.<Plane>>=Vector.<Vector.<Plane>>([kabe1, kabe2, kabe3, kabe4]);
        private var world:BasicView;
        private var world1:BasicView;
        private var world2:BasicView;
        private var sp:Sprite;
        private var balls:Vector.<Ball>=new Vector.<Ball>;


        private var w:Number=stage.stageWidth;
        private var h:Number=stage.stageHeight;

        public function mash_game2()
        {

            stage.scaleMode=StageScaleMode.NO_SCALE;
            stage.align=StageAlign.TOP_LEFT;

            sp=new Sprite();
            world=new BasicView(w, h, true, true);
            world1=new BasicView(w, h);
            world2=new BasicView(w, h);

            
            addChild(world1);
            addChild(world2);
            addChild(world);
            addChild(sp);
            init_world();
            init_text();

//            world.renderer=new QuadrantRenderEngine();
//            var stats:StatsView=new StatsView(world.renderer);
//            addChild(stats);

            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            world.startRendering();
            world1.startRendering();
            world2.startRendering();
        }

        public function init_text():void
        {
            var r:Number, n:int, ss:String, w:Text3d;
            var mat:ColorMaterial=new ColorMaterial(0x000000, 0);
            mat.interactive=true;
            world.camera.z=-1;

            for (var i:uint=0; i < N; i++)
            {
                r=Math.random() * 25;
                n=r;
                ss=str.charAt(n);
                w=new Text3d(ss, false);

                word3d.push(w);
                var p:Plane=new Plane(mat, 70, 70);

                p.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onClick);
                vec_p.push(p);
            }
        }

        public function init_world():void
        {
            var light:PointLight3D=new PointLight3D(false);
            light.x=0;
            light.y=0;
            light.z=-600;

            var kabe_kazu:uint=20;
            var z_inc:uint=150;
            var p:Plane, p2:Plane;
            var i:uint;
            var material:FlatShadeMaterial=new FlatShadeMaterial(light, 0x77EEEE, 0x224466);
            var material2:ColorMaterial=new ColorMaterial(0xFFFFFF, 0);

            var z:uint=0;
            for (i=0; i < kabe_kazu; i++)
            {
                p=new Plane(material, w / 2, h, 1, 1);
                p2=new Plane(material2, w / 2, h, 1, 1);
                kabe1.push(p);
                kabe1[i].z+=z - 600;
                kabe1[i].rotationY=-90;
                kabe1[i].x=-(w / 2);
                z+=z_inc;
                //world1.scene.addChild(kabe1[i]);
                world2.scene.addChild(kabe1[i]);
            }
            z=0;
            for (i=0; i < kabe_kazu; i++)
            {
                p=new Plane(material, w, h / 2, 1, 1);
                kabe2.push(p);
                kabe2[i].z+=z - 600;
                kabe2[i].rotationX=-90;
                kabe2[i].y=h / 2;
                z+=z_inc;
                //world1.scene.addChild(kabe2[i]);
                world2.scene.addChild(kabe2[i]);
            }
            z=0;
            for (i=0; i < kabe_kazu; i++)
            {
                p=new Plane(material, w / 2, h, 1, 1);
                kabe3.push(p);
                kabe3[i].z+=z - 600;
                kabe3[i].rotationY=90;
                kabe3[i].x=w / 2;
                z+=z_inc;
                //world1.scene.addChild(kabe3[i]);
                world2.scene.addChild(kabe3[i]);
            }
            z=0;
            for (i=0; i < kabe_kazu; i++)
            {
                p=new Plane(material, w, h / 2, 1, 1);
                kabe4.push(p);
                kabe4[i].z+=z - 600;
                kabe4[i].rotationX=90;
                kabe4[i].y=-(h / 2);
                z+=z_inc;
                //world1.scene.addChild(kabe4[i]);
                world2.scene.addChild(kabe4[i]);
            }

            //world2.blendMode=BlendMode.ADD;
            //var blur:BlurFilter=new BlurFilter(16, 16);
            //world2.filters=[blur];

        }

        public function onClick(e:InteractiveScene3DEvent):void
        {
            var id:int=int(Plane(e.currentTarget).extra);
            word3d[id].flag=false;
            for (var i:uint=0; i < 15; i++)
            {
                var ball:Ball=new Ball(word3d[id].word.x, word3d[id].word.y, word3d[i].word.z);
                sp.addChild(ball);
                balls.push(ball);
            }
        }

        public function searchWord():int
        {
            for (var i:uint=0; i < word3d.length; i++)
            {
                if (!word3d[i].flag)
                    return i;
            }
            return -1;
        }

        public function flagWord():void
        {
            var i:Number;
            if ((i=searchWord()) != -1)
            {
                word3d[i].word.x=Math.random() * 400 - 200;
                word3d[i].word.y=Math.random() * 400 - 200;
                word3d[i].word.z=2000;
                vec_p[i].x=word3d[i].word.x;
                vec_p[i].y=word3d[i].word.y - 15;
                vec_p[i].z=word3d[i].word.z - 1;

                word3d[i].flag=true;

                vec_p[i].extra=i;
                world.scene.addChild(vec_p[i]);
                world.scene.addChild(word3d[i].word);

            }
        }

        public function moveWord():void
        {
            for (var i:uint=0; i < word3d.length; i++)
            {
                if (word3d[i].flag)
                {
                    word3d[i].word.z-=10;
                    vec_p[i].z-=10;

                    if (word3d[i].word.z <= -10)
                    {
                        word3d[i].flag=false;
                        world.scene.removeChild(word3d[i].word);
                        world.scene.removeChild(vec_p[i]);

                    }
                }
                else if (!word3d[i].flag && word3d[i].z < 2000)
                {
                    world.scene.removeChild(word3d[i].word);
                    world.scene.removeChild(vec_p[i]);
                }
            }
        }

        public function move_kabe():void
        {
            for (var i:uint=0; i < 4; i++)
            {
                for (var j:uint=0; j < kabe1.length; j++)
                {
                    kabe[i][j].z-=10;
                    if (kabe[i][j].z < -750)
                    {
                        kabe[i][j].z=2250;
                    }

                }
            }
        }

        public function move_ball():void
        {
            for (var i:uint=0; i < balls.length; i++)
            {
                balls[i].move();
                if (balls[i].alpha < 0.06)
                {
                    sp.removeChild(balls[i]);
                    balls.splice(i--, 1);
                }
            }
        }

        public function onEnterFrame(e:Event):void
        {
            count++;
            if (count % 10 == 0)
                flagWord();
            moveWord();
            move_kabe();
            move_ball();
        }
    }
}


import flash.display.Sprite;

import org.papervision3d.materials.ColorMaterial;
import org.papervision3d.materials.special.Letter3DMaterial;
import org.papervision3d.typography.Text3D;
import org.papervision3d.typography.fonts.HelveticaBold;

class Text3d extends Sprite
{
    public var s:String;
    public var flag:Boolean;
    public var word:Text3D;

    public function Text3d(s:String, flag:Boolean)
    {
        this.s=s;
        this.flag=flag;
        var mat:Letter3DMaterial=new Letter3DMaterial(0x000000);
        var font:HelveticaBold=new HelveticaBold();
        mat.doubleSided=true;
        mat.interactive=true;
        word=new Text3D(s, font, mat);
    }

}

class Ball extends Sprite
{
    public var vx:Number=Math.random() * 20 - 10;
    public var vy:Number=-(20 + Math.random() * 20);
    public var vz:Number=Math.random() * 10 - 5;
    public var r:Number=Math.random() * 10;

    public function Ball(x:Number, y:Number, z:Number)
    {
        this.x=x+300;
        
        this.y=300-y;
        
        this.z=z-600;
        graphics.beginFill(0x000000);
        graphics.drawCircle(0, 0, r);
        graphics.endFill();
    }

    public function move():void
    {
        vy+=2;
        this.x+=vx;
        this.y+=vy;
        this.z+=vz;
        this.alpha-=0.01;
        if (vy >= 0 && this.y + r >= 600)
        {
            this.y = 600 - r;
            vy *= -0.8;
            
            this.alpha -= 0.01;
        }
        if (vy <= 0 && this.y + r <= 0)
        {
            this.y = r;
            vy *= -0.8;
            
            this.alpha -= 0.01;
        }


        if(vx >= 0&& this.x + r >=600){
            this.x = 600 - r;
            vx *= -0.8;
            
            this.alpha -= 0.01;
            
        }
        if(vx <= 0&& this.x + r <= 0){
            this.x = r;
            vx *= -0.8;
            
            this.alpha -= 0.05;
            
        }
    }

}
