/**
 * Copyright xzardaz ( http://wonderfl.net/user/xzardaz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v875
 */

/*

Basic View example in Away3d
 
Demonstrates:
 
How to create a 3D environment for your objects
How to add a new textured object to your world
How to rotate an object in your world

Code by Rob Bateman
rob@infiniteturtles.co.uk
http://www.infiniteturtles.co.uk

This code is distributed under the MIT License

Copyright (c)  

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the “Software”), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

*/
 //ok 
package
{
    
    import flash.net.URLRequest;
    import flash.system.Security;

    import away3d.containers.*;
    import away3d.entities.*;
    import away3d.materials.*;
    import away3d.primitives.*;
    import away3d.utils.*;
    import away3d.events.*;
    import away3d.core.pick.*;
    import away3d.textures.*; 
    import away3d.materials.methods.*;
    import away3d.lights.*;
    import away3d.materials.lightpickers.StaticLightPicker;     
        
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.system.LoaderContext;
    import flash.system.ApplicationDomain;
     
    import flash.display.*;
    import flash.events.*;
    import flash.geom.Vector3D;

    [SWF(backgroundColor="#000000", frameRate="60")]
    
    
    
    public class Basic_View extends Sprite
    {
        public var light1:DirectionalLight;
        public var bmpData:BitmapData;
        public var Mx:Number; 
        public var My:Number;
        
            public var loader:Loader;
        //plane texture
        //[Embed(source="../embeds/floor_diffuse.jpg")]
        public static var FloorDiffuse:Class;
        
        //engine variables
        private var _view:View3D;
        
        //scene objects
        private var _plane:Mesh;
        
        public var cubeTexture:BitmapCubeTexture;
        /**
         * Constructor
         */ 
        public function Basic_View()
        {
            Mx=stage.width/2;
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHndl);
            loader = new Loader();
            //trace(loader);
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE,completeHandler);
            //loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler); 
            //loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
            //loader.addEventListener(SecurityErrorEvent.SECURITY_ERROR , scError);
            Security.loadPolicyFile('http://api.facebook.com/crossdomain.xml');
            Security.allowDomain('http://http://wonderfl.net/');
            Security.allowInsecureDomain('http://http://wonderfl.net/');
            
            var request:URLRequest = new URLRequest("http://assets.wonderfl.net/images/related_images/d/d6/d6ac/d6ac1b471af71d05cd1531d9c4f7f5a7f040afbb");
            //loader.x = 80 * numChildren;,erContext(true));
            var context:LoaderContext = new LoaderContext();
            context.checkPolicyFile = true; 
            context.applicationDomain = ApplicationDomain.currentDomain;

            loader.load(request, context); 
            
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            //setup the view
            _view = new View3D();
            addChild(_view);
            
            _view.scene = new Scene3D;
            
            //setup the camera
            //_view.camera.z = -600;
            _view.camera.y = 500;
            _view.camera.lookAt(new Vector3D());
            
            //var 
            //setup the render loop
            addEventListener(Event.ENTER_FRAME, _onEnterFrame);
            stage.addEventListener(Event.RESIZE, onResize);
            onResize();
        }
        
        public function mouseMoveHndl(e:MouseEvent):void
        {
            //trace("a");
            //_view.camera.rotate(new Vector3D(0,1,0),(-Mx + e.localX)*6);
            //_view.camera.translate(new Vector3D(e.localX/10,0,0),(-Mx+e.localX)/100);  
            Mx=e.localX; 
        }

         
        private function completeHandler(event:Event):void {
            
            var loaderInfo:LoaderInfo = LoaderInfo(event.target);
            
            bmpData = new BitmapData(128, 128, true, 0x88000000); 
            
            try
            {
                bmpData.draw(loaderInfo.loader);
                //trace("okok");
            }
            catch( e : SecurityError )
            {                
                //wtrace(e);
            }
            //setup the scene 
            cubeTexture = new BitmapCubeTexture(Cast.bitmapData(bmpData), Cast.bitmapData(bmpData), Cast.bitmapData(bmpData), Cast.bitmapData(bmpData), Cast.bitmapData(bmpData), Cast.bitmapData(bmpData));  
            //_plane = new Mesh(new PlaneGeometry(700, 700), 
            //    new ColorMaterial(
            //            cubeTexture
            //            )
            // );
            //setup the environment map material
            light1 = new DirectionalLight();
            light1.direction = new Vector3D(0, -1, 0);
            light1.ambient = 0.1;
            light1.diffuse = 0.7;
            _view.scene.addChild(light1); 
            var lightPicker:StaticLightPicker = new StaticLightPicker([light1]);
             
            var material:TextureMaterial = new TextureMaterial(Cast.bitmapTexture(bmpData));
            //material.addMethod(new EnvMapMethod(cubeTexture, 0.2));
            //material.specularMap=Cast.bitmapTexture(bmpData);
            material.lightPicker=lightPicker; 
            _plane = new Mesh(new TorusGeometry(150, 60, 40, 20),
                material
             );
            _view.scene.addChild(_plane);
            var _skyBox:SkyBox = new SkyBox(cubeTexture);
            _view.scene.addChild(_skyBox);
        }
        
        /**
         * render loop
         */
        private function _onEnterFrame(e:Event):void
        {
            //if(_plane!=null)
                //_plane.rotationX += 1;
            
            
            _view.render();
        }
        
        /**
         * stage listener for resize events
         */
        private function onResize(event:Event = null):void
        {
            _view.width = stage.stageWidth;
            _view.height = stage.stageHeight;
        }
    }
}
