/**
 * Copyright yanbaka ( http://wonderfl.net/user/yanbaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v7aY
 */

// ドラッグで幽体離脱っぽくなります
package
{
	import flash.system.LoaderContext;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.Point;
	import flash.net.URLRequest;
	import flash.system.Security;
	
    [SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "30")]
	public class Obake extends Sprite
	{
		private static const IMAGE_PATH:String = "http://yanbaka.com/wonderfl/kote2.jpg";
		private const POINT_MARGIN:Number = 3;
		private const DEGREE:Number = 200000;
		
		private var _canvas:BitmapData;
		private var points:Array = [];
		private var drag:Boolean = false;
		
		public function Obake()
		{
			_canvas = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x0);
			var bmp:Bitmap = new Bitmap(_canvas);
			addChild(bmp);
			
			loadImage();
		}
		
		private function loadImage():void
		{
			Security.loadPolicyFile("http://5ivestar.org/proxy/crossdomain.xml");
			var context:LoaderContext = new LoaderContext(true);
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
			loader.load(new URLRequest("http://5ivestar.org/proxy/"+IMAGE_PATH), context);
		}
		
		private function onComplete(e:Event):void
		{
			var loader:Loader = Loader(e.target.loader);
			var bmd:BitmapData = Bitmap(loader.content).bitmapData;
			for (var i:int=0; i<bmd.width; i+=POINT_MARGIN)
			{
				for (var ii:int=0; ii<bmd.height; ii+=POINT_MARGIN)
				{
					pushPixel(bmd, i, ii);
				}
			}
			
			setInit();
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function mouseDownHandler(e:MouseEvent):void
		{
			drag = true;
		}
		
		private function mouseUpHandler(e:MouseEvent):void
		{
			drag = false;
		}
		
		private function loop(evt:Event):void
		{
			_canvas.lock();
			(drag)?_canvas.applyFilter(_canvas, _canvas.rect, new Point(), new BlurFilter()):_canvas.fillRect(_canvas.rect, 0x0);
			var dx:Number;
			var dy:Number;
			var dist:Number;
			var tx:Number;
			var ty:Number;
			var i:int = points.length;
			while (i--)
			{
				var p:Particle = points[i];
				dx = p.x - mouseX;
				dy = p.y - mouseY;
				dist = (dx*dx + dy*dy)/DEGREE;
				tx = dx * dist + p.x;
				ty = dy * dist + p.y;
				_canvas.setPixel32(tx, ty, p.c);
			}
			_canvas.unlock();
		}
		
		private function pushPixel(bmd:BitmapData, x:Number, y:Number):void
		{
			var p:Particle = new Particle();
			p.x = x;
			p.y = y;
			p.c = bmd.getPixel32(x, y);
			points.push(p);
		}
		
		private function setInit():void
		{
			var l:int = points.length;
			for (var i:int=0; i<l; i++)
			{
				var p:Particle = points[i];
				_canvas.setPixel32(p.x, p.y, p.c);
			}
		}
	}
}

class Particle
{
	public var x:Number;
	public var y:Number;
	public var c:uint;
	
	public function Particle() {}
}