/**
 * Copyright TmskSt ( http://wonderfl.net/user/TmskSt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v7Qi
 */

package {
	import alternativ5.engine3d.controllers.*;
	import alternativ5.engine3d.core.*;
	import alternativ5.engine3d.display.*;
	import alternativ5.types.*;
	import alternativ5.utils.*;
	import alternativ5.engine3d.materials.*;
	
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;

	[SWF(backgroundColor="#000000", frameRate="120")]
	public class Main extends Sprite {
	    
		private var scene:Scene3D;
		private var view:View;
		private var camera:Camera3D;
		private var cameraController:CameraController;
		
		private var geo:Mesh;
		

		public function Main() {
			this.addEventListener(Event.ADDED, init);
		}
		
		public function init(e:Event):void {
			this.removeEventListener(Event.ADDED, init);
			
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			scene = new Scene3D();
			scene.root = new Object3D();
			
			geo = scene.root.addChild(createMesh()) as Mesh;
			
			camera = new Camera3D();
			camera.x = 130;
			camera.y = -90;
			camera.z = 130;
			scene.root.addChild(camera);
			
			view = new View();
			addChild(view);
			view.camera = camera;
			
			cameraController = new CameraController(stage);
			cameraController.camera = camera;
			cameraController.lookAt(geo.coords);
			cameraController.setDefaultBindings();
			cameraController.checkCollisions = true;
			cameraController.collisionRadius = 20;
			cameraController.speed = 200;
			cameraController.controlsEnabled = true;
			
			FPS.init(stage);
			
			stage.addEventListener(Event.RESIZE, onResize);
			stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
			onResize(null);
		}

		private function onResize(e:Event):void {
			view.width = stage.stageWidth;
			view.height = stage.stageHeight;
		}
		
		private function onEnterFrame(e:Event):void {
			cameraController.processInput();
			scene.calculate();
		}
		
		private function createMesh():Mesh {
			var mesh:Mesh = new Mesh();

			/*
			 * 画面右の Mesh
			 */
			 //頂点を作成
			mesh.createVertex(0, 0, 0, "a1");
			mesh.createVertex(100, 0, 0, "a2");
			mesh.createVertex(100, 100, 0, "a3");
			mesh.createVertex(0, 100, 0, "a4");
			
			//Faceを作成
			mesh.createFace(["a1", "a2", "a3", "a4"], "geoFace");
			
			//Surfaceを作成
			mesh.createSurface(["geoFace"], "geo");
			
			//MaterialをSurfaceに投げる
			mesh.setMaterialToSurface(new FillMaterial(0xffffff), "geo");
			
			
			/*
			 * 画面左の Mesh
			 */
			mesh.createVertex(0, 0, 0, "b1");
			mesh.createVertex(-100, 0, 0, "b2");
			mesh.createVertex(-100, -100, 0, "b3");
			mesh.createVertex(0, -100, 0, "b4");
			
			mesh.createFace(["b1", "b2", "b3", "b4"], "geoFace2");
			
			mesh.createSurface(["geoFace2"], "geo2");
			
			mesh.setMaterialToSurface(new FillMaterial(0xffffff*Math.random()), "geo2");
			
			return mesh;
		}
	}
}