/**
 * Copyright goodbyegirl1974 ( http://wonderfl.net/user/goodbyegirl1974 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v7F0
 */

package {
    import flash.display.Sprite;
    import flash.display.DisplayObject;
    import flash.display.SimpleButton;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.text.AntiAliasType;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.Timer;
    [SWF(backgroundColor="#333333", frameRate="30")]
    public class GameOnMouse extends Sprite {
        private const SPEED_ACCEL_NUM:Number = 10.0;
        private const MIN_SPEED:Number = 0.05;
        
        private const ENEMY_MAX_SPEED:Number = 60.0;
        
        private const ENEMY_MAX_NUM:int = 50;
        
        private const INIT_HP_NUM:Number = 5.0;
        
        private var _mainChara:MovieClip;
        
        private var _enemyArray:Array = [];
        private var _force:Number = 1.0;
        
        private var _hp:Number = INIT_HP_NUM;
        
        private var _damageFlg:Boolean = true;
        
        private var _score:Number = 0.0;
        
        private var _enemyMakeTimer:Timer;
        
        private var _scoreField:TextField;
        private var _lifeField:TextField;
        
        private var _gameOverSprite:Sprite;
        
        private var _gameSprite:Sprite;
        private var _uiSprite:Sprite;
        
        private var _btnReplay:SimpleButton;
        public function GameOnMouse() {
            // write as3 code here..
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
private function init(e:Event = null):void 
        {
            var backgroundSprite:Sprite = new Sprite();
            backgroundSprite.graphics.beginFill(0x333333, 1.0);
            backgroundSprite.graphics.drawRect(0, 0, 800, 600);
            backgroundSprite.graphics.endFill();
            this.addChildAt(backgroundSprite, 0);
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            _gameSprite = new Sprite();
            _uiSprite = new Sprite();
            addChild(_gameSprite);
            addChild(_uiSprite);
            this._mainChara = new MainChara();
            _gameSprite.addChild(_mainChara);
            _mainChara.addEventListener("damageEnd", damageEndHandler);
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            _enemyMakeTimer = new Timer(500);
            _enemyMakeTimer.addEventListener(TimerEvent.TIMER, timerHandler);
            _enemyMakeTimer.start();
            
            _scoreField = new TextField();
            _lifeField = new TextField();
            
            _scoreField.autoSize = "left";
            _lifeField.autoSize = "left";
            _lifeField.text = "LIFE:" + String(_hp);
            
            _uiSprite.addChild(_scoreField);
            _scoreField.x = 20.0;
            _scoreField.y = 15.0;
            _scoreField.textColor = 0xffffff;
            _uiSprite.addChild(_lifeField);
            _lifeField.x = 20.0;
            _lifeField.y = 60.0;
            _lifeField.textColor = 0xffffff;
            _scoreField.antiAliasType = AntiAliasType.ADVANCED;
            _lifeField.antiAliasType = AntiAliasType.ADVANCED;
            
            var format:TextFormat = new TextFormat();
            format.size = 36;
            _scoreField.setTextFormat(format);
            _lifeField.setTextFormat(format);
            
            
            //ゲームオーバー時のSpriteの作成。
            _gameOverSprite = new Sprite();
            _gameOverSprite.graphics.beginFill(0x333333, 0.5);
            _gameOverSprite.graphics.drawRect(0, 0, 800, 600);
            _gameOverSprite.graphics.endFill();
            var btnSprite:Sprite = new Sprite();
            btnSprite.graphics.beginFill(0xffffff, 0.9);
            btnSprite.graphics.drawRect(-50, -10, 100, 20);
            btnSprite.graphics.endFill();
            var btnField:TextField = new TextField();
            btnField.autoSize = "center";
            btnField.text = "replay";
            btnSprite.addChild(btnField);
            btnField.x = -btnField.width / 2;
            btnField.y = -btnField.height / 2;
            _btnReplay = new SimpleButton(btnSprite, btnSprite, btnSprite, btnSprite);
            _btnReplay.enabled = true;
            _btnReplay.useHandCursor = true;
            _gameOverSprite.addChild(_btnReplay);
            _btnReplay.x = stage.stageWidth / 2;
            _btnReplay.y = stage.stageHeight / 2;
        }
        
        /**
         * 毎フレーム実行される処理。
         * @param    event
         */
        private function enterFrameHandler(event:Event):void
        {
            _score++;
            _scoreField.text = "SCORE:" + String(_score);
            _scoreField.antiAliasType = AntiAliasType.ADVANCED;
            var format:TextFormat = new TextFormat();
            format.size = 36;
            _scoreField.setTextFormat(format);
            var vx:Number = (this.mouseX - this._mainChara.x) / this.SPEED_ACCEL_NUM;
            var vy:Number = (this.mouseY - this._mainChara.y) / this.SPEED_ACCEL_NUM;
            if (vx > MIN_SPEED || vx < -MIN_SPEED)
                this._mainChara.x += vx;
            else
                this._mainChara.x = this.mouseX;
            if (vy > MIN_SPEED || vy < -MIN_SPEED)
                this._mainChara.y += vy;
            else
                this._mainChara.y = this.mouseY;
            
            if (_enemyArray.length == 0)
                return;
            var targetEnemy:EnemyObj;
            for (var i:int; i < _enemyArray.length; i++)
            {
                targetEnemy = _enemyArray[i];
                var dx:Number = _mainChara.x - targetEnemy.x;
                var dy:Number = _mainChara.y - targetEnemy.y;
                var angle:Number = Math.atan2(dy, dx);
                var ax:Number = Math.cos(angle) * _force;
                var ay:Number = Math.sin(angle) * _force;
                targetEnemy.vx += ax;
                targetEnemy.vy += ay;
                if (targetEnemy.vx > ENEMY_MAX_SPEED)
                    targetEnemy.vx = ENEMY_MAX_SPEED;
                else if (targetEnemy.vx < -ENEMY_MAX_SPEED)
                    targetEnemy.vx = -ENEMY_MAX_SPEED;
                if (targetEnemy.vy > ENEMY_MAX_SPEED)
                    targetEnemy.vy = ENEMY_MAX_SPEED;
                else if (targetEnemy.vy < -ENEMY_MAX_SPEED)
                    targetEnemy.vy = -ENEMY_MAX_SPEED;
                targetEnemy.rotation = angle * 180 / Math.PI;
                targetEnemy.x += targetEnemy.vx / 10;
                targetEnemy.y += targetEnemy.vy / 10;
                if (targetEnemy.x > this.stage.stageWidth)
                {
                    targetEnemy.x = this.stage.stageWidth;
                    targetEnemy.vx *= -1;
                }
                else if (targetEnemy.x < 0)
                {
                    targetEnemy.x = 0;
                    targetEnemy.vx *= -1;
                }
                if (targetEnemy.y > this.stage.stageHeight)
                {
                    targetEnemy.y = this.stage.stageHeight;
                    targetEnemy.vy *= -1;
                }
                else if (targetEnemy.y < 0)
                {
                    targetEnemy.y = 0;
                    targetEnemy.vy *= -1;
                }
                //以下、ヒットテスト
                if (targetEnemy.hitTestObject(_mainChara))
                {
                    if (_damageFlg)
                    {
                        _damageFlg = false;
                        _hp--;
                        _mainChara.damageHandler();
                        _lifeField.text = "LIFE:" + String(_hp);
                        _lifeField.antiAliasType = AntiAliasType.ADVANCED;
                        var targetFormat:TextFormat = new TextFormat();
                        targetFormat.size = 36;
                        _lifeField.setTextFormat(targetFormat);
                        if (_hp <= 0)
                        {
                            gameOverHandler();
                        }
                    }
                }
            }
        }
        
        private function timerHandler(event:TimerEvent):void
        {
            if (_enemyArray.length < this.ENEMY_MAX_NUM)
            {
                var enemy:EnemyObj = new EnemyObj();
                _gameSprite.addChild(enemy);
                enemy.x = Math.random() * this.stage.stageWidth;
                enemy.y = Math.random() * this.stage.stageHeight;
                _enemyArray.push(enemy);
                enemy.vx = 0;
                enemy.vy = 0;
            }
        }
        
        private function damageEndHandler(event:Event):void
        {
            _damageFlg = true;
        }
        
        private function gameOverHandler():void
        {
            _mainChara.removeEventListener("damageEnd", damageEndHandler);
            removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
            _enemyMakeTimer.removeEventListener(TimerEvent.TIMER, timerHandler);
            _enemyMakeTimer.stop();
            showGameOverSprite();
        }
        
        private function showGameOverSprite():void
        {
            stage.addChild(_gameOverSprite);
            _btnReplay.addEventListener(MouseEvent.CLICK, btnReplayClickHandler);
        }
        
        private function btnReplayClickHandler(e:MouseEvent):void 
        {
            _btnReplay.removeEventListener(MouseEvent.CLICK, btnReplayClickHandler);
            stage.removeChild(_gameOverSprite);
            restartGame();
        }
        
        private function restartGame():void 
        {
            var i:int = 0;
            var maxNum:int = _gameSprite.numChildren;
            for (i; i < maxNum; i++)
            {
                _gameSprite.removeChildAt(0);
            }
            _hp = INIT_HP_NUM;
            _lifeField.text = "LIFE:" + String(_hp);
            _score = 0;
            _scoreField.text = "SCORE:" + String(_score);
            _damageFlg = true;
            _enemyArray = [];
            _gameSprite.addChild(_mainChara);
            _mainChara.addEventListener("damageEnd", damageEndHandler);
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            _enemyMakeTimer.addEventListener(TimerEvent.TIMER, timerHandler);
            _enemyMakeTimer.start();
            var format:TextFormat = new TextFormat();
            format.size = 36;
            _lifeField.setTextFormat(format);
            _scoreField.setTextFormat(format);
        }
    }
}

import flash.display.MovieClip
import flash.events.Event;
import flash.display.Sprite
import flash.utils.Timer;
import flash.events.TimerEvent;
class MainChara extends MovieClip
{
    private var _whiteSprite:Sprite;
    private var _redSprite:Sprite;
    
    /**
     * コンストラクタ。
     */
    public function MainChara()
    {
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    private function init(e:Event = null):void 
    {
        _whiteSprite = new Sprite();
        addChild(_whiteSprite);
        _redSprite = new Sprite();
        addChild(_redSprite);
        _whiteSprite.graphics.beginFill(0xffffff);
        _whiteSprite.graphics.drawCircle(0, 0, 8);
        _whiteSprite.graphics.endFill();
        _redSprite.graphics.beginFill(0xff0000);
        _redSprite.graphics.drawCircle(0, 0, 8);
        _redSprite.graphics.endFill();
        _whiteSprite.visible = true;
        _redSprite.visible = false;
    }
    
    public function damageHandler():void
    {
        if (!_redSprite.visible)
            _redSprite.visible = true;
        if (_redSprite.alpha != 1.0)
            _redSprite.alpha = 1.0;
        if (!hasEventListener(Event.ENTER_FRAME))
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
    }
    
    private function enterFrameHandler(event:Event):void
    {
        if (_redSprite.alpha > 0)
        {
            _redSprite.alpha -= 0.05;
        }
        else
        {
            removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
            _redSprite.alpha = 1.0;
            _redSprite.visible = false;
            dispatchEvent(new Event("damageEnd"));
        }
    }
}

class EnemyObj extends MovieClip
{
    /**
     * コンストラクタ。
     */
    private var _vx:Number;
    private var _vy:Number;
    
    public function EnemyObj()
    {
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    private function init(e:Event = null):void 
    {
        this.graphics.beginFill(0xffffff);
        this.graphics.moveTo( -6.0, -3.0);
        this.graphics.lineTo( 6.0, 0.0);
        this.graphics.lineTo( -6.0, 3.0);
        this.graphics.lineTo( -6.0, -3.0);
        this.graphics.endFill();
    }
    
    public function get vx():Number 
    {
        return _vx;
    }
    
    public function set vx(value:Number):void 
    {
        _vx = value;
    }
    
    public function get vy():Number 
    {
        return _vy;
    }
    
    public function set vy(value:Number):void 
    {
        _vy = value;
    }
}