/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v7EC
 */

package
{
	import Box2D.Dynamics.b2Body;
	import Box2D.Dynamics.b2BodyDef;
	import flash.display.Sprite;
	import flash.events.Event;
	import Box2D.Collision.b2AABB;
	import Box2D.Collision.Shapes.b2CircleDef;
	import Box2D.Collision.Shapes.b2PolygonDef;
	import Box2D.Common.Math.b2Vec2;
	import Box2D.Dynamics.b2DebugDraw;
	import Box2D.Dynamics.b2World;
 
	[SWF(backgroundColor="0x414647")]
	public class Main extends Sprite
	{
		private var world:b2World;
 
		public function Main()
		{
			var worldAABB:b2AABB = new b2AABB();
			worldAABB.lowerBound.Set(-100, -100);
			worldAABB.upperBound.Set(stage.stageWidth + 100, stage.stageHeight + 100);
 
			var gravity:b2Vec2 = new b2Vec2(0, 100);
			world = new b2World(worldAABB, gravity, true);
 
			var draw:b2DebugDraw = new b2DebugDraw();
			draw.m_sprite = this;
			draw.m_drawScale = 1;
			draw.m_drawFlags = b2DebugDraw.e_shapeBit;
			world.SetDebugDraw(draw);
			
			var floorDef:b2BodyDef = new b2BodyDef();
			floorDef.position.Set(stage.stageWidth / 2, stage.stageHeight / 2);
			
			var floorShape:b2PolygonDef = new b2PolygonDef();
			floorShape.SetAsBox(100, 10);
			
			var floorBody:b2Body = world.CreateBody(floorDef);
			floorBody.CreateShape(floorShape);
			

			var circleDef:b2BodyDef = new b2BodyDef();
			circleDef.position.Set(stage.stageWidth / 2, 0);

			var circleShape:b2CircleDef = new b2CircleDef();
			circleShape.radius = 10;
			circleShape.density = 100;
			circleShape.restitution = 0.7;

			var circleBody:b2Body = world.CreateBody(circleDef);
			circleBody.CreateShape(circleShape);
			circleBody.SetMassFromShapes();
 
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
 
		private function onEnterFrame(event:Event):void 
		{
			world.Step(1 / stage.frameRate, 10);
		}
	}
}
