/**
 * Copyright freddy ( http://wonderfl.net/user/freddy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v79z
 */

// forked from freddy's db97531 wide
// forked from freddy's db97531
package {
    import flash.events.Event;
    import flash.display.Sprite;
    
    public class Main extends Sprite {
        public function Main() {
            var juggler:Juggler;
            var w:Number = 3;
            juggler = new Juggler([13, 11, 9, 7, 5, 3, 1], 
            [[-60 * w, 0], [-50 * w, 0], [-40 * w, 0], [-30 * w, 0], [-20 * w, 0], [-10 * w, 0], [0 * w, 0]],
            [[0 * w, 0], [10 * w, 0], [20 * w, 0], [30 * w, 0], [40 * w, 0], [50 * w, 0], [60 * w, 0]], 8);
            juggler.x -= 100;
            addChild(juggler);
            juggler = new Juggler([13, 11, 9, 7, 5, 3, 1], 
            [[-60 * w, 0], [50 * w, 0], [-40 * w, 0], [30 * w, 0], [-20 * w, 0], [10 * w, 0], [0 * w, 0]],
            [[0 * w, 0], [-10 * w, 0], [20 * w, 0], [-30 * w, 0], [40 * w, 0], [-50 * w, 0], [60 * w, 0]], 8);
            juggler.x += 100;
            addChild(juggler);
        }

    }

}

import flash.display.Sprite;
import flash.events.Event;

class Juggler extends Sprite {

    private var _siteswap:Array;
    private var _throwpos:Array;
    private var _catchpos:Array;
    private var _index:int = 0;
    private var _frame:int = 0;
    private var _beat:int = 8;
    private var _queue:Array = [];
    
    public function Juggler(siteswap:Array, throwpos:Array, catchpos:Array, beat:int) {
        // write as3 code here..
        _siteswap = siteswap;
        _throwpos = throwpos;
        _catchpos = catchpos;
        _beat = beat;
        addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        x = 240;
        y = 430;
        scaleX = scaleY = 0.3;
    }
    public function enterFrameHandler(event:Event):void {
        _frame++;
        if (_frame == _beat) {
            _frame = 0;
            var s:int = _siteswap[_index % _siteswap.length];
            var tp0:Array = _throwpos[_index % _throwpos.length];
            var cpS:Array = _catchpos[(_index + s) % _catchpos.length];
            var tpS:Array = _throwpos[(_index + s) % _throwpos.length];
            _index++;
            
            var air:Number = (s == 1 ? 0.5 : s - 1) * _beat;
            var ball:Ball;
            if (_queue.length == 0) {
                ball = new Ball();
                ball.addEventListener(Event.COMPLETE, function (event:Event):void {
                    _queue.push(ball);
                });
                addChild(ball);
            } else {
                ball = _queue.shift();
            }
            var orbit:Function = createJoinOrbit(
                createFallOrbit(tp0[0], 0, cpS[0], 0, 1, air),
                createFallOrbit(cpS[0], 0, tpS[0], 0, -4, s * _beat - air),
                air);
            ball.reset(orbit, s * _beat - 1);


        }

    }
    
    public function createFallOrbit(ax:Number, ay:Number, bx:Number, by:Number, g:Number, tab:Number):Function {
        var vy:Number = by / tab - ay / tab - 0.5 * g * tab;
        return function(t:Number):Object {
            return {
                x: ax * (1 - t / tab) + bx * t / tab,
                y: ay + vy * t + 0.5 * g * t * t
            };
        }
    }
    
    public function createJoinOrbit(a:Function, b:Function, tb:Number):Function {
        return function(t:Number):Object {
            return t < tb ? a(t) : b(t - tb);
        };
    }
}

class Ball extends Sprite {
    private var _orbit:Function;
    private var _frame:int = 0;
    private var _life:int = 0;
    
    public function Ball() {
        graphics.beginFill(Math.random() * 0xffffff);
        graphics.drawCircle(0, 0, 15);
        graphics.endFill();
        addEventListener(Event.ENTER_FRAME, function(event:Event):void {
            _frame++;
            var p:Object = _orbit(_frame);
            x = p.x;
            y = p.y;
            if (_frame == _life) {
                dispatchEvent(new Event(Event.COMPLETE));
            }
        });
        super();
    }
    
    public function reset(orbit:Function, life:int):void {
        _orbit = orbit;
        _frame = 0;
        _life = life;
        var p:Object = _orbit(_frame);
        x = p.x;
        y = p.y;
    }


}


