/**
 * Copyright ebrakadabra ( http://wonderfl.net/user/ebrakadabra )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v776
 */

// forked from alumican_net's Test
package {
    import com.bit101.components.*;
    import flash.events.*;
    import flash.display.*;
    
    public class Test extends Sprite {
        
        private var _container:Sprite;
        private var _cameraLengthSlider:HUISlider;
        private var _targetRadiusSlider:HUISlider;
        private var _ringRadiusSlider:HUISlider;
        
        public function Test():void {
            stage.align = "TL";
            stage.scaleMode = "noScale";
            stage.addEventListener(Event.RESIZE, _resizeHandler);
            
            _container = new Sprite();
            addChild(_container);
            
            _cameraLengthSlider = new HUISlider(this, 0, 0, "Camera", _reset);
            _cameraLengthSlider.setSliderParams(1, 20, 3);
            _cameraLengthSlider.labelPrecision = 0;
            
            _targetRadiusSlider = new HUISlider(this, 0, 20, "Target", _reset);
            _targetRadiusSlider.setSliderParams(10, 100, 50);
            _targetRadiusSlider.labelPrecision = 0;
            
            _ringRadiusSlider = new HUISlider(this, 0, 40, "Ring", _reset);
            _ringRadiusSlider.setSliderParams(100, 300, 180);
            _ringRadiusSlider.labelPrecision = 0;
            
            _resizeHandler();
            _reset();
        }
        
        private function _resizeHandler(e:Event = null):void {
            _container.x = stage.stageWidth / 2;
            _container.y = stage.stageHeight / 2;
        }

        private function _reset(...args):void {
            var targetRadius:Number = _targetRadiusSlider.value;
            var cameraRadius:Number = _ringRadiusSlider.value;
            var cameraLength:int = _cameraLengthSlider.value;
            
            var g:Graphics = _container.graphics;
            g.clear();
            
            //Ring
            g.lineStyle(1, 0x666666);
            g.drawCircle(0, 0, cameraRadius);
            g.lineStyle();
            
            //Camera
            for (var i:int = 0; i < cameraLength; ++i) {
                var cameraAngle:Number = i / cameraLength * Math.PI * 2 - Math.PI / 2;
                var cameraX:Number = cameraRadius * Math.cos(cameraAngle);
                var cameraY:Number = cameraRadius * Math.sin(cameraAngle);
                var cameraDist2:Number = cameraX * cameraX + cameraY * cameraY;
                var sqrt:Number = Math.sqrt(cameraDist2 - targetRadius * targetRadius);
                var edgeX0:Number = targetRadius * (cameraX * targetRadius + cameraY * sqrt) / cameraDist2;
                var edgeY0:Number = targetRadius * (cameraY * targetRadius - cameraX * sqrt) / cameraDist2;
                var edgeX1:Number = targetRadius * (cameraX * targetRadius - cameraY * sqrt) / cameraDist2;
                var edgeY1:Number = targetRadius * (cameraY * targetRadius + cameraX * sqrt) / cameraDist2;
                g.beginFill(0xff0000, 0.3);
                g.moveTo(cameraX, cameraY);
                g.lineTo(edgeX0, edgeY0);
                g.lineTo(edgeX1, edgeY1);
                g.lineTo(cameraX, cameraY);
                g.endFill();
                _fillCircle(g, cameraX, cameraY, 10, 0x00ff00);
            }
            
            //Target
            _fillCircle(g, 0, 0, targetRadius, 0x0000ff);
        }
        
        private function _fillCircle(g:Graphics, x:Number, y:Number, radius:Number, color:uint):void {
            g.beginFill(color);
            g.drawCircle(x, y, radius);
            g.endFill();
        }
    }
}