/**
 * Copyright majoraze ( http://wonderfl.net/user/majoraze )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v5ub
 */

// forked from majoraze's acceleration basic
// forked from majoraze's flash on 2010-11-21
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    
    public class Velocity extends Sprite {
        private var arrow:Arrow;
        private var vx:Number = 0;
        private var vy:Number = 0;
        private var force:Number = .5;
        
        public function Velocity() {
            init();
        }
        
        private function init():void {
            arrow = new Arrow();
            addChild(arrow);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        
        private function onEnterFrame(e:Event):void {
            var dx:Number = mouseX - arrow.x;
            var dy:Number = mouseY - arrow.y;
            var angle:Number = Math.atan2(dy,dx);
            arrow.rotation = angle * 180/Math.PI;
            
            var ax:Number = Math.cos(angle) * force;
            var ay:Number = Math.sin(angle) * force;
            vx += ax;
            vy += ay;
            arrow.x += vx;
            arrow.y += vy;
            
        }
    }
}


import flash.display.Sprite;
class Arrow extends Sprite {
    public function Arrow() {
        init();
    }
    
    public function init():void {
        graphics.lineStyle(1,0,1);
        graphics.beginFill(0xff0000);
        graphics.moveTo(-50,-25);
        graphics.lineTo(0,-25);
        graphics.lineTo(0,-50);
        graphics.lineTo(50,0);
        graphics.lineTo(0,50);
        graphics.lineTo(0,25);
        graphics.lineTo(-50,25);
        graphics.lineTo(-50,-25);
        graphics.endFill();
    }


}
