/**
 * Copyright phenix.pink ( http://wonderfl.net/user/phenix.pink )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v5ep
 */

// forked from http://wonderfl.net/c/rMR1
package {

    import alternativ5.engine3d.materials.*;
    import alternativ5.engine3d.primitives.*;
    import alternativ5.engine3d.core.*;
    import alternativ5.types.Texture;
    import alternativ5.types.Point3D;
    import alternativ5.utils.*

    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;

    
    [SWF(width = 600, height = 600, frameRate = 30, backgroundColor=0xFFFFFF)]

    public class SimpleDemo extends Sprite {

        public function SimpleDemo():void {

            var template:BasicTemplate = new BasicTemplate();
            addChild(template);

            FPS.init(stage); 

                var materialA:DevMaterial = new DevMaterial(); 


                var box:Object3D = new Object3D; 
   
                
                var i:uint; 
                for (i=0;i<1000;i++) {
                    var temp:Particle=new Particle(box,1)
                }
             template.scene.root.addChild(box); 

            var angle:uint=0


            template.onPreRender = function():void {
            
              box.rotationY += 3 * Math.PI / 180;

                var rateY:Number = mouseY / stage.stageHeight;
                  var rateX:Number = mouseX / stage.stageHeight;

                template.camera.y += ( - 200 * rateY - template.camera.y) * 0.5 + 1;
                template.camera.x += ( - 200 * rateX - template.camera.x) * 0.5;
                template.camera.z = Math.sqrt( template.camera.x * template.camera.x + template.camera.y * template.camera.y);
                template.cameraContoller.lookAt(new Point3D()); 
                
            }
        }
    }
}


import alternativ5.engine3d.materials.*;
import alternativ5.engine3d.primitives.*;
import alternativ5.engine3d.core.Sprite3D;
import alternativ5.types.Texture;
import alternativ5.types.Point3D;

import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.Matrix
import flash.filters.BlurFilter;
import flash.filters.BitmapFilterQuality;

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.filters.BlurFilter;
import flash.filters.GlowFilter;
class Particle {
    public function Particle(scene:Object3D,size:Number) {

        //-----------------------------------------------
        //-----------------------------------------------
                var xn:Number;
                var yn:Number;
                var zn:Number;
                var norm:Number;
                var c1:Number;
                var c2:Number;
                var c3:Number;
                var c4:Number;
                var color:uint;
                
           
                 xn = Math.random() * 600 - 200;
                    yn = Math.random() * 600 - 200;
                    zn = Math.random() * 600 - 200;
                    norm = Math.sqrt(xn * xn + yn * yn + zn * zn);
                    c1 = (1 - norm / 200) * 255;
                    c2 = (1 - norm / 250) * 255;
                    c3 = Math.abs(xn) / norm * 255;
                    c4 = Math.abs(yn) / norm * 255;
                    color =  (c1 << 24 | c2 << 16 | c3 << 8 | c4);
                    
            var tempSprite:Sprite = new Sprite()
var bmd:BitmapData = new BitmapData(5, 5, true, 0x00000000);
          bmd.setPixel32(2, 2, color);
     var rect:Rectangle = new Rectangle(0, 0, 5, 5);
    var pt:Point = new Point(0, 0);
var filter:GlowFilter = new GlowFilter(); 
filter.color = color;
filter.blurX =2;
filter.blurY = 2;
bmd.applyFilter(bmd, rect, pt, filter);

          

            var mtr:Matrix=new Matrix();
            mtr.translate(tempSprite.width, tempSprite.height)
            bmd.draw(tempSprite,mtr)
            var material:SpriteTextureMaterial = new SpriteTextureMaterial(new Texture(bmd),1,true);


            var sp:Sprite3D = new Sprite3D();
            sp.material=material;

 
            scene.addChild(sp);

            sp.x=xn;
            sp.y=yn;
            sp.z=zn;

    }
}



import alternativ5.engine3d.controllers.CameraController;
import alternativ5.engine3d.core.Camera3D;
import alternativ5.engine3d.core.Object3D;
import alternativ5.engine3d.core.Scene3D;
import alternativ5.engine3d.display.View;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;
import flash.events.Event;
class BasicTemplate extends Sprite{
    public var scene:Scene3D;
    public var view:View;
    public var camera:Camera3D;
    public var cameraContoller:CameraController;
    
    private var _viewWidth:int;
    private var _viewHeight:int;
    private var _scaleToStage:Boolean;

    public function BasicTemplate(viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true) {
        _viewWidth = viewWidth;
        _viewHeight = viewHeight;
        _scaleToStage = scaleToStage;
        
        // Creating scene
        scene = new Scene3D();
        scene.splitAnalysis = false; // not analysis for performance
        scene.root = new Object3D();
        
        // Adding camera
        camera = new Camera3D();
        camera.z = -1000;
        scene.root.addChild(camera);
        
        // camera contoller
        cameraContoller = new CameraController(this);
        cameraContoller.camera = camera;
        
        // set view
        view = new View();
        view.camera = camera;
        addChild(view);
        
        // stage
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    protected function atInit():void {}
    
    private var _onInit:Function = function():void { };
    public function get onInit():Function { return _onInit; }
    public function set onInit(value:Function):void {
        _onInit = value;
    }
    
    protected function atPreRender():void {}
    
    private var _onPreRender:Function = function():void{};
    public function get onPreRender():Function { return _onPreRender; }
    public function set onPreRender(value:Function):void {
        _onPreRender = value;
    }
    
    protected function atPostRender():void {
    }
    
    protected var _onPostRender:Function = function():void{};
    public function get onPostRender():Function { return _onPostRender; }
    public function set onPostRender(value:Function):void {
        _onPostRender = value;
    }
    
    public function startRendering():void {
        addEventListener(Event.ENTER_FRAME, onRenderTick);
    }

    public function stopRendering():void {
        removeEventListener(Event.ENTER_FRAME, onRenderTick);
    }
    
    public function singleRender():void {
        onRenderTick();
    }
    
    private function init(e:Event = null):void {
        stage.scaleMode = StageScaleMode.NO_SCALE;
        stage.align = StageAlign.TOP_LEFT;
        stage.quality = StageQuality.HIGH;

        stage.addEventListener(Event.RESIZE, onResize);
        onResize(null);
        
        startRendering();
        
        atInit();
        _onInit();
        
    }
    
    private function onRenderTick(e:Event = null):void {
        atPreRender();
        _onPreRender();
        scene.calculate();
        atPostRender();
        _onPostRender();
    }
    
    private function onResize(event:Event = null):void {
        if (_scaleToStage) {
            view.width = stage.stageWidth;
            view.height = stage.stageHeight;
        }else {
            view.width = _viewWidth;
            view.height = _viewHeight;
        }
    }
}
