/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v54t
 */

/*
 *　座標を頼りに、面の角度を算出する
 * ProjectVectorsを使わずに3Dオブジェクトを作るための検証
 */

package {
    import flash.display.Sprite;
    import flash.geom.Vector3D;
    import flash.events.Event;

    public class Main extends Sprite {
		private var canvas:Sprite;
		private const separateNum:Number = 12;	// 分割数
		private const radius:Number = 150;		// 球の半径

        public function Main():void {
			canvas = new Sprite();
			canvas.x = stage.stageWidth/2;
			canvas.y = stage.stageHeight/2;
			addChild(canvas);
			
			for (var v:int = 0; v <= separateNum; v++) {
				
					var ny     :Number = Math.cos( v * Math.PI/separateNum ) * radius;
					var vRadius:Number = Math.sin( v * Math.PI/separateNum ) * radius;
				
					for (var h:int = 0; h < separateNum; h++) {
						
						var panel:Panel = new Panel();
						canvas.addChild(panel);
						var nx:Number = Math.cos(h * Math.PI*2 / separateNum) * vRadius;
						var nz:Number = Math.sin(h * Math.PI*2 / separateNum) * vRadius;
						panel.x = nx;
						panel.y = ny;
						panel.z = nz;
						
						// 座標を法線と見立てる（ここからが本題）=================================
						var normal:Vector3D = new Vector3D(nx,ny,nz);
						normal.normalize();
						
						// 法線だけを頼りに、circle（sprite）の傾きを求める
						// （先に求めた角度から算出できるが、あくまでも法線（座標）だけから求める）
						// rotationY-----------------------------
						// x座標とz座標からrotationY値を求める
						panel.rotationY  = Math.atan2(normal.x, normal.z)/Math.PI * 180;
						// rotationX-----------------------------
						// x座標とz座標によりY軸からの距離(dist)を求める
						var dist:Number = Math.sqrt(Math.pow(normal.x,2) + Math.pow(normal.z,2));
						// distとY座標からrotationX値を求める
						panel.rotationX = Math.atan2(dist, normal.y)/Math.PI*180 + 90;
						// ==============================================================
					}
			}
			addEventListener(Event.ENTER_FRAME, xRotate);
        }
		
		public function xRotate(e:Event):void {
			canvas.rotationY += 1;
			canvas.rotationX += 0.5;
		}
    }
}
import flash.display.Shape;
class Panel extends Shape{
	public function Panel():void {
		graphics.beginFill(0x00ff66, 0.4);
		graphics.drawRect(-10,-10, 20,10);
		graphics.endFill();
		graphics.beginFill(0x00ccff, 0.4);
		graphics.drawRect(-10,0, 20,10);
		graphics.endFill();
	}
}