/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v4XA
 */

package {
    import com.adobe.serialization.json.JSON;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            addChild(getLoggerField());
            
            var response:Response = newFromJSON(TEST_JSON, Response);
            
            log(JSON.encode(response));
        }
    }
}

class Entry {
    public var id:int;
    public var name:String;
    public var score:int;
}

class Response {
    public var page:int;
    public var max_page:int;
    // entries is an array of instances
    [Transient]
    public var entries_factory:Class = Entry;
    public var entries:Array;
}

import flash.text.TextField;
(function ():void {
    var tf:TextField = new TextField;
    tf.width = tf.height = 465;
    tf.wordWrap = true;
    this.logger = tf;
})();

function log(...o:Array):void {
    this.logger.appendText((o ? o.join(' ') : '') + "\n");
}
function getLoggerField():TextField {
    return this.logger;
}

import com.adobe.serialization.json.JSON;
function newFromJSON(jsonStr:String, classRef:Class):* {
    return copyProperties(JSON.decode(jsonStr), new classRef);
}

function copyProperties(src:Object, dst:Object):Object {
    for (var key:String in src) {
        var value:Object = src[key];
        var obj:*;
        
        switch (typeof value) {
        case "boolean":
        case "number":
        case "string":
            if (key in dst) {
                dst[key] = value;
            }
            break;
        default:
            var classRef:Class;
            var factory:String = key + "_factory";
            if (factory in dst) {
                classRef = dst[factory];
            }
            //log('classRef:', classRef);
            if (value is Array) {
                var arr:Array;
                if (classRef != null) {
                    var len:int = value.length;
                    arr = [];
                    for (var i:int = 0; i < len; ++i) {
                        arr[i] = copyProperties(value[i], new classRef);
                    }
                } else {
                    arr = value as Array;
                }
                dst[key] = arr;
            } else {
                if (classRef != null) {
                    obj = copyProperties(value, new classRef);
                } else {
                    obj = value;
                }
                dst[key] = obj;
            }
            break;
        }
    }
    
    return dst;
}

const TEST_JSON:String = <><![CDATA[
{
    "page" : 1,
    "max_page" : 3,
    "entries" : [
        {
            "id" : 1,
            "name" : "A",
            "score" : 300
        },
        {
            "id" : 2,
            "name" : "B",
            "score" : 290
        },
        {
            "id" : 3,
            "name" : "C",
            "score" : 280
        },
        {
            "id" : 4,
            "name" : "D",
            "score" : 270
        }
    ]
}
]]></>;

