/**
 * Copyright ElvisQuaintArts ( http://wonderfl.net/user/ElvisQuaintArts )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v4PL
 */

/**
 * Created by IntelliJ IDEA.
 * User: Happy
 * Date: 11-5-9
 * Time: 上午2:29
 * To change this template use File | Settings | File Templates.
 */
package {
import alternativ7.engine3d.containers.ConflictContainer;
import alternativ7.engine3d.controllers.SimpleObjectController;
import alternativ7.engine3d.core.Camera3D;
import alternativ7.engine3d.core.Object3DContainer;
import alternativ7.engine3d.core.Vertex;
import alternativ7.engine3d.core.View;
import alternativ7.engine3d.materials.TextureMaterial;
import alternativ7.engine3d.objects.Mesh;
import alternativ7.engine3d.objects.Sprite3D;
import alternativ7.engine3d.primitives.Box;
import alternativ7.engine3d.primitives.Sphere;

import com.greensock.TimelineMax;
import com.greensock.TweenLite;
import com.greensock.easing.Expo;
import com.greensock.easing.Bounce;

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Loader;
import flash.display.Sprite;
import flash.events.Event;
import flash.filters.BlurFilter;
import flash.net.URLRequest;

[SWF(width=600,height=400,frameRate=90,backgroundColor=0x000000)]
public class DepthOfFeild2 extends Sprite {

//    [Embed (source="/sphere.png")]
//    private static const SphereTexture:Class;
    private static const FOCUS_POSITION:int = 1200;
    private static const MAX_NUM:int = 150;
    private static const SNOW_MAX_DEPTH:int = 24;
    private var camera:Camera3D;
    private var _blurs:Vector.<TextureMaterial>;
    private var _particles:Vector.<Sprite3D>;
    protected var _targetVertexs:Vector.<Vertex>;

    public function DepthOfFeild2() {
        initWorld();
        initResource();
        initObjs();
        addEventListener(Event.ENTER_FRAME, onEventFrameHandler);
    }

    private function initResource():void {
        //init texture resource //////////////////////////////////
        var imageLoader:Loader = new Loader();
        var image:URLRequest = new URLRequest("http://assets.wonderfl.net/images/related_images/0/05/0577/05777317b05c43a2aa44e3c2e13d71b01d561497");
        imageLoader.load(image);
        var bmd:BitmapData = new BitmapData(100, 100);
        bmd.draw(imageLoader);
        _blurs = new Vector.<TextureMaterial>(SNOW_MAX_DEPTH, true);
        for (var i:uint = 0; i < SNOW_MAX_DEPTH; i++) {
            var sp:Sprite = new Sprite();
            sp.addChild(new Bitmap(bmd));
            var blurFilter:BlurFilter = new BlurFilter(i, i, 4);
            //add blurFilter, blurFilter is an array
            sp.filters = [blurFilter];
            var bitmapDate:BitmapData = new BitmapData(100, 100, true, 0);
            bitmapDate.draw(sp);
            _blurs[i] = new TextureMaterial(bitmapDate);
        }
        //init geometry resource //////////////////////////////////
        //create transform Matrix
        var vertexts:Array = [];
        //Sphere
        var d:Mesh = new Sphere(700, 13, 12);
        vertexts[0] = d.vertices;
        //Cube
        d = new Box(1000, 1000, 1000, 5, 5, 5);
        vertexts[1] = d.vertices;
        //random
        d = new Mesh();
        for (i = 0; i < MAX_NUM; i++) {
            d.addVertex((Math.random() - 0.5 ) * 1000, (Math.random() - 0.5) * 1000, (Math.random() - 0.5 ) * 1000);
        }
        vertexts[2] = d.vertices;
        // floor
        var _d:Mesh = Mesh(d.clone());
        for (i = 0; i < MAX_NUM; i++) {
            _d.vertices[i].y = -500;
        }
        vertexts[3] = _d.vertices;

        //init _targetVertexts resource //////////////////////////////////
        // init tween
        _targetVertexs = new Vector.<Vertex>(MAX_NUM, true);
        for (i = 0; i < MAX_NUM; i++) {
            var t1:Vertex = vertexts[0][i];
            var t2:Vertex = vertexts[1][i];
            var t3:Vertex = vertexts[2][i];
            var t4:Vertex = vertexts[3][i];
            //init
            _targetVertexs[i] = t1;
//            floor 2 sphere
            var tw1:TweenLite = TweenLite.to(_targetVertexs[i], 4, {x:t2.x, y:t2.y, z:t2.z,delay:String(1 + (Math.random() - 0.5) * 0.5),ease:Expo.easeInOut});
//            // sphere 2 cube
            var tw2:TweenLite = TweenLite.to(_targetVertexs[i], 3, {x:t3.x, y:t3.y, z:t3.z,delay:String(0.5 + (Math.random() - 0.5) * 0.5),ease:Expo.easeInOut});
//            //cube 2 random
            var tw3:TweenLite = TweenLite.to(_targetVertexs[i], 1, {x:t4.x, y:t4.y, z:t4.z,delay:String(1 + (Math.random() - 0.5) * 0.5),ease:Bounce.easeOut});
//            // random 2 floor
            var tw4:TweenLite = TweenLite.to(_targetVertexs[i], 4, {x:t1.x, y:t1.y, z:t1.z,delay:String(1 + (Math.random() - 0.5) * 0.5),ease:Expo.easeInOut});
//            // delay
//            var tw0:TweenLite = TweenLite.delayedCall(0.75 * i, null);
////            tweenArr[ i ] = BetweenAS3.delay(BetweenAS3.serial(tw1, tw2, tw3, tw4, tw5), ease.calculate(i, 0, 0.75, MAX_NUM));
            var animationSequence:TimelineMax = new TimelineMax();
            animationSequence.append(tw1);
            animationSequence.append(tw2);
            animationSequence.append(tw3);
            animationSequence.append(tw4);
            animationSequence.repeat = -1;
        }
//        function setPosition(i:uint, _t:Vertex):void {
//            _targetVertexs[i].x = _t.x;
//            _targetVertexs[i].y = _t.y;
//            _targetVertexs[i].z = _t.z;
//            animationSequence.play();
    }


    private var rootContainer:Object3DContainer = new Object3DContainer();
    private var viewContainer:ConflictContainer = new ConflictContainer();
    private var controller:SimpleObjectController;

    private function initWorld():void {
        //init container
        //init camera
        camera = new Camera3D();
        camera.view = new View(stage.stageWidth, stage.stageHeight);
        camera.view.hideLogo();

//            camera.x = 500;
//            camera.y = 500;
        camera.z = -(FOCUS_POSITION);
        camera.fov = 300;
//        camera.rotationX = -45;
//        camera.rotationZ = -45;
        camera.lookAt(0, 0, 0);
//        camera.debug = true;
//        camera.addToDebug(Debug.BOUNDS, Sprite3D);

        //init controller
        controller = new SimpleObjectController(stage, camera, 200);

        //add them to the world
        addChild(camera.view);
        addChild(camera.diagram);
        rootContainer.addChild(viewContainer);
        rootContainer.addChild(camera);

    }

    private function initObjs():void {
        //init balls
        _particles = new Vector.<Sprite3D>(MAX_NUM, true);
        for (var i:uint = 0; i < MAX_NUM; i++) {
            var mt:TextureMaterial = _blurs[0];
            var ball:Sprite3D = new Sprite3D(100, 100, mt);
            viewContainer.addChild(ball);
            _particles[i] = ball;
        }
    }

    private function onEventFrameHandler(e:Event):void {
        //update position
        for (var i:uint = 0; i < MAX_NUM; i++) {
            var p:Sprite3D = _particles[i];
            p.x = _targetVertexs[i].x;
            p.y = _targetVertexs[i].y;
            p.z = _targetVertexs[i].z;
//            p.scaleX=p.scaleY=p.scaleZ=Math.sin(getTimer()/150+i*0.04)*0.5+1.1;

            //update position
            var f:Number = Math.abs(distanceBetween(camera, p) - FOCUS_POSITION);
            var deg:Number = (f ^ (f >> 31)) - (f >> 31);
            var blurVal:int = deg * .02 << 1; //ココの調整が絶妙
            blurVal = blurVal > SNOW_MAX_DEPTH - 1 ? SNOW_MAX_DEPTH - 1 : blurVal;
            p.material = _blurs[blurVal];
        }

        function distanceBetween(c:Camera3D, p:Sprite3D):Number {
            var dX:Number = c.x - p.x;
            var dY:Number = c.y - p.y;
            var dZ:Number = c.z - p.z;
            return Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        }

        //update geometry
        
        // rendering
        viewContainer.rotationY += 0.02;
        controller.update();
        camera.render();
    }


}

}
