/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v3Dq
 */

package 
{
    import flash.display.SimpleButton;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    
    /**
     * ボタンを表示するサンプル
     * @author Hikipuro
     */
    public class Main extends Sprite 
    {
        /**
         * 画面上の枠で囲まれた表示領域
         */
        private var text1:TextField;
        
        /**
         * ボタン
         */
        private var button1:SimpleButton;
    
        /**
         * ボタンの上に書かれたラベル
         */
        private var buttonText1:TextField;
        
        /**
         * コンストラクタ
         */
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        /**
         * 初期化メソッド
         * @param    e
         */
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            // テキスト表示部分の作成
            text1 = new TextField();
            text1.text = "ボタンのテスト";
            text1.selectable = false;
            text1.width = 320 - 64;
            text1.height = 40;
            text1.x = 32;
            text1.y = 32;
            text1.border = true;
            text1.borderColor = 0x333333;
            addChild(text1);
            
            // ボタンのラベルの作成
            buttonText1 = new TextField();
            buttonText1.text = "ボタン";
            buttonText1.selectable = false;
            buttonText1.width = 40;
            buttonText1.height = 20;
            buttonText1.x = 135;
            buttonText1.y = 180;
            addChild(buttonText1);
            
            // ボタンの作成
            button1 = new SimpleButton();
            button1.upState = makeRoundRect(0xDDDDDD, 100, 20, 10);
            button1.overState = makeRoundRect(0xFFFFFF, 100, 20, 10);
            button1.downState = makeRoundRect(0xBBBBBB, 100, 20, 10);
            button1.hitTestState = button1.upState;
            button1.addEventListener(MouseEvent.MOUSE_DOWN, onButtonMouseDown);
            button1.addEventListener(MouseEvent.MOUSE_UP, onButtonMouseUp);
            button1.addEventListener(MouseEvent.MOUSE_OVER, onButtonMouseOver);
            button1.addEventListener(MouseEvent.MOUSE_OUT, onButtonMouseOut);
            button1.x = 105;
            button1.y = 180;
            addChild(button1);
        }

        /**
         * ボタンが押された時のイベントハンドラ
         * @param    event
         */
        private function onButtonMouseDown(event:MouseEvent):void
        {
            text1.text = "ボタンが押されました";
        }

        /**
         * ボタンが離された時のイベントハンドラ
         * @param    event
         */
        private function onButtonMouseUp(event:MouseEvent):void
        {
            text1.text = "ボタンが離されました";
        }

        /**
         * マウスオーバー時のイベントハンドラ
         * @param    event
         */
        private function onButtonMouseOver(event:MouseEvent):void
        {
            text1.text = "カーソルがボタンの上に乗りました";
        }

        /**
         * マウスアウト時のイベントハンドラ
         * @param    event
         */
        private function onButtonMouseOut(event:MouseEvent):void
        {
            text1.text = "カーソルがボタンから出ました";
        }
        
        /**
         * 角丸の図形を描いたスプライトを作って返す
         * @param    color    色
         * @param    width    幅
         * @param    height    高さ
         * @param    round    角丸の大きさ
         * @return    スプライト
         */
        private function makeRoundRect(color:uint, width:int, height:int, round:int):Sprite
        {
            var s:Sprite = new Sprite();
            s.graphics.lineStyle(2);
            s.graphics.beginFill(color);
            s.graphics.drawRoundRect(0, 0, width, height, round);
            s.graphics.endFill();
            s.alpha = 0.3;
            return s;
        }
        
    }
    
}