/**
 * Copyright matsu4512 ( http://wonderfl.net/user/matsu4512 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v2uC
 */

package {
    import caurina.transitions.Tweener;
    
    import com.adobe.viewsource.ViewSource;
    
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.utils.Timer;
    
    import org.papervision3d.core.geom.Lines3D;
    import org.papervision3d.materials.special.LineMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.view.BasicView;

    [SWF(backgroundColor=0x000000, width = 800, height=800)]

    public class Papervision10 extends Sprite
    {
        private var rootNode:DisplayObject3D;
        private var lines:Lines3D;
        private var theta:Number=0.01;
        private var r:Number = 100;
        private var toX:Number=0, toY:Number=0, toZ:Number=0;
        private var fromX:Number=0, fromY:Number=0, fromZ:Number=0;
        private var d:Number = 0;
        private var color:uint = 0;
        private var timer:Timer;
        
        public function Papervision10()
        {
            ViewSource.addMenuItem(this, "srcview/index.html");
            
            //初期設定
            var world:BasicView = new BasicView();
            world.startRendering();
            addChild(world);
            
            rootNode = world.scene.addChild(new DisplayObject3D("rootNode"));
            
            stage.addEventListener(MouseEvent.MOUSE_WHEEL, function(event:MouseEvent):void{
                if(event.delta > 0)
                    world.camera.z += 10;
                else
                    world.camera.z -= 10; 
            });
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(event:Event):void{

            rootNode.rotationY -= (stage.mouseX - stage.stageWidth/2)/100;
            rootNode.rotationX -= (stage.mouseY - stage.stageHeight/2)/100;

            toX = Math.cos(theta)*r;
            toY = Math.sin(theta)*r;
            toZ = fromZ+0.5;
                
            var lm:LineMaterial = new LineMaterial(HSBtoRGB(color/255, 1, 1), 1);
            var lines:Lines3D =new Lines3D(lm);
            lines.scale = 0;
            rootNode.addChild(lines);
            
            Tweener.addTween(lines, {scale:1, time:1, delay:d, onComplete:function():void{
                Tweener.addTween(lines, {scale:0, time:1, delay:d+10, onComplete:function():void{
                    rootNode.removeChild(lines);
                }});
            }});
            lines.addNewLine(3, fromX, fromY, fromZ, toX, toY, toZ);
            d += 0.01;
            fromX = toX;
            fromY = toY;
            fromZ = toZ;
            
            theta += 0.1;
            
                        color++;
        }
        
        public static function HSBtoRGB(hue:Number, saturation:Number, brightness:Number):uint
        {
                var r:int = 0;
                var g:int = 0;
                var b:int = 0;
                if (saturation == 0) r = g = b = brightness * 255.0 + 0.5;
                else {
                    var h:Number = (hue - Math.floor(hue)) * 6.0;
                    var f:Number = h - Math.floor(h);
                    var p:Number = brightness * (1.0 - saturation);
                    var q:Number = brightness * (1.0 - saturation * f);
                    var t:Number = brightness * (1.0 - (saturation * (1.0 - f)));
                    switch (int(h)) {
                        case 0:
                            r = brightness * 255.0 + 0.5;
                            g = t * 255.0 + 0.5;
                            b = p * 255.0 + 0.5;
                            break;
                        case 1:
                            r = q * 255.0 + 0.5;
                            g = brightness * 255.0 + 0.5;
                            b = p * 255.0 + 0.5;
                            break;
                        case 2:
                            r = p * 255.0 + 0.5;
                            g = brightness * 255.0 + 0.5;
                            b = t * 255.0 + 0.5;
                            break;
                        case 3:
                            r = p * 255.0 + 0.5;
                            g = q * 255.0 + 0.5;
                            b = brightness * 255.0 + 0.5;
                            break;
                        case 4:
                            r = t * 255.0 + 0.5;
                            g = p * 255.0 + 0.5;
                            b = brightness * 255.0 + 0.5;
                            break;
                        case 5:
                            r = brightness * 255.0 + 0.5;
                            g = p * 255.0 + 0.5;
                            b = q * 255.0 + 0.5;
                            break;
                    }
                }
                return (r << 16) | (g << 8) | (b << 0);
            }
    }
}


