/**
 * Copyright gupon ( http://wonderfl.net/user/gupon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/v2Yr
 */

/*
 * click to change modes
 */
package {
	import __AS3__.vec.Vector;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.Sprite;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
    
    [SWF(backgroundColor="#000000", frameRate="60")]
	public class Balls extends Sprite{
		private static const NUM_BALL:int = 50;
		private var speed:Number = .01;
		private var balls:Vector.<Ball>;
		private var canvas:Sprite;
		private var bmp:Bitmap;
		private var bmpData:BitmapData;
		private var bmpFilter:BlurFilter;
		private var flag:Boolean = false;
		
		public function Balls(){
			addEventListener( Event.ADDED_TO_STAGE, init);
		}
		
		private function init( event:Event ):void{
			removeEventListener( Event.ADDED_TO_STAGE, init );
			stage.scaleMode = StageScaleMode.NO_SCALE;
			canvas = new Sprite();
			bmpData = new BitmapData( stage.stageWidth, stage.stageHeight, false, 0x000000 );
			bmp = new Bitmap( bmpData, "auto", true );
			bmp.blendMode = BlendMode.ADD;
			
			//for thumbnail
			graphics.beginFill(0);
			graphics.drawRect( 0, 0, stage.stageWidth, stage.stageHeight );
			
			addChild( canvas );
			addChild( bmp );
			
			createBalls();
			
			addEventListener( Event.ENTER_FRAME, enterFrame );
			stage.addEventListener( MouseEvent.MOUSE_DOWN, changeFlag );
		}
		
		private function enterFrame( event:Event ):void{
			for each( var ball:Ball in balls ){
				if( flag ){
					ball.ax = ( mouseX - ball.x ) / 5000;
					ball.ay = ( mouseY - ball.y ) / 5000;
				} else {
					ball.ax += Math.random()*speed - speed*.5;
					ball.ay += Math.random()*speed - speed*.5;
				}
				
				var halfW:Number = ball.width / 2;
				if( ball.x - halfW > stage.stageWidth )  ball.x = -halfW;
				else if( ball.x + halfW < 0 ) 			 ball.x = stage.stageWidth + halfW;
				if( ball.y - halfW > stage.stageHeight ) ball.y = -halfW;
				else if( ball.y + halfW < 0 ) 			 ball.y = stage.stageHeight + halfW;
			}
			
			var ctf:ColorTransform = new ColorTransform( 1, 1, 1, .15);
			var bmpFilter:BlurFilter = new BlurFilter( 2, 2, 2 );
			bmpData.draw( canvas, null, ctf, BlendMode.ADD );
			bmpData.applyFilter( bmpData, bmpData.rect, new Point(), bmpFilter );
		}
		
		private function createBalls():void{
			balls = new Vector.<Ball>;
			for( var i:int=0;i<NUM_BALL;i++ ){
				var ball:Ball = new Ball();
				ball.x = Math.random() * stage.stageWidth;
				ball.y = Math.random() * stage.stageHeight;
				canvas.addChild(ball);
				balls.push(ball);
			}
		}
		
		private function changeFlag( event:MouseEvent ):void{
			flag = flag ? false : true;
			for each( var ball:Ball in balls ) ball.flag = flag;
		}
	}
}

	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.utils.Timer;

	class Ball extends Sprite{
		private static const V_MAX:Number = 5;
		private static const A_MAX:Number = .02;
		private var _flag:Boolean = false;
		public var vx:Number = 0;
		public var vy:Number = 0;
		public var ax:Number = 0;
		public var ay:Number = 0;
		
		public function get flag():Boolean{ return _flag };
		public function set flag( value:Boolean ):void{
			_flag = value;
		}
		
		public function Ball(){
			cacheAsBitmap = true;
			drawBall();
			
			var timer:Timer = new Timer(1000);
			timer.addEventListener( TimerEvent.TIMER, drawBall );
			timer.start();
			
			addEventListener( Event.ENTER_FRAME, enterFrame );
		}
		
		private function enterFrame( event:Event ):void{
			if( !flag ){
				if( ax > A_MAX ) ax = A_MAX;
				else if( ax < -A_MAX ) ax = -A_MAX;
				if( ay > A_MAX ) ay = A_MAX;
				else if( ay < -A_MAX ) ay = -A_MAX;
				
				if( vx > V_MAX ) vx = V_MAX;
				else if( vx < -V_MAX ) vx = -V_MAX;
				if( vy > V_MAX ) vy = V_MAX;
				else if( vy < -V_MAX ) vy = -V_MAX;
			}
			
			vx += ax;
			vy += ay;
			x += vx;
			y += vy;
		}
		
		private function drawBall( event:TimerEvent=null ):void{
			var radius:Number = Math.random()*10 + 4;
			graphics.clear();
			graphics.lineStyle(3,0x555555);
			graphics.drawCircle( 0, 0, radius );
			graphics.lineStyle(0);
			var h:Number = flag ? 180 : 0;
			graphics.beginFill( HSVtoRGB(Math.random()*60+h, .5, .9));
			graphics.drawCircle( 0, 0, radius - 3);
		}

		private function HSVtoRGB( h:Number, s:Number, v:Number ):uint{
			var r:Number, g:Number, b:Number;
			if( s != 0 ){
				h %= 360;
				var hi:uint = h / 60 % 6;
				var f:Number = h / 60 - hi;
				var p:Number = v * ( 1 - s );
				var q:Number = v * ( 1 - f * s );
				var t:Number = v * ( 1 - ( 1 - f ) * s );
				switch( hi ){
					case 0: r = v; g = t; b = p; break;
					case 1: r = q; g = v; b = p; break;
					case 2: r = p; g = v; b = t; break;
					case 3: r = p; g = q; b = v; break;
					case 4: r = t; g = p; b = v; break;
					case 5: r = v; g = p; b = q; break;
			 	}
		 } else r = g = b = v;
		 	return ( 0xFF * r << 16 ) + ( 0xFF * g << 8 ) + ( 0xFF * b );
		 }
	}
